/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.light;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import ca.spottedleaf.moonrise.patches.starlight.light.BlockStarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.SkyStarLightEngine;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;

public final class StarLightInterface {
    public static final TicketType CHUNK_WORK_TICKET = ChunkSystemTicketType.create("starlight:chunk_work_ticket", Long::compareTo);
    public static final int LIGHT_TICKET_LEVEL = ChunkLevel.a(ChunkStatus.l);
    public final World world;
    public final ILightAccess lightAccess;
    private static final ThreadLocal<SkyStarLightEngine> SKY_PROPAGATOR = new ThreadLocal();
    private static final ThreadLocal<BlockStarLightEngine> BLOCK_PROPAGATOR = new ThreadLocal();
    private final LightQueue lightQueue;
    private final LightEngineLayerEventListener skyReader;
    private final LightEngineLayerEventListener blockReader;
    private final boolean isClientSide;
    public final int minSection;
    public final int maxSection;
    public final int minLightSection;
    public final int maxLightSection;
    public final LevelLightEngine lightEngine;
    private final boolean hasBlockLight;
    private final boolean hasSkyLight;

    public StarLightInterface(ILightAccess lightAccess, boolean hasSkyLight, boolean hasBlockLight, LevelLightEngine lightEngine) {
        this.lightAccess = lightAccess;
        this.world = lightAccess == null ? null : (World)lightAccess.s();
        boolean bl = this.isClientSide = !(this.world instanceof WorldServer);
        if (this.world == null) {
            this.minSection = -4;
            this.maxSection = 19;
            this.minLightSection = -5;
            this.maxLightSection = 20;
        } else {
            this.minSection = WorldUtil.getMinSection(this.world);
            this.maxSection = WorldUtil.getMaxSection(this.world);
            this.minLightSection = WorldUtil.getMinLightSection(this.world);
            this.maxLightSection = WorldUtil.getMaxLightSection(this.world);
        }
        this.lightQueue = this.world instanceof WorldServer ? new ServerLightQueue(this) : new ClientLightQueue(this);
        this.lightEngine = lightEngine;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
        this.skyReader = !hasSkyLight ? LightEngineLayerEventListener.Void.a : new LightEngineLayerEventListener(){

            @Override
            public void a(BlockPosition blockPos) {
                StarLightInterface.this.lightEngine.a(blockPos.j());
            }

            @Override
            public void b(ChunkCoordIntPair chunkPos) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean O_() {
                return StarLightInterface.this.hasUpdates();
            }

            @Override
            public int a() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void a(ChunkCoordIntPair chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public NibbleArray a(SectionPosition pos) {
                IChunkAccess chunk = StarLightInterface.this.getAnyChunkNow(pos.u(), pos.w());
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.x() || !chunk.n().a(ChunkStatus.l)) {
                    return null;
                }
                int sectionY = pos.v();
                if (sectionY > StarLightInterface.this.maxLightSection || sectionY < StarLightInterface.this.minLightSection) {
                    return null;
                }
                if (chunk.starlight$getSkyEmptinessMap() == null) {
                    return null;
                }
                return chunk.starlight$getSkyNibbles()[sectionY - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            @Override
            public int b(BlockPosition blockPos) {
                return StarLightInterface.this.getSkyLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.u() >> 4, blockPos.w() >> 4));
            }

            @Override
            public void a(SectionPosition pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.blockReader = !hasBlockLight ? LightEngineLayerEventListener.Void.a : new LightEngineLayerEventListener(){

            @Override
            public void a(BlockPosition blockPos) {
                StarLightInterface.this.lightEngine.a(blockPos.j());
            }

            @Override
            public void b(ChunkCoordIntPair chunkPos) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean O_() {
                return StarLightInterface.this.hasUpdates();
            }

            @Override
            public int a() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void a(ChunkCoordIntPair chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public NibbleArray a(SectionPosition pos) {
                IChunkAccess chunk = StarLightInterface.this.getAnyChunkNow(pos.u(), pos.w());
                if (chunk == null || pos.v() < StarLightInterface.this.minLightSection || pos.v() > StarLightInterface.this.maxLightSection) {
                    return null;
                }
                return chunk.starlight$getBlockNibbles()[pos.v() - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            @Override
            public int b(BlockPosition blockPos) {
                return StarLightInterface.this.getBlockLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.u() >> 4, blockPos.w() >> 4));
            }

            @Override
            public void a(SectionPosition pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
    }

    public ClientLightQueue getClientLightQueue() {
        LightQueue lightQueue = this.lightQueue;
        if (lightQueue instanceof ClientLightQueue) {
            ClientLightQueue clientLightQueue = (ClientLightQueue)lightQueue;
            return clientLightQueue;
        }
        return null;
    }

    public ServerLightQueue getServerLightQueue() {
        LightQueue lightQueue = this.lightQueue;
        if (lightQueue instanceof ServerLightQueue) {
            ServerLightQueue serverLightQueue = (ServerLightQueue)lightQueue;
            return serverLightQueue;
        }
        return null;
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean hasBlockLight() {
        return this.hasBlockLight;
    }

    public int getSkyLightValue(BlockPosition blockPos, IChunkAccess chunk) {
        int currY;
        SWMRNibbleArray[] nibbles;
        SWMRNibbleArray immediate;
        if (!this.hasSkyLight) {
            return 0;
        }
        int x2 = blockPos.u();
        int y2 = blockPos.v();
        int z2 = blockPos.w();
        int minSection = this.minSection;
        int maxSection = this.maxSection;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (chunk == null || !this.isClientSide && !chunk.x() || !chunk.n().a(ChunkStatus.l)) {
            return 15;
        }
        int sectionY = y2 >> 4;
        if (sectionY > maxLightSection) {
            return 15;
        }
        if (sectionY < minLightSection) {
            sectionY = minLightSection;
            y2 = sectionY << 4;
        }
        if (!(immediate = (nibbles = chunk.starlight$getSkyNibbles())[sectionY - minLightSection]).isNullNibbleVisible()) {
            return immediate.getVisible(x2, y2, z2);
        }
        boolean[] emptinessMap = chunk.starlight$getSkyEmptinessMap();
        if (emptinessMap == null) {
            return 15;
        }
        int lowestY = minLightSection - 1;
        for (currY = maxSection; currY >= minSection; --currY) {
            if (emptinessMap[currY - minSection]) continue;
            lowestY = currY;
            break;
        }
        if (sectionY > lowestY) {
            return 15;
        }
        for (currY = sectionY + 1; currY <= maxLightSection; ++currY) {
            SWMRNibbleArray nibble = nibbles[currY - minLightSection];
            if (nibble.isNullNibbleVisible()) continue;
            return nibble.getVisible(x2, 0, z2);
        }
        return 15;
    }

    public int getBlockLightValue(BlockPosition blockPos, IChunkAccess chunk) {
        if (!this.hasBlockLight) {
            return 0;
        }
        int y2 = blockPos.v();
        int cy = y2 >> 4;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (cy < minLightSection || cy > maxLightSection) {
            return 0;
        }
        if (chunk == null) {
            return 0;
        }
        SWMRNibbleArray nibble = chunk.starlight$getBlockNibbles()[cy - minLightSection];
        return nibble.getVisible(blockPos.u(), y2, blockPos.w());
    }

    public int getRawBrightness(BlockPosition pos, int ambientDarkness) {
        IChunkAccess chunk = this.getAnyChunkNow(pos.u() >> 4, pos.w() >> 4);
        int sky = this.getSkyLightValue(pos, chunk) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.getBlockLightValue(pos, chunk);
        return Math.max(sky, block);
    }

    public LightEngineLayerEventListener getSkyReader() {
        return this.skyReader;
    }

    public LightEngineLayerEventListener getBlockReader() {
        return this.blockReader;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public IChunkAccess getAnyChunkNow(int chunkX, int chunkZ) {
        if (this.world == null) {
            return null;
        }
        return this.world.moonrise$getAnyChunkIfLoaded(chunkX, chunkZ);
    }

    public boolean hasUpdates() {
        return !this.lightQueue.isEmpty();
    }

    public World getWorld() {
        return this.world;
    }

    public ILightAccess getLightAccess() {
        return this.lightAccess;
    }

    public SkyStarLightEngine getSkyLightEngine() {
        if (!this.hasSkyLight || this.world == null) {
            return null;
        }
        SkyStarLightEngine ret = SKY_PROPAGATOR.get();
        SKY_PROPAGATOR.set(null);
        if (ret == null) {
            ret = new SkyStarLightEngine();
        }
        ret.setWorld(this.world);
        return ret;
    }

    public void releaseSkyLightEngine(SkyStarLightEngine engine) {
        if (engine != null) {
            engine.setWorld(null);
        }
        if (!this.hasSkyLight || this.world == null || SKY_PROPAGATOR.get() != null) {
            return;
        }
        SKY_PROPAGATOR.set(engine);
    }

    public BlockStarLightEngine getBlockLightEngine() {
        if (!this.hasBlockLight || this.world == null) {
            return null;
        }
        BlockStarLightEngine ret = BLOCK_PROPAGATOR.get();
        BLOCK_PROPAGATOR.set(null);
        if (ret == null) {
            ret = new BlockStarLightEngine();
        }
        ret.setWorld(this.world);
        return ret;
    }

    public void releaseBlockLightEngine(BlockStarLightEngine engine) {
        if (engine != null) {
            engine.setWorld(null);
        }
        if (!this.hasBlockLight || this.world == null || BLOCK_PROPAGATOR.get() != null) {
            return;
        }
        BLOCK_PROPAGATOR.set(engine);
    }

    public LightQueue.ChunkTasks blockChange(BlockPosition pos) {
        if (this.world == null || pos.v() < WorldUtil.getMinBlockY(this.world) || pos.v() > WorldUtil.getMaxBlockY(this.world)) {
            return null;
        }
        return this.lightQueue.queueBlockChange(pos);
    }

    public LightQueue.ChunkTasks sectionChange(SectionPosition pos, boolean newEmptyValue) {
        if (this.world == null) {
            return null;
        }
        return this.lightQueue.queueSectionChange(pos, newEmptyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoadInChunk(IChunkAccess chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInChunk(int chunkX, int chunkZ, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(IChunkAccess chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.light(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.light(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relightChunks(Set<ChunkCoordIntPair> chunks, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.relightChunks(this.lightAccess, chunks, blockEngine == null ? chunkLightCallback : null, blockEngine == null ? onComplete : null);
            }
            if (blockEngine != null) {
                blockEngine.relightChunks(this.lightAccess, chunks, chunkLightCallback, onComplete);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void checkChunkEdges(int chunkX, int chunkZ) {
        this.checkSkyEdges(chunkX, chunkZ);
        this.checkBlockEdges(chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void propagateChanges() {
        LightQueue lightQueue = this.lightQueue;
        if (lightQueue instanceof ClientLightQueue) {
            ClientLightQueue clientLightQueue = (ClientLightQueue)lightQueue;
            clientLightQueue.drainTasks();
        }
    }

    public static final class ServerLightQueue
    extends LightQueue {
        private final ConcurrentLong2ReferenceChainedHashTable<ServerChunkTasks> chunkTasks = new ConcurrentLong2ReferenceChainedHashTable();

        public ServerLightQueue(StarLightInterface lightInterface) {
            super(lightInterface);
        }

        public void lowerPriority(int chunkX, int chunkZ, Priority priority) {
            ServerChunkTasks task = (ServerChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                task.lowerPriority(priority);
            }
        }

        public void setPriority(int chunkX, int chunkZ, Priority priority) {
            ServerChunkTasks task = (ServerChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                task.setPriority(priority);
            }
        }

        public void raisePriority(int chunkX, int chunkZ, Priority priority) {
            ServerChunkTasks task = (ServerChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                task.raisePriority(priority);
            }
        }

        public Priority getPriority(int chunkX, int chunkZ) {
            ServerChunkTasks task = (ServerChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                return task.getPriority();
            }
            return Priority.COMPLETING;
        }

        @Override
        public boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        @Override
        public ServerChunkTasks queueBlockChange(BlockPosition pos) {
            ServerChunkTasks ret = (ServerChunkTasks)this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.addChangedPosition(pos);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        @Override
        public ServerChunkTasks queueSectionChange(SectionPosition pos, boolean newEmptyValue) {
            ServerChunkTasks ret = (ServerChunkTasks)this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.setChangedSection(pos.v(), newEmptyValue);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        public ServerChunkTasks queueChunkLightTask(ChunkCoordIntPair pos, BooleanSupplier lightTask, Priority priority) {
            ServerChunkTasks ret = (ServerChunkTasks)this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this, priority);
                }
                valueInMap.addLightTask(lightTask);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        @Override
        public ServerChunkTasks queueChunkSkylightEdgeCheck(SectionPosition pos, ShortCollection sections) {
            ServerChunkTasks ret = (ServerChunkTasks)this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.addEdgeChecksSky(sections);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        @Override
        public ServerChunkTasks queueChunkBlocklightEdgeCheck(SectionPosition pos, ShortCollection sections) {
            ServerChunkTasks ret = (ServerChunkTasks)this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.addEdgeChecksBlock(sections);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        public static final class ServerChunkTasks
        extends LightQueue.ChunkTasks {
            private final AtomicBoolean ticketAdded = new AtomicBoolean();
            private final PrioritisedExecutor.PrioritisedTask task;

            public ServerChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, ServerLightQueue queue) {
                this(chunkCoordinate, lightEngine, queue, Priority.NORMAL);
            }

            public ServerChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, ServerLightQueue queue, Priority priority) {
                super(chunkCoordinate, lightEngine, queue);
                this.task = ((WorldServer)lightEngine.getWorld()).moonrise$getChunkTaskScheduler().radiusAwareScheduler.createTask(CoordinateUtils.getChunkX(chunkCoordinate), CoordinateUtils.getChunkZ(chunkCoordinate), ChunkStatus.l.moonrise$getWriteRadius(), (Runnable)this, priority);
            }

            public boolean markTicketAdded() {
                return !this.ticketAdded.get() && false == this.ticketAdded.compareAndExchange(false, true);
            }

            public void schedule() {
                this.task.queue();
            }

            public boolean cancel() {
                return this.task.cancel();
            }

            public Priority getPriority() {
                return this.task.getPriority();
            }

            public void lowerPriority(Priority priority) {
                this.task.lowerPriority(priority);
            }

            public void setPriority(Priority priority) {
                this.task.setPriority(priority);
            }

            public void raisePriority(Priority priority) {
                this.task.raisePriority(priority);
            }

            @Override
            public void run() {
                ((ServerLightQueue)this.queue).chunkTasks.remove(this.chunkCoordinate, (Object)this);
                this.runTasks();
            }
        }
    }

    public static abstract class LightQueue {
        protected final StarLightInterface lightInterface;

        public LightQueue(StarLightInterface lightInterface) {
            this.lightInterface = lightInterface;
        }

        public abstract boolean isEmpty();

        public abstract ChunkTasks queueBlockChange(BlockPosition var1);

        public abstract ChunkTasks queueSectionChange(SectionPosition var1, boolean var2);

        public abstract ChunkTasks queueChunkSkylightEdgeCheck(SectionPosition var1, ShortCollection var2);

        public abstract ChunkTasks queueChunkBlocklightEdgeCheck(SectionPosition var1, ShortCollection var2);

        public static abstract class ChunkTasks
        implements Runnable {
            public final long chunkCoordinate;
            protected final StarLightInterface lightEngine;
            protected final LightQueue queue;
            protected final MultiThreadedQueue<Runnable> onComplete = new MultiThreadedQueue();
            protected final Set<BlockPosition> changedPositions = new HashSet<BlockPosition>();
            protected Boolean[] changedSectionSet;
            protected ShortOpenHashSet queuedEdgeChecksSky;
            protected ShortOpenHashSet queuedEdgeChecksBlock;
            protected List<BooleanSupplier> lightTasks;

            public ChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, LightQueue queue) {
                this.chunkCoordinate = chunkCoordinate;
                this.lightEngine = lightEngine;
                this.queue = queue;
            }

            @Override
            public abstract void run();

            public void queueOrRunTask(Runnable run) {
                if (!this.onComplete.add((Object)run)) {
                    run.run();
                }
            }

            protected void addChangedPosition(BlockPosition pos) {
                this.changedPositions.add(pos.j());
            }

            protected void setChangedSection(int y2, Boolean newEmptyValue) {
                if (this.changedSectionSet == null) {
                    this.changedSectionSet = new Boolean[this.lightEngine.maxSection - this.lightEngine.minSection + 1];
                }
                this.changedSectionSet[y2 - this.lightEngine.minSection] = newEmptyValue;
            }

            protected void addLightTask(BooleanSupplier lightTask) {
                if (this.lightTasks == null) {
                    this.lightTasks = new ArrayList<BooleanSupplier>();
                }
                this.lightTasks.add(lightTask);
            }

            protected void addEdgeChecksSky(ShortCollection values) {
                if (this.queuedEdgeChecksSky == null) {
                    this.queuedEdgeChecksSky = new ShortOpenHashSet(Math.max(8, values.size()));
                }
                this.queuedEdgeChecksSky.addAll(values);
            }

            protected void addEdgeChecksBlock(ShortCollection values) {
                if (this.queuedEdgeChecksBlock == null) {
                    this.queuedEdgeChecksBlock = new ShortOpenHashSet(Math.max(8, values.size()));
                }
                this.queuedEdgeChecksBlock.addAll(values);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final void runTasks() {
                Runnable run;
                boolean litChunk = false;
                if (this.lightTasks != null) {
                    for (BooleanSupplier run2 : this.lightTasks) {
                        if (!run2.getAsBoolean()) continue;
                        litChunk = true;
                        break;
                    }
                }
                if (!litChunk) {
                    SkyStarLightEngine skyEngine = this.lightEngine.getSkyLightEngine();
                    BlockStarLightEngine blockEngine = this.lightEngine.getBlockLightEngine();
                    try {
                        long coordinate = this.chunkCoordinate;
                        int chunkX = CoordinateUtils.getChunkX(coordinate);
                        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
                        Set<BlockPosition> positions = this.changedPositions;
                        Boolean[] sectionChanges = this.changedSectionSet;
                        if (!(skyEngine == null || positions.isEmpty() && sectionChanges == null)) {
                            skyEngine.blocksChangedInChunk(this.lightEngine.getLightAccess(), chunkX, chunkZ, positions, sectionChanges);
                        }
                        if (!(blockEngine == null || positions.isEmpty() && sectionChanges == null)) {
                            blockEngine.blocksChangedInChunk(this.lightEngine.getLightAccess(), chunkX, chunkZ, positions, sectionChanges);
                        }
                        if (skyEngine != null && this.queuedEdgeChecksSky != null) {
                            skyEngine.checkChunkEdges(this.lightEngine.getLightAccess(), chunkX, chunkZ, (ShortCollection)this.queuedEdgeChecksSky);
                        }
                        if (blockEngine != null && this.queuedEdgeChecksBlock != null) {
                            blockEngine.checkChunkEdges(this.lightEngine.getLightAccess(), chunkX, chunkZ, (ShortCollection)this.queuedEdgeChecksBlock);
                        }
                    }
                    finally {
                        this.lightEngine.releaseSkyLightEngine(skyEngine);
                        this.lightEngine.releaseBlockLightEngine(blockEngine);
                    }
                }
                while ((run = (Runnable)this.onComplete.pollOrBlockAdds()) != null) {
                    run.run();
                }
            }
        }
    }

    public static final class ClientLightQueue
    extends LightQueue {
        private final Long2ObjectLinkedOpenHashMap<ClientChunkTasks> chunkTasks = new Long2ObjectLinkedOpenHashMap();

        public ClientLightQueue(StarLightInterface lightInterface) {
            super(lightInterface);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        private ClientChunkTasks getOrCreate(long key) {
            return (ClientChunkTasks)this.chunkTasks.computeIfAbsent(key, keyInMap -> new ClientChunkTasks(keyInMap, this.lightInterface, this));
        }

        @Override
        public synchronized ClientChunkTasks queueBlockChange(BlockPosition pos) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.addChangedPosition(pos);
            return tasks;
        }

        @Override
        public synchronized ClientChunkTasks queueSectionChange(SectionPosition pos, boolean newEmptyValue) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.setChangedSection(pos.v(), newEmptyValue);
            return tasks;
        }

        @Override
        public synchronized ClientChunkTasks queueChunkSkylightEdgeCheck(SectionPosition pos, ShortCollection sections) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.addEdgeChecksSky(sections);
            return tasks;
        }

        @Override
        public synchronized ClientChunkTasks queueChunkBlocklightEdgeCheck(SectionPosition pos, ShortCollection sections) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.addEdgeChecksBlock(sections);
            return tasks;
        }

        public synchronized ClientChunkTasks removeFirstTask() {
            if (this.chunkTasks.isEmpty()) {
                return null;
            }
            return (ClientChunkTasks)this.chunkTasks.removeFirst();
        }

        public void drainTasks() {
            ClientChunkTasks task;
            while ((task = this.removeFirstTask()) != null) {
                task.runTasks();
            }
        }

        public static final class ClientChunkTasks
        extends LightQueue.ChunkTasks {
            public ClientChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, ClientLightQueue queue) {
                super(chunkCoordinate, lightEngine, queue);
            }

            @Override
            public void run() {
                this.runTasks();
            }
        }
    }
}

