/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.SkinParts;
import com.google.common.base.Objects;
import java.util.StringJoiner;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperSkinParts
implements SkinParts {
    private final int raw;

    public PaperSkinParts(int raw) {
        this.raw = raw;
    }

    private static boolean isPartShown(int raw, PlayerModelPart part) {
        return ((byte)raw & part.a()) == part.a();
    }

    private static int setPartShown(int raw, PlayerModelPart part, boolean shown) {
        raw = shown ? (raw |= part.a()) : (raw &= ~part.a());
        return raw;
    }

    public boolean hasCapeEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.a);
    }

    public boolean hasJacketEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.b);
    }

    public boolean hasLeftSleeveEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.c);
    }

    public boolean hasRightSleeveEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.d);
    }

    public boolean hasLeftPantsEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.e);
    }

    public boolean hasRightPantsEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.f);
    }

    public boolean hasHatsEnabled() {
        return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.g);
    }

    public int getRaw() {
        return this.raw;
    }

    public SkinParts.Mutable mutableCopy() {
        return new Mutable(this.raw);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        PaperSkinParts that = (PaperSkinParts)o2;
        return this.raw == that.raw;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.raw});
    }

    public String toString() {
        return PaperSkinParts.toString(this, "PaperSkinParts");
    }

    private static String toString(SkinParts parts, String name) {
        return new StringJoiner(", ", name + "[", "]").add("raw=" + parts.getRaw()).add("cape=" + parts.hasCapeEnabled()).add("jacket=" + parts.hasJacketEnabled()).add("leftSleeve=" + parts.hasLeftSleeveEnabled()).add("rightSleeve=" + parts.hasRightSleeveEnabled()).add("leftPants=" + parts.hasLeftPantsEnabled()).add("rightPants=" + parts.hasRightPantsEnabled()).add("hats=" + parts.hasHatsEnabled()).toString();
    }

    public static final class Mutable
    implements SkinParts.Mutable {
        private int raw;

        public Mutable(int raw) {
            this.raw = raw;
        }

        public void setCapeEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.a, enabled);
        }

        public void setJacketEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.b, enabled);
        }

        public void setLeftSleeveEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.c, enabled);
        }

        public void setRightSleeveEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.d, enabled);
        }

        public void setLeftPantsEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.e, enabled);
        }

        public void setRightPantsEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.f, enabled);
        }

        public void setHatsEnabled(boolean enabled) {
            this.raw = PaperSkinParts.setPartShown(this.raw, PlayerModelPart.g, enabled);
        }

        public boolean hasCapeEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.a);
        }

        public boolean hasJacketEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.b);
        }

        public boolean hasLeftSleeveEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.c);
        }

        public boolean hasRightSleeveEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.d);
        }

        public boolean hasLeftPantsEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.e);
        }

        public boolean hasRightPantsEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.f);
        }

        public boolean hasHatsEnabled() {
            return PaperSkinParts.isPartShown(this.raw, PlayerModelPart.g);
        }

        public int getRaw() {
            return this.raw;
        }

        public SkinParts immutableCopy() {
            return new PaperSkinParts(this.raw);
        }

        public SkinParts.Mutable mutableCopy() {
            return new Mutable(this.raw);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Mutable that = (Mutable)o2;
            return this.raw == that.raw;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.raw});
        }

        public String toString() {
            return PaperSkinParts.toString((SkinParts)this, "PaperSkinParts.Mutable");
        }
    }
}

