/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.loottable.LootableInventory;
import com.destroystokyo.paper.loottable.LootableInventoryReplenishEvent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DurationOrDisabled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperLootableInventoryData {
    private static final Random RANDOM = new Random();
    private long lastFill = -1L;
    private long nextRefill = -1L;
    private int numRefills = 0;
    private @Nullable Map<UUID, Long> lootedPlayers;
    public static final LootTableInterface<RandomizableContainer> CONTAINER = new LootTableInterface<RandomizableContainer>(){

        @Override
        public WorldConfiguration paperConfig(RandomizableContainer holder) {
            return Objects.requireNonNull(holder.j(), "Can only manager loot replenishment on block entities in a world").paperConfig();
        }

        @Override
        public void setSeed(RandomizableContainer holder, long seed) {
            holder.a(seed);
        }

        @Override
        public boolean hasLootTable(RandomizableContainer holder) {
            return holder.az_() != null;
        }

        @Override
        public LootableInventory getInventoryForEvent(RandomizableContainer holder) {
            return holder.getLootableInventory();
        }
    };
    public static final LootTableInterface<ContainerEntity> ENTITY = new LootTableInterface<ContainerEntity>(){

        @Override
        public WorldConfiguration paperConfig(ContainerEntity holder) {
            return holder.an().paperConfig();
        }

        @Override
        public void setSeed(ContainerEntity holder, long seed) {
            holder.a(seed);
        }

        @Override
        public boolean hasLootTable(ContainerEntity holder) {
            return holder.q() != null;
        }

        @Override
        public LootableInventory getInventoryForEvent(ContainerEntity holder) {
            return holder.getLootableInventory();
        }
    };
    private static final String ROOT = "Paper.LootableData";
    private static final String LAST_FILL = "lastFill";
    private static final String NEXT_REFILL = "nextRefill";
    private static final String NUM_REFILLS = "numRefills";
    private static final String LOOTED_PLAYERS = "lootedPlayers";

    public long getLastFill() {
        return this.lastFill;
    }

    long getNextRefill() {
        return this.nextRefill;
    }

    long setNextRefill(long nextRefill) {
        long prev = this.nextRefill;
        this.nextRefill = nextRefill;
        return prev;
    }

    public <T> boolean shouldReplenish(T lootTableHolder, LootTableInterface<T> holderInterface, @Nullable EntityHuman player) {
        if (!holderInterface.hasLootTable(lootTableHolder)) {
            return false;
        }
        if (this.lastFill == -1L || !holderInterface.paperConfig(lootTableHolder).lootables.autoReplenish) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (this.nextRefill == -1L) {
            return false;
        }
        WorldConfiguration paperConfig = holderInterface.paperConfig(lootTableHolder);
        if (paperConfig.lootables.maxRefills != -1 && this.numRefills >= paperConfig.lootables.maxRefills) {
            return false;
        }
        if (this.nextRefill > System.currentTimeMillis()) {
            return false;
        }
        Player bukkitPlayer = (Player)player.getBukkitEntity();
        LootableInventoryReplenishEvent event = new LootableInventoryReplenishEvent(bukkitPlayer, holderInterface.getInventoryForEvent(lootTableHolder));
        event.setCancelled(!this.canPlayerLoot(player.cT(), paperConfig));
        return event.callEvent();
    }

    public <T> boolean shouldClearLootTable(T lootTableHolder, LootTableInterface<T> holderInterface, @Nullable EntityHuman player) {
        this.lastFill = System.currentTimeMillis();
        WorldConfiguration paperConfig = holderInterface.paperConfig(lootTableHolder);
        if (paperConfig.lootables.autoReplenish) {
            long min = paperConfig.lootables.refreshMin.seconds();
            long max = paperConfig.lootables.refreshMax.seconds();
            this.nextRefill = this.lastFill + (min + RANDOM.nextLong(max - min + 1L)) * 1000L;
            ++this.numRefills;
            if (paperConfig.lootables.resetSeedOnFill) {
                holderInterface.setSeed(lootTableHolder, 0L);
            }
            if (player != null) {
                this.setPlayerLootedState(player.cT(), true);
            }
            return false;
        }
        return true;
    }

    public void loadNbt(ValueInput input) {
        ValueInput data = input.b(ROOT);
        this.lastFill = data.a(LAST_FILL, -1L);
        this.nextRefill = data.a(NEXT_REFILL, -1L);
        this.numRefills = data.a(NUM_REFILLS, 0);
        ValueInput.a<SerializedLootedPlayerEntry> list = data.c(LOOTED_PLAYERS, SerializedLootedPlayerEntry.CODEC);
        if (!list.a()) {
            this.lootedPlayers = new HashMap<UUID, Long>();
            list.forEach(serializedLootedPlayerEntry -> this.lootedPlayers.put(serializedLootedPlayerEntry.uuid, serializedLootedPlayerEntry.time));
        }
    }

    public void saveNbt(ValueOutput output) {
        ValueOutput data = output.a(ROOT);
        if (this.nextRefill != -1L) {
            data.a(NEXT_REFILL, this.nextRefill);
        }
        if (this.lastFill != -1L) {
            data.a(LAST_FILL, this.lastFill);
        }
        if (this.numRefills != 0) {
            data.a(NUM_REFILLS, this.numRefills);
        }
        if (this.lootedPlayers != null && !this.lootedPlayers.isEmpty()) {
            ValueOutput.a<SerializedLootedPlayerEntry> list = data.a(LOOTED_PLAYERS, SerializedLootedPlayerEntry.CODEC);
            for (Map.Entry<UUID, Long> entry : this.lootedPlayers.entrySet()) {
                list.a(new SerializedLootedPlayerEntry(entry.getKey(), entry.getValue()));
            }
        }
        if (data.a()) {
            output.c(ROOT);
        }
    }

    void setPlayerLootedState(UUID player, boolean looted) {
        if (looted && this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (looted) {
            this.lootedPlayers.put(player, System.currentTimeMillis());
        } else if (this.lootedPlayers != null) {
            this.lootedPlayers.remove(player);
        }
    }

    boolean canPlayerLoot(UUID player, WorldConfiguration worldConfiguration) {
        @Nullable Long lastLooted = this.getLastLooted(player);
        if (!worldConfiguration.lootables.restrictPlayerReloot || lastLooted == null) {
            return true;
        }
        DurationOrDisabled restrictPlayerRelootTime = worldConfiguration.lootables.restrictPlayerRelootTime;
        if (restrictPlayerRelootTime.value().isEmpty()) {
            return false;
        }
        return TimeUnit.SECONDS.toMillis(restrictPlayerRelootTime.value().get().seconds()) + lastLooted < System.currentTimeMillis();
    }

    boolean hasPlayerLooted(UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    @Nullable Long getLastLooted(UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }

    public static interface LootTableInterface<T> {
        public WorldConfiguration paperConfig(T var1);

        public void setSeed(T var1, long var2);

        public boolean hasLootTable(T var1);

        public LootableInventory getInventoryForEvent(T var1);
    }

    record SerializedLootedPlayerEntry(UUID uuid, long time) {
        public static final Codec<SerializedLootedPlayerEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("UUID").forGetter(SerializedLootedPlayerEntry::uuid), (App)Codec.LONG.optionalFieldOf("Time", (Object)0L).forGetter(SerializedLootedPlayerEntry::time)).apply((Applicative)instance, SerializedLootedPlayerEntry::new));
    }
}

