/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.GivensParameters;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MatrixUtil {
    private static final float a = 3.0f + 2.0f * Math.sqrt((float)2.0f);
    private static final GivensParameters b = GivensParameters.a(0.7853982f);

    private MatrixUtil() {
    }

    public static Matrix4f a(Matrix4f matrix, float scalar) {
        return matrix.set(matrix.m00() * scalar, matrix.m01() * scalar, matrix.m02() * scalar, matrix.m03() * scalar, matrix.m10() * scalar, matrix.m11() * scalar, matrix.m12() * scalar, matrix.m13() * scalar, matrix.m20() * scalar, matrix.m21() * scalar, matrix.m22() * scalar, matrix.m23() * scalar, matrix.m30() * scalar, matrix.m31() * scalar, matrix.m32() * scalar, matrix.m33() * scalar);
    }

    private static GivensParameters a(float topCorner, float oppositeDiagonalAverage, float bottomCorner) {
        float f2 = 2.0f * (topCorner - bottomCorner);
        return a * oppositeDiagonalAverage * oppositeDiagonalAverage < f2 * f2 ? GivensParameters.a(oppositeDiagonalAverage, f2) : b;
    }

    private static GivensParameters a(float input1, float input2) {
        float f2 = (float)java.lang.Math.hypot(input1, input2);
        float f1 = f2 > 1.0E-6f ? input2 : 0.0f;
        float f22 = Math.abs((float)input1) + Math.max((float)f2, (float)1.0E-6f);
        if (input1 < 0.0f) {
            float f3 = f1;
            f1 = f22;
            f22 = f3;
        }
        return GivensParameters.a(f1, f22);
    }

    private static void a(Matrix3f input, Matrix3f tempStorage) {
        input.mul((Matrix3fc)tempStorage);
        tempStorage.transpose();
        tempStorage.mul((Matrix3fc)input);
        input.set((Matrix3fc)tempStorage);
    }

    private static void a(Matrix3f input, Matrix3f tempStorage, Quaternionf resultEigenvector, Quaternionf resultEigenvalue) {
        Quaternionf quaternionf;
        GivensParameters givensParameters;
        if (input.m01 * input.m01 + input.m10 * input.m10 > 1.0E-6f) {
            givensParameters = MatrixUtil.a(input.m00, 0.5f * (input.m01 + input.m10), input.m11);
            quaternionf = givensParameters.c(resultEigenvector);
            resultEigenvalue.mul((Quaternionfc)quaternionf);
            givensParameters.c(tempStorage);
            MatrixUtil.a(input, tempStorage);
        }
        if (input.m02 * input.m02 + input.m20 * input.m20 > 1.0E-6f) {
            givensParameters = MatrixUtil.a(input.m00, 0.5f * (input.m02 + input.m20), input.m22).a();
            quaternionf = givensParameters.b(resultEigenvector);
            resultEigenvalue.mul((Quaternionfc)quaternionf);
            givensParameters.b(tempStorage);
            MatrixUtil.a(input, tempStorage);
        }
        if (input.m12 * input.m12 + input.m21 * input.m21 > 1.0E-6f) {
            givensParameters = MatrixUtil.a(input.m11, 0.5f * (input.m12 + input.m21), input.m22);
            quaternionf = givensParameters.a(resultEigenvector);
            resultEigenvalue.mul((Quaternionfc)quaternionf);
            givensParameters.a(tempStorage);
            MatrixUtil.a(input, tempStorage);
        }
    }

    public static Quaternionf a(Matrix3f input, int iterations) {
        Quaternionf quaternionf = new Quaternionf();
        Matrix3f matrix3f = new Matrix3f();
        Quaternionf quaternionf1 = new Quaternionf();
        for (int i2 = 0; i2 < iterations; ++i2) {
            MatrixUtil.a(input, matrix3f, quaternionf1, quaternionf);
        }
        quaternionf.normalize();
        return quaternionf;
    }

    public static Triple<Quaternionf, Vector3f, Quaternionf> a(Matrix3f matrix) {
        Matrix3f matrix3f = new Matrix3f((Matrix3fc)matrix);
        matrix3f.transpose();
        matrix3f.mul((Matrix3fc)matrix);
        Quaternionf quaternionf = MatrixUtil.a(matrix3f, 5);
        float f2 = matrix3f.m00;
        float f1 = matrix3f.m11;
        boolean flag = (double)f2 < 1.0E-6;
        boolean flag1 = (double)f1 < 1.0E-6;
        Matrix3f matrix3f2 = matrix.rotate((Quaternionfc)quaternionf);
        Quaternionf quaternionf1 = new Quaternionf();
        Quaternionf quaternionf2 = new Quaternionf();
        GivensParameters givensParameters = flag ? MatrixUtil.a(matrix3f2.m11, -matrix3f2.m10) : MatrixUtil.a(matrix3f2.m00, matrix3f2.m01);
        Quaternionf quaternionf3 = givensParameters.c(quaternionf2);
        Matrix3f matrix3f3 = givensParameters.c(matrix3f);
        quaternionf1.mul((Quaternionfc)quaternionf3);
        matrix3f3.transpose().mul((Matrix3fc)matrix3f2);
        givensParameters = flag ? MatrixUtil.a(matrix3f3.m22, -matrix3f3.m20) : MatrixUtil.a(matrix3f3.m00, matrix3f3.m02);
        givensParameters = givensParameters.a();
        Quaternionf quaternionf4 = givensParameters.b(quaternionf2);
        Matrix3f matrix3f4 = givensParameters.b(matrix3f2);
        quaternionf1.mul((Quaternionfc)quaternionf4);
        matrix3f4.transpose().mul((Matrix3fc)matrix3f3);
        givensParameters = flag1 ? MatrixUtil.a(matrix3f4.m22, -matrix3f4.m21) : MatrixUtil.a(matrix3f4.m11, matrix3f4.m12);
        Quaternionf quaternionf5 = givensParameters.a(quaternionf2);
        Matrix3f matrix3f5 = givensParameters.a(matrix3f3);
        quaternionf1.mul((Quaternionfc)quaternionf5);
        matrix3f5.transpose().mul((Matrix3fc)matrix3f4);
        Vector3f vector3f = new Vector3f(matrix3f5.m00, matrix3f5.m11, matrix3f5.m22);
        return Triple.of((Object)quaternionf1, (Object)vector3f, (Object)quaternionf.conjugate());
    }

    private static boolean b(Matrix4fc matrix, int property) {
        return (matrix.properties() & property) != 0;
    }

    public static boolean a(Matrix4fc matrix, int property) {
        if (MatrixUtil.b(matrix, property)) {
            return true;
        }
        if (matrix instanceof Matrix4f) {
            Matrix4f matrix4f = (Matrix4f)matrix;
            matrix4f.determineProperties();
            return MatrixUtil.b(matrix, property);
        }
        return false;
    }

    public static boolean a(Matrix4fc matrix) {
        return MatrixUtil.a(matrix, 4);
    }

    public static boolean b(Matrix4fc matrix) {
        return MatrixUtil.a(matrix, 8);
    }

    public static boolean c(Matrix4fc matrix) {
        return MatrixUtil.a(matrix, 16);
    }
}

