/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.command.PaperSubcommand;
import io.papermc.paper.command.subcommands.ChunkDebugCommand;
import io.papermc.paper.command.subcommands.FixLightCommand;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.Strategy;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class FeatureHooks {
    public static Iterable<net.minecraft.world.entity.Entity> getAllEntities(WorldServer world) {
        return ((EntityLookup)world.K()).getAllMapped();
    }

    public static void setPlayerChunkUnloadDelay(long ticks) {
        RegionizedPlayerChunkLoader.setUnloadDelay(ticks);
    }

    public static void registerPaperCommands(Map<Set<String>, PaperSubcommand> commands) {
        commands.put(Set.of("fixlight"), new FixLightCommand());
        commands.put(Set.of("debug", "chunkinfo", "holderinfo"), new ChunkDebugCommand());
    }

    public static ChunkSection createSection(PalettedContainerFactory palettedContainerFactory, World level, ChunkCoordIntPair chunkPos, int chunkSection) {
        return new ChunkSection(palettedContainerFactory, level, chunkPos, chunkSection);
    }

    public static void sendChunkRefreshPackets(List<EntityPlayer> playersInRange, net.minecraft.world.level.chunk.Chunk chunk) {
        HashMap<Object, ClientboundLevelChunkWithLightPacket> refreshPackets = new HashMap<Object, ClientboundLevelChunkWithLightPacket>();
        for (EntityPlayer player : playersInRange) {
            if (player.g == null) continue;
            Boolean shouldModify = chunk.I().chunkPacketBlockController.shouldModify(player, chunk);
            player.g.b(refreshPackets.computeIfAbsent(shouldModify, s2 -> new ClientboundLevelChunkWithLightPacket(chunk, chunk.q.E_(), null, null, (Boolean)s2)));
        }
    }

    public static DataPaletteBlock<IBlockData> emptyPalettedBlockContainer() {
        return new DataPaletteBlock<IBlockData>(Blocks.a.m(), Strategy.a(Block.k), null);
    }

    public static Set<Long> getSentChunkKeys(EntityPlayer player) {
        return LongSets.unmodifiable((LongSet)player.moonrise$getChunkLoader().getSentChunksRaw().clone());
    }

    public static Set<Chunk> getSentChunks(EntityPlayer player) {
        if (player.moonrise$getChunkLoader() == null) {
            return ObjectSets.EMPTY_SET;
        }
        LongOpenHashSet rawChunkKeys = player.moonrise$getChunkLoader().getSentChunksRaw();
        ObjectOpenHashSet chunks = new ObjectOpenHashSet(rawChunkKeys.size());
        CraftWorld world = player.A().getWorld();
        LongIterator iter = player.moonrise$getChunkLoader().getSentChunksRaw().longIterator();
        while (iter.hasNext()) {
            chunks.add((Object)world.getChunkAt(iter.nextLong(), false));
        }
        return ObjectSets.unmodifiable((ObjectSet)chunks);
    }

    public static boolean isChunkSent(EntityPlayer player, long chunkKey) {
        return player.moonrise$getChunkLoader() != null && player.moonrise$getChunkLoader().getSentChunksRaw().contains(chunkKey);
    }

    public static boolean isSpiderCollidingWithWorldBorder(EntitySpider spider) {
        return CollisionUtil.isCollidingWithBorder(spider.an().u(), spider.de().g(1.0E-7));
    }

    public static void dumpAllChunkLoadInfo(MinecraftServer server, boolean isLongTimeout) {
        ChunkTaskScheduler.dumpAllChunkLoadInfo(server, isLongTimeout);
    }

    private static void dumpEntity(net.minecraft.world.entity.Entity entity) {
    }

    public static Entity[] getChunkEntities(WorldServer world, int chunkX, int chunkZ) {
        return world.getChunkEntities(chunkX, chunkZ);
    }

    public static Collection<Plugin> getPluginChunkTickets(WorldServer world, int x2, int z2) {
        return world.moonrise$getChunkTaskScheduler().chunkHolderManager.getPluginChunkTickets(x2, z2);
    }

    public static Map<Plugin, Collection<Chunk>> getPluginChunkTickets(WorldServer world) {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        PlayerChunkMap.a chunkDistanceManager = world.n().a.G;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.moonrise$getChunkHolderManager().getTicketsCopy().long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            Collection tickets = (Collection)chunkTickets.getValue();
            Chunk chunk = null;
            for (Ticket ticket : tickets) {
                if (ticket.a() != TicketType.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = world.getWorld().getChunkAt(ChunkCoordIntPair.a(chunkKey), ChunkCoordIntPair.b(chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.getIdentifier(), key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    public static int getViewDistance(WorldServer world) {
        return world.moonrise$getPlayerChunkLoader().getAPIViewDistance();
    }

    public static int getSimulationDistance(WorldServer world) {
        return world.moonrise$getPlayerChunkLoader().getAPITickDistance();
    }

    public static int getSendViewDistance(WorldServer world) {
        return world.moonrise$getPlayerChunkLoader().getAPISendViewDistance();
    }

    public static void setViewDistance(WorldServer world, int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("View distance " + distance + " is out of range of [2, 32]");
        }
        world.H.a.a(distance);
    }

    public static void setSimulationDistance(WorldServer world, int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Simulation distance " + distance + " is out of range of [2, 32]");
        }
        world.H.a.G.b(distance);
    }

    public static void setSendViewDistance(WorldServer world, int distance) {
        world.H.setSendViewDistance(distance);
    }

    public static void tickEntityManager(WorldServer world) {
    }

    public static void closeEntityManager(WorldServer world, boolean save) {
    }

    public static Executor getWorldgenExecutor() {
        return Runnable::run;
    }

    public static void setViewDistance(EntityPlayer player, int distance) {
        player.moonrise$getViewDistanceHolder().setLoadViewDistance(distance == -1 ? distance : distance + 1);
    }

    public static void setSimulationDistance(EntityPlayer player, int distance) {
        player.moonrise$getViewDistanceHolder().setTickViewDistance(distance);
    }

    public static void setSendViewDistance(EntityPlayer player, int distance) {
        player.moonrise$getViewDistanceHolder().setSendViewDistance(distance);
    }
}

