/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure.providers;

import com.google.common.base.Predicates;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.dialog.PaperDialogResponseView;
import io.papermc.paper.registry.data.dialog.action.DialogActionCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;

public class ClickCallbackProviderImpl
implements ClickCallback.Provider {
    private static final Key ADVENTURE_CLICK_CALLBACK_KEY = Key.key((String)"paper", (String)"click_callback");
    public static final Key DIALOG_CLICK_CALLBACK_KEY = Key.key((String)"paper", (String)"dialog_click_callback");
    public static final String ID_KEY = "id";
    public static final AdventureClick ADVENTURE_CLICK_MANAGER = new AdventureClick();
    public static final DialogClickManager DIALOG_CLICK_MANAGER = new DialogClickManager();

    @NotNull
    public ClickEvent create(@NotNull ClickCallback<Audience> callback, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ClickCallback.Options options) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.a(ID_KEY, UUIDUtil.a, ADVENTURE_CLICK_MANAGER.addCallback(callback, options));
        return ClickEvent.custom((Key)ADVENTURE_CLICK_CALLBACK_KEY, (BinaryTagHolder)PaperAdventure.asBinaryTagHolder(tag));
    }

    public static final class AdventureClick
    extends CallbackManager<ClickCallback<Audience>, UUID> {
        private AdventureClick() {
            super(PaperAdventure.asVanilla(ADVENTURE_CLICK_CALLBACK_KEY)::equals);
        }

        public UUID addCallback(@NotNull ClickCallback<Audience> callback, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ClickCallback.Options options) {
            return (UUID)this.addCallback(UUID.randomUUID(), callback, options);
        }

        @Override
        void doRunCallback(@NotNull Audience audience, Key key, NBTBase tag) {
            tag.u_().ifPresent(t2 -> {
                Optional<UUID> id = t2.a(ClickCallbackProviderImpl.ID_KEY, UUIDUtil.a);
                if (id.isEmpty()) {
                    return;
                }
                this.tryConsumeCallback(id.get(), callback -> callback.accept(audience));
            });
        }
    }

    public static final class DialogClickManager
    extends CallbackManager<DialogActionCallback, UUID> {
        public DialogClickManager() {
            super(PaperAdventure.asVanilla(DIALOG_CLICK_CALLBACK_KEY)::equals);
        }

        @Override
        void doRunCallback(@NotNull Audience audience, Key key, NBTBase tag) {
            tag.u_().ifPresent(t2 -> {
                Optional<UUID> id = t2.a(ClickCallbackProviderImpl.ID_KEY, UUIDUtil.a);
                if (id.isEmpty()) {
                    return;
                }
                this.tryConsumeCallback(id.get(), callback -> callback.accept(PaperDialogResponseView.createUnvalidatedResponse(t2), audience));
            });
        }
    }

    public static final class StoredCallback<C, I> {
        private final long startedAt = System.nanoTime();
        private final C callback;
        private final long lifetime;
        private final I id;
        private int remainingUses;

        private StoredCallback(@NotNull C callback, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ClickCallback.Options options, I id) {
            long lifetimeValue;
            this.callback = callback;
            try {
                lifetimeValue = options.lifetime().toNanos();
            }
            catch (ArithmeticException ex) {
                lifetimeValue = Long.MAX_VALUE;
            }
            this.lifetime = lifetimeValue;
            this.remainingUses = options.uses();
            this.id = id;
        }

        private void takeUse() {
            if (this.remainingUses != -1) {
                --this.remainingUses;
            }
        }

        public boolean hasRemainingUses() {
            return this.remainingUses == -1 || this.remainingUses > 0;
        }

        public boolean expired() {
            if (this.lifetime == Long.MAX_VALUE) {
                return false;
            }
            return System.nanoTime() - this.startedAt >= this.lifetime;
        }

        private boolean valid() {
            return this.hasRemainingUses() && !this.expired();
        }

        public I id() {
            return this.id;
        }
    }

    static abstract class CallbackManager<C, I> {
        private final Predicate<MinecraftKey> locationPredicate;
        protected final Map<I, StoredCallback<C, I>> callbacks = new HashMap<I, StoredCallback<C, I>>();
        private final Queue<StoredCallback<C, I>> queue = new ConcurrentLinkedQueue<StoredCallback<C, I>>();

        protected CallbackManager(Predicate<MinecraftKey> locationPredicate) {
            this.locationPredicate = locationPredicate;
        }

        protected CallbackManager() {
            this.locationPredicate = Predicates.alwaysTrue();
        }

        public I addCallback(I id, @NotNull C callback, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ClickCallback.Options options) {
            this.queue.add(new StoredCallback<C, I>(callback, options, id));
            return id;
        }

        public void handleQueue(int currentTick) {
            StoredCallback<C, I> callback2;
            if (currentTick % 100 == 0) {
                this.callbacks.values().removeIf(callback -> !callback.valid());
            }
            while ((callback2 = this.queue.poll()) != null) {
                this.callbacks.put(callback2.id(), callback2);
            }
        }

        final void tryConsumeCallback(I key, Consumer<? super C> callbackConsumer) {
            StoredCallback<C, I> callback = this.callbacks.get(key);
            if (callback != null && callback.valid()) {
                callback.takeUse();
                callbackConsumer.accept(callback.callback);
            }
        }

        abstract void doRunCallback(@NotNull Audience var1, Key var2, NBTBase var3);

        public final void tryRunCallback(@NotNull Audience audience, MinecraftKey key, Optional<? extends NBTBase> tag) {
            if (!this.locationPredicate.test(key) || tag.isEmpty()) {
                return;
            }
            this.doRunCallback(audience, PaperAdventure.asAdventure(key), tag.get());
        }
    }
}

