/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure.providers;

import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.DataComponentValueConverterRegistry;
import net.kyori.adventure.text.serializer.gson.GsonDataComponentValue;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.resources.RegistryOps;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class DataComponentValueConverterProviderImpl
implements DataComponentValueConverterRegistry.Provider {
    static final Key ID = Key.key((String)"adventure", (String)"platform/paper");

    public Key id() {
        return ID;
    }

    private static <T> RegistryOps<T> createOps(DynamicOps<T> delegate) {
        return CraftRegistry.getMinecraftRegistry().a(delegate);
    }

    public Iterable<DataComponentValueConverterRegistry.Conversion<?, ?>> conversions() {
        return List.of(DataComponentValueConverterRegistry.Conversion.convert(PaperAdventure.DataComponentValueImpl.class, GsonDataComponentValue.class, (key, dataComponentValue) -> GsonDataComponentValue.gsonDataComponentValue((JsonElement)((JsonElement)dataComponentValue.codec().encodeStart(DataComponentValueConverterProviderImpl.createOps(JsonOps.INSTANCE), dataComponentValue.value()).getOrThrow()))), DataComponentValueConverterRegistry.Conversion.convert(GsonDataComponentValue.class, PaperAdventure.DataComponentValueImpl.class, (key, dataComponentValue) -> {
            @Nullable DataComponentType<?> type = BuiltInRegistries.an.a(PaperAdventure.asVanilla(key));
            if (type == null) {
                throw new IllegalArgumentException("Unknown data component type: " + String.valueOf(key));
            }
            return new PaperAdventure.DataComponentValueImpl<Object>(type.c(), type.c().parse(DataComponentValueConverterProviderImpl.createOps(JsonOps.INSTANCE), (Object)dataComponentValue.element()).getOrThrow(IllegalArgumentException::new));
        }), DataComponentValueConverterRegistry.Conversion.convert(PaperAdventure.DataComponentValueImpl.class, DataComponentValue.TagSerializable.class, (key, dataComponentValue) -> BinaryTagHolder.encode((Object)((NBTBase)dataComponentValue.codec().encodeStart(DataComponentValueConverterProviderImpl.createOps(DynamicOpsNBT.a), dataComponentValue.value()).getOrThrow()), PaperAdventure.NBT_CODEC)), DataComponentValueConverterRegistry.Conversion.convert(DataComponentValue.TagSerializable.class, PaperAdventure.DataComponentValueImpl.class, (key, tagSerializable) -> {
            @Nullable DataComponentType<?> type = BuiltInRegistries.an.a(PaperAdventure.asVanilla(key));
            if (type == null) {
                throw new IllegalArgumentException("Unknown data component type: " + String.valueOf(key));
            }
            try {
                return new PaperAdventure.DataComponentValueImpl<Object>(type.c(), type.c().parse(DataComponentValueConverterProviderImpl.createOps(DynamicOpsNBT.a), (Object)((NBTBase)tagSerializable.asBinaryTag().get(PaperAdventure.NBT_CODEC))).getOrThrow(IllegalArgumentException::new));
            }
            catch (CommandSyntaxException e2) {
                throw new IllegalArgumentException(e2);
            }
        }), DataComponentValueConverterRegistry.Conversion.convert(DataComponentValue.TagSerializable.class, GsonDataComponentValue.class, (key, tagSerializable) -> {
            NBTBase decodedSnbt;
            try {
                decodedSnbt = (NBTBase)tagSerializable.asBinaryTag().get(PaperAdventure.NBT_CODEC);
            }
            catch (CommandSyntaxException e2) {
                throw new IllegalArgumentException("Unable to parse SNBT value", e2);
            }
            return GsonDataComponentValue.gsonDataComponentValue((JsonElement)((JsonElement)DynamicOpsNBT.a.a(JsonOps.INSTANCE, decodedSnbt)));
        }));
    }
}

