/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command;

import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.MSPTCommand;
import io.papermc.paper.command.PaperCommand;
import io.papermc.paper.command.PaperPluginsCommand;
import io.papermc.paper.command.PaperVersionCommand;
import io.papermc.paper.command.brigadier.CommandRegistrationFlag;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.bukkit.command.Command;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class PaperCommands {
    private static final Map<String, Command> COMMANDS = new HashMap<String, Command>();

    private PaperCommands() {
    }

    public static void registerCommands(MinecraftServer server) {
        COMMANDS.put("paper", new PaperCommand("paper"));
        COMMANDS.put("mspt", new MSPTCommand("mspt"));
        COMMANDS.forEach((s2, command) -> server.server.getCommandMap().register(s2, "Paper", command));
    }

    public static void registerCommands() {
        PaperCommands.registerInternalCommand(PaperVersionCommand.create(), "bukkit", "Gets the version of this server including any plugins in use", List.of("ver", "about"), Set.of());
        PaperCommands.registerInternalCommand(PaperPluginsCommand.create(), "bukkit", "Gets a list of plugins running on the server", List.of("pl"), Set.of());
    }

    private static void registerInternalCommand(LiteralCommandNode<CommandSourceStack> node, String namespace, String description, List<String> aliases, Set<CommandRegistrationFlag> flags) {
        io.papermc.paper.command.brigadier.PaperCommands.INSTANCE.registerWithFlagsInternal(null, namespace, "Paper", node, description, aliases, flags);
    }
}

