/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier;

import com.google.common.collect.Collections2;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.ShadowBrigNode;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import io.papermc.paper.command.brigadier.argument.VanillaArgumentProviderImpl;
import io.papermc.paper.command.brigadier.argument.WrappedArgumentCommandNode;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApiMirrorRootNode
extends RootCommandNode<CommandSourceStack> {
    private static final Set<Class<? extends ArgumentType<?>>> ARGUMENT_WHITELIST = Set.of(BoolArgumentType.class, DoubleArgumentType.class, FloatArgumentType.class, IntegerArgumentType.class, LongArgumentType.class, StringArgumentType.class);

    public static void validatePrimitiveType(ArgumentType<?> type) {
        VanillaArgumentProviderImpl.NativeWrapperArgumentType nativeWrapperArgumentType;
        if (ARGUMENT_WHITELIST.contains(type.getClass())) {
            if (!ArgumentTypeInfos.a(type.getClass())) {
                throw new IllegalArgumentException("This whitelisted primitive argument type is not recognized by the server!");
            }
        } else if (!(type instanceof VanillaArgumentProviderImpl.NativeWrapperArgumentType) || !ArgumentTypeInfos.a((nativeWrapperArgumentType = (VanillaArgumentProviderImpl.NativeWrapperArgumentType)type).nativeNmsArgumentType().getClass())) {
            throw new IllegalArgumentException("Custom argument type was passed, this was not a recognized type to send to the client! You must only pass vanilla arguments or primitive brig args in the wrapper!");
        }
    }

    public abstract CommandDispatcher<CommandListenerWrapper> getDispatcher();

    @NotNull
    private CommandNode<CommandSourceStack> unwrapNode(CommandNode<CommandSourceStack> maybeWrappedNode) {
        if (maybeWrappedNode instanceof ShadowBrigNode) {
            ShadowBrigNode shadowBrigNode = (ShadowBrigNode)maybeWrappedNode;
            return shadowBrigNode.getHandle();
        }
        if (maybeWrappedNode.unwrappedCached != null) {
            return maybeWrappedNode.unwrappedCached;
        }
        return this.convertFromPureBrigNode(maybeWrappedNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private CommandNode<CommandSourceStack> convertFromPureBrigNode(CommandNode<CommandSourceStack> pureNode) {
        CommandNode<CommandSourceStack> converted;
        if (pureNode instanceof LiteralCommandNode) {
            LiteralCommandNode node = (LiteralCommandNode)pureNode;
            converted = this.simpleUnwrap(node);
        } else if (pureNode instanceof ArgumentCommandNode) {
            ArgumentCommandNode pureArgumentNode = (ArgumentCommandNode)pureNode;
            ArgumentType pureArgumentType = pureArgumentNode.getType();
            if (pureArgumentType instanceof CustomArgumentType) {
                SuggestionProvider suggestionProvider;
                CustomArgumentType customArgumentType = (CustomArgumentType)pureArgumentType;
                try {
                    Method listSuggestions = customArgumentType.getClass().getMethod("listSuggestions", CommandContext.class, SuggestionsBuilder.class);
                    suggestionProvider = listSuggestions.getDeclaringClass() != CustomArgumentType.class ? (arg_0, arg_1) -> ((CustomArgumentType)customArgumentType).listSuggestions(arg_0, arg_1) : null;
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalStateException("Could not determine if the custom argument type " + String.valueOf(customArgumentType) + " overrides listSuggestions", ex);
                }
                converted = this.unwrapArgumentWrapper(pureArgumentNode, (ArgumentType)customArgumentType, customArgumentType.getNativeType(), suggestionProvider);
            } else if (pureArgumentType instanceof VanillaArgumentProviderImpl.NativeWrapperArgumentType) {
                VanillaArgumentProviderImpl.NativeWrapperArgumentType nativeWrapperArgumentType = (VanillaArgumentProviderImpl.NativeWrapperArgumentType)pureArgumentType;
                converted = this.unwrapArgumentWrapper(pureArgumentNode, nativeWrapperArgumentType, nativeWrapperArgumentType, null);
            } else {
                if (!ArgumentTypeInfos.a(pureArgumentType.getClass())) throw new IllegalArgumentException("Custom unknown argument type was passed, should be wrapped inside an CustomArgumentType.");
                converted = this.simpleUnwrap((CommandNode<CommandSourceStack>)pureArgumentNode);
            }
        } else {
            if (pureNode != this) throw new IllegalArgumentException("Unknown command node passed. Don't know how to unwrap this.");
            return this.getDispatcher().getRoot();
        }
        converted.wrappedCached = pureNode;
        pureNode.unwrappedCached = converted;
        for (CommandNode<CommandSourceStack> child : pureNode.getChildren()) {
            converted.addChild(this.unwrapNode(child));
        }
        return converted;
    }

    @Nullable
    private CommandNode<CommandSourceStack> wrapNode(@Nullable CommandNode<CommandListenerWrapper> unwrapped) {
        ShadowBrigNode shadow;
        if (unwrapped == null) {
            return null;
        }
        if (unwrapped.wrappedCached != null) {
            return unwrapped.wrappedCached;
        }
        unwrapped.wrappedCached = shadow = new ShadowBrigNode(unwrapped);
        return shadow;
    }

    public void addChild(CommandNode<CommandSourceStack> node) {
        CommandNode<CommandSourceStack> convertedNode = this.unwrapNode(node);
        this.getDispatcher().getRoot().addChild(convertedNode);
    }

    public Collection<CommandNode<CommandSourceStack>> getChildren() {
        return Collections2.transform((Collection)this.getDispatcher().getRoot().getChildren(), this::wrapNode);
    }

    public CommandNode<CommandSourceStack> getChild(String name) {
        return this.wrapNode(this.getDispatcher().getRoot().getChild(name));
    }

    public void removeCommand(String name) {
        this.getDispatcher().getRoot().removeCommand(name);
    }

    public void clearAll() {
        this.getDispatcher().getRoot().clearAll();
    }

    private CommandNode<CommandSourceStack> unwrapArgumentWrapper(ArgumentCommandNode pureNode, ArgumentType pureArgumentType, ArgumentType possiblyWrappedNativeArgumentType, @Nullable SuggestionProvider argumentTypeSuggestionProvider) {
        ArgumentType argumentType;
        SuggestionProvider suggestionProvider;
        ApiMirrorRootNode.validatePrimitiveType(possiblyWrappedNativeArgumentType);
        CommandNode<CommandSourceStack> redirectNode = pureNode.getRedirect() == null ? null : this.unwrapNode(pureNode.getRedirect());
        SuggestionProvider suggestionProvider2 = suggestionProvider = pureNode.getCustomSuggestions() != null ? pureNode.getCustomSuggestions() : argumentTypeSuggestionProvider;
        if (possiblyWrappedNativeArgumentType instanceof VanillaArgumentProviderImpl.NativeWrapperArgumentType) {
            VanillaArgumentProviderImpl.NativeWrapperArgumentType nativeWrapperArgumentType = (VanillaArgumentProviderImpl.NativeWrapperArgumentType)possiblyWrappedNativeArgumentType;
            argumentType = nativeWrapperArgumentType.nativeNmsArgumentType();
        } else {
            argumentType = possiblyWrappedNativeArgumentType;
        }
        ArgumentType nativeArgumentType = argumentType;
        return new WrappedArgumentCommandNode(pureNode.getName(), pureArgumentType, nativeArgumentType, (Command<CommandSourceStack>)pureNode.getCommand(), pureNode.getRequirement(), redirectNode, (RedirectModifier<CommandSourceStack>)pureNode.getRedirectModifier(), pureNode.isFork(), (SuggestionProvider<CommandSourceStack>)suggestionProvider);
    }

    private CommandNode<CommandSourceStack> simpleUnwrap(CommandNode<CommandSourceStack> node) {
        return ((ArgumentBuilder)node.createBuilder().forward(node.getRedirect() == null ? null : this.unwrapNode(node.getRedirect()), node.getRedirectModifier(), node.isFork())).build();
    }
}

