/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.CommandUtil;
import io.papermc.paper.command.PaperSubcommand;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class DumpItemCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.doDumpItem(sender, args.length > 0 && "all".equals(args[0]));
        return true;
    }

    private void doDumpItem(CommandSender sender, boolean includeAllComponents) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command");
            return;
        }
        Player player = (Player)sender;
        ItemStack itemStack = CraftItemStack.asNMSCopy(player.getInventory().getItemInMainHand());
        TextComponent.Builder visualOutput = Component.text();
        StringBuilder itemCommandBuilder = new StringBuilder();
        String itemName = itemStack.i().e().orElseThrow().a().toString();
        itemCommandBuilder.append(itemName);
        visualOutput.append((Component)Component.text((String)itemName, (TextColor)NamedTextColor.YELLOW));
        Set<DataComponentType> referencedComponentTypes = Collections.newSetFromMap(new IdentityHashMap());
        DataComponentPatch patch = itemStack.d();
        referencedComponentTypes.addAll(patch.b().stream().map(Map.Entry::getKey).toList());
        DataComponentMap prototype = itemStack.h().f();
        if (includeAllComponents) {
            referencedComponentTypes.addAll(prototype.b());
        }
        IRegistryCustom.Dimension access = ((CraftServer)sender.getServer()).getServer().bg();
        RegistryOps<NBTBase> ops = access.a(DynamicOpsNBT.a);
        IRegistry<DataComponentType<?>> registry = access.f(Registries.r);
        ArrayList<ComponentBuilder> componentComponents = new ArrayList<ComponentBuilder>();
        ArrayList<CallSite> commandComponents = new ArrayList<CallSite>();
        for (DataComponentType type : referencedComponentTypes) {
            NBTBase serialized;
            String path = registry.d(type).orElseThrow().a().a();
            @Nullable Optional<T> patchedValue = patch.a(type);
            @Nullable TypedDataComponent<T> prototypeValue = prototype.b(type);
            if (patchedValue != null) {
                if (patchedValue.isEmpty()) {
                    componentComponents.add(Component.text().append(new Component[]{Component.text((char)'!', (TextColor)NamedTextColor.RED), Component.text((String)path, (TextColor)NamedTextColor.AQUA)}));
                    commandComponents.add((CallSite)((Object)("!" + path)));
                    continue;
                }
                serialized = (NBTBase)type.c().encodeStart(ops, patchedValue.get()).getOrThrow();
                DumpItemCommand.writeComponentValue(componentComponents::add, commandComponents::add, path, serialized);
                continue;
            }
            if (!includeAllComponents || prototypeValue == null) continue;
            serialized = (NBTBase)prototypeValue.a(ops).getOrThrow();
            DumpItemCommand.writeComponentValue(componentComponents::add, commandComponents::add, path, serialized);
        }
        if (!componentComponents.isEmpty()) {
            visualOutput.append(new Component[]{Component.text((String)"[", (TextColor)TextColor.color((int)8982734)), Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)",", (TextColor)NamedTextColor.GRAY)), componentComponents), Component.text((String)"]", (TextColor)TextColor.color((int)8982734))});
            itemCommandBuilder.append("[").append(String.join((CharSequence)",", commandComponents)).append("]");
        }
        player.sendMessage(((TextComponent)visualOutput.build()).compact());
        TextComponent copyMsg = Component.text((String)"Click to copy item definition to clipboard for use with /give", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});
        sender.sendMessage(copyMsg.clickEvent(ClickEvent.copyToClipboard((String)itemCommandBuilder.toString())));
    }

    private static void writeComponentValue(Consumer<Component> visualOutput, Consumer<String> commandOutput, String path, NBTBase serialized) {
        visualOutput.accept((Component)Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)path, (TextColor)TextColor.color((int)0xFF7FD7)), Component.text((String)"=", (TextColor)NamedTextColor.WHITE), PaperAdventure.asAdventure(GameProfileSerializer.b(serialized))}));
        commandOutput.accept(path + "=" + new SnbtPrinterTagVisitor("", 0, new ArrayList<String>()).a(serialized));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        if (args.length == 1) {
            return CommandUtil.getListMatchingLast(sender, args, "all");
        }
        return Collections.emptyList();
    }
}

