/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import io.papermc.paper.command.PaperSubcommand;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.entrypoint.classloader.group.LockingClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.PaperPluginClassLoaderStorage;
import io.papermc.paper.plugin.entrypoint.classloader.group.SimpleListPluginClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.SpigotPluginClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.StaticPluginClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.dependency.MetaDependencyTree;
import io.papermc.paper.plugin.entrypoint.dependency.SimpleMetaDependencyTree;
import io.papermc.paper.plugin.entrypoint.strategy.ProviderConfiguration;
import io.papermc.paper.plugin.entrypoint.strategy.modern.ModernPluginLoadingStrategy;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import io.papermc.paper.plugin.storage.ConfiguredProviderStorage;
import io.papermc.paper.plugin.storage.ProviderStorage;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class DumpPluginsCommand
implements PaperSubcommand {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");

    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.dumpPlugins(sender, args);
        return true;
    }

    private void dumpPlugins(CommandSender sender, String[] args) {
        Path parent = Path.of("debug", new String[0]);
        Path path = parent.resolve("plugin-info-" + FORMATTER.format(LocalDateTime.now()) + ".json");
        try {
            Files.createDirectories(parent, new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            sender.sendMessage(((TextComponent)Component.text((String)"Writing plugin information into directory", (TextColor)NamedTextColor.GREEN).appendSpace()).append(((TextComponent)Component.text((String)parent.toString(), (TextColor)NamedTextColor.WHITE).hoverEvent((HoverEventSource)Component.text((String)"Click to copy the full path of debug directory", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.copyToClipboard((String)parent.toAbsolutePath().toString()))));
            JsonObject data = this.writeDebug();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent(" ");
            jsonWriter.setStrictness(Strictness.STRICT);
            Streams.write((JsonElement)data, (JsonWriter)jsonWriter);
            try (PrintStream out = new PrintStream(Files.newOutputStream(path, new OpenOption[0]), false, StandardCharsets.UTF_8);){
                out.print(stringWriter);
            }
            sender.sendMessage(((TextComponent)Component.text((String)"Successfully written plugin debug information into", (TextColor)NamedTextColor.GREEN).appendSpace()).append(((TextComponent)Component.text((String)path.toString(), (TextColor)NamedTextColor.WHITE).hoverEvent((HoverEventSource)Component.text((String)"Click to copy the full path of the file", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.copyToClipboard((String)path.toAbsolutePath().toString()))));
        }
        catch (Throwable e2) {
            sender.sendMessage((Component)Component.text((String)"Failed to write plugin information! See the console for more info.", (TextColor)NamedTextColor.RED));
            MinecraftServer.m.warn("Error occurred while dumping plugin info", e2);
        }
    }

    private JsonObject writeDebug() {
        JsonObject root = new JsonObject();
        if (ConfiguredProviderStorage.LEGACY_PLUGIN_LOADING) {
            root.addProperty("legacy-loading-strategy", Boolean.valueOf(true));
        }
        this.writeProviders(root);
        this.writePlugins(root);
        this.writeClassloaders(root);
        return root;
    }

    private void writeProviders(JsonObject root) {
        JsonObject rootProviders = new JsonObject();
        root.add("providers", (JsonElement)rootProviders);
        for (Map.Entry<Entrypoint<?>, ProviderStorage<?>> entry : LaunchEntryPointHandler.INSTANCE.getStorage().entrySet()) {
            JsonObject entrypoint = new JsonObject();
            JsonArray providers = new JsonArray();
            entrypoint.add("providers", (JsonElement)providers);
            ArrayList pluginProviders = new ArrayList();
            for (PluginProvider<?> provider : entry.getValue().getRegisteredProviders()) {
                JsonObject providerObj = new JsonObject();
                providerObj.addProperty("name", provider.getMeta().getName());
                providerObj.addProperty("version", provider.getMeta().getVersion());
                providerObj.addProperty("dependencies", provider.getMeta().getPluginDependencies().toString());
                providerObj.addProperty("soft-dependencies", provider.getMeta().getPluginSoftDependencies().toString());
                providerObj.addProperty("load-before", provider.getMeta().getLoadBeforePlugins().toString());
                providers.add((JsonElement)providerObj);
                pluginProviders.add(provider);
            }
            final JsonArray loadOrder = new JsonArray();
            entrypoint.add("load-order", (JsonElement)loadOrder);
            ModernPluginLoadingStrategy<Object> modernPluginLoadingStrategy = new ModernPluginLoadingStrategy<Object>(new ProviderConfiguration<Object>(this){

                @Override
                public void applyContext(PluginProvider<Object> provider, DependencyContext dependencyContext) {
                }

                @Override
                public boolean load(PluginProvider<Object> provider, Object provided) {
                    return true;
                }

                @Override
                public boolean preloadProvider(PluginProvider<Object> provider) {
                    loadOrder.add(provider.getMeta().getName());
                    return false;
                }
            });
            modernPluginLoadingStrategy.loadProviders(pluginProviders, (MetaDependencyTree)new SimpleMetaDependencyTree((MutableGraph<String>)GraphBuilder.directed().build()));
            rootProviders.add(entry.getKey().getDebugName(), (JsonElement)entrypoint);
        }
    }

    private void writePlugins(JsonObject root) {
        JsonArray rootPlugins = new JsonArray();
        root.add("plugins", (JsonElement)rootPlugins);
        for (Plugin plugin : PaperPluginManagerImpl.getInstance().getPlugins()) {
            rootPlugins.add(plugin.toString());
        }
    }

    private void writeClassloaders(JsonObject root) {
        JsonObject classLoadersRoot = new JsonObject();
        root.add("classloaders", (JsonElement)classLoadersRoot);
        PaperPluginClassLoaderStorage storage = (PaperPluginClassLoaderStorage)PaperClassLoaderStorage.instance();
        classLoadersRoot.addProperty("global", storage.getGlobalGroup().toString());
        classLoadersRoot.addProperty("dependency_graph", PaperPluginManagerImpl.getInstance().getInstanceManagerGraph().toString());
        JsonArray array = new JsonArray();
        classLoadersRoot.add("children", (JsonElement)array);
        for (PluginClassLoaderGroup group : storage.getGroups()) {
            array.add((JsonElement)this.writeClassloader(group));
        }
    }

    private JsonObject writeClassloader(PluginClassLoaderGroup group) {
        JsonObject classLoadersRoot = new JsonObject();
        if (group instanceof SimpleListPluginClassLoaderGroup) {
            SimpleListPluginClassLoaderGroup listGroup = (SimpleListPluginClassLoaderGroup)group;
            JsonArray array = new JsonArray();
            classLoadersRoot.addProperty("main", listGroup.toString());
            if (group instanceof StaticPluginClassLoaderGroup) {
                StaticPluginClassLoaderGroup staticPluginClassLoaderGroup = (StaticPluginClassLoaderGroup)group;
                classLoadersRoot.addProperty("plugin-holder", staticPluginClassLoaderGroup.getPluginClassloader().toString());
            } else if (group instanceof SpigotPluginClassLoaderGroup) {
                SpigotPluginClassLoaderGroup spigotPluginClassLoaderGroup = (SpigotPluginClassLoaderGroup)group;
                classLoadersRoot.addProperty("plugin-holder", spigotPluginClassLoaderGroup.getPluginClassLoader().toString());
            }
            classLoadersRoot.add("children", (JsonElement)array);
            for (ConfiguredPluginClassLoader innerGroup : listGroup.getClassLoaders()) {
                array.add(this.writeClassloader(innerGroup));
            }
        } else {
            if (group instanceof LockingClassLoaderGroup) {
                LockingClassLoaderGroup locking = (LockingClassLoaderGroup)group;
                return this.writeClassloader(locking.getParent());
            }
            classLoadersRoot.addProperty("raw", group.toString());
        }
        return classLoadersRoot;
    }

    private JsonElement writeClassloader(ConfiguredPluginClassLoader innerGroup) {
        return new JsonPrimitive(innerGroup.toString());
    }
}

