/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration;

import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.ConfigurationPart;
import io.papermc.paper.configuration.constraint.Constraints;
import io.papermc.paper.configuration.serializer.collection.map.WriteKeyBack;
import io.papermc.paper.configuration.type.number.DoubleOr;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.util.sanitizer.ItemObfuscationBinding;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Items;
import org.bukkit.Bukkit;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.PostProcess;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.objectmapping.meta.Setting;

public class GlobalConfiguration
extends ConfigurationPart {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final int CURRENT_VERSION = 31;
    private static GlobalConfiguration instance;
    public static boolean isFirstStart;
    public ChunkLoadingBasic chunkLoadingBasic;
    public ChunkLoadingAdvanced chunkLoadingAdvanced;
    @Setting(value="_version")
    public int version = 31;
    public Messages messages;
    public Spark spark;
    public Proxies proxies;
    public Console console;
    public Watchdog watchdog;
    public SpamLimiter spamLimiter;
    public UnsupportedSettings unsupportedSettings;
    public Commands commands;
    public Logging logging;
    public Scoreboards scoreboards;
    public ChunkSystem chunkSystem;
    public ItemValidation itemValidation;
    public PacketLimiter packetLimiter;
    public Collisions collisions;
    public PlayerAutoSave playerAutoSave;
    public Misc misc;
    public BlockUpdates blockUpdates;
    public Anticheat anticheat;

    public static GlobalConfiguration get() {
        return instance;
    }

    static void set(GlobalConfiguration instance) {
        GlobalConfiguration.instance = instance;
    }

    static {
        isFirstStart = false;
    }

    public class Anticheat
    extends ConfigurationPart {
        public Obfuscation obfuscation;

        public Anticheat(GlobalConfiguration this$0) {
        }

        public class Obfuscation
        extends ConfigurationPart {
            public Items items;

            public Obfuscation(Anticheat this$1) {
            }

            public class Items
            extends ConfigurationPart {
                public boolean enableItemObfuscation = false;
                public ItemObfuscationBinding.AssetObfuscationConfiguration allModels = new ItemObfuscationBinding.AssetObfuscationConfiguration(true, Set.of(DataComponents.ah), Set.of());
                public Map<MinecraftKey, ItemObfuscationBinding.AssetObfuscationConfiguration> modelOverrides = Map.of(Objects.requireNonNull(net.minecraft.world.item.Items.pq.f().a(DataComponents.i)), new ItemObfuscationBinding.AssetObfuscationConfiguration(true, Set.of(DataComponents.e), Set.of()));
                public transient ItemObfuscationBinding binding;

                public Items(Obfuscation this$2) {
                }

                @PostProcess
                public void bindDataSanitizer() {
                    this.binding = new ItemObfuscationBinding(this);
                }
            }
        }
    }

    public class BlockUpdates
    extends ConfigurationPart {
        public boolean disableNoteblockUpdates = false;
        public boolean disableTripwireUpdates = false;
        public boolean disableChorusPlantUpdates = false;
        public boolean disableMushroomBlockUpdates = false;

        public BlockUpdates(GlobalConfiguration this$0) {
        }
    }

    public class Misc
    extends ConfigurationPart {
        public ChatThreads chatThreads;
        public int maxJoinsPerTick = 5;
        public boolean sendFullPosForItemEntities = false;
        public boolean loadPermissionsYmlBeforePlugins = true;
        @Constraints.Min(value=4)
        public int regionFileCacheSize = 256;
        @Comment(value="See https://luckformula.emc.gs")
        public boolean useAlternativeLuckFormula = false;
        public boolean useDimensionTypeForCustomSpawners = false;
        public boolean strictAdvancementDimensionCheck = false;
        public IntOr.Default compressionLevel = IntOr.Default.USE_DEFAULT;
        @Comment(value="Defines the leniency distance added on the server to the interaction range of a player when validating interact packets.")
        public DoubleOr.Default clientInteractionLeniencyDistance = DoubleOr.Default.USE_DEFAULT;
        @Comment(value="Defines how many orbs groups can exist in an area.")
        @Constraints.Min(value=1)
        public IntOr.Default xpOrbGroupsPerArea = IntOr.Default.USE_DEFAULT;
        @Comment(value="See Fix MC-163962; prevent villager demand from going negative.")
        public boolean preventNegativeVillagerDemand = false;
        @Comment(value="Whether the nether dimension is enabled and will be loaded.")
        public boolean enableNether = true;

        public Misc(GlobalConfiguration this$0) {
        }

        public class ChatThreads
        extends ConfigurationPart {
            private int chatExecutorCoreSize = -1;
            private int chatExecutorMaxSize = -1;

            public ChatThreads(Misc this$1) {
            }

            @PostProcess
            private void postProcess() {
                int _chatExecutorCoreSize;
                if (MinecraftServer.getServer() == null) {
                    return;
                }
                int _chatExecutorMaxSize = this.chatExecutorMaxSize <= 0 ? Integer.MAX_VALUE : this.chatExecutorMaxSize;
                if (_chatExecutorMaxSize < (_chatExecutorCoreSize = Math.max(this.chatExecutorCoreSize, 0))) {
                    _chatExecutorMaxSize = _chatExecutorCoreSize;
                }
                ThreadPoolExecutor executor = (ThreadPoolExecutor)MinecraftServer.getServer().chatExecutor;
                executor.setCorePoolSize(_chatExecutorCoreSize);
                executor.setMaximumPoolSize(_chatExecutorMaxSize);
            }
        }
    }

    public class PlayerAutoSave
    extends ConfigurationPart {
        public int rate = -1;
        private int maxPerTick = -1;

        public PlayerAutoSave(GlobalConfiguration this$0) {
        }

        public int maxPerTick() {
            if (this.maxPerTick < 0) {
                return this.rate == 1 || this.rate > 100 ? 10 : 20;
            }
            return this.maxPerTick;
        }
    }

    public class Collisions
    extends ConfigurationPart {
        public boolean enablePlayerCollisions = true;
        public boolean sendFullPosForHardCollidingEntities = true;

        public Collisions(GlobalConfiguration this$0) {
        }
    }

    public class PacketLimiter
    extends ConfigurationPart {
        public Component kickMessage = Component.translatable((String)"disconnect.exceeded_packet_rate", (TextColor)NamedTextColor.RED);
        public PacketLimit allPackets = new PacketLimit(7.0, 500.0, PacketLimit.ViolateAction.KICK);
        public Map<@WriteKeyBack Class<? extends Packet<?>>, PacketLimit> overrides = Map.of(PacketPlayInAutoRecipe.class, new PacketLimit(4.0, 5.0, PacketLimit.ViolateAction.DROP));

        public PacketLimiter(GlobalConfiguration this$0) {
        }

        @ConfigSerializable
        public record PacketLimit(@Required double interval, @Required double maxPacketRate, ViolateAction action) {
            public PacketLimit(double interval, double maxPacketRate, @Nullable ViolateAction action) {
                this.interval = interval;
                this.maxPacketRate = maxPacketRate;
                this.action = Objects.requireNonNullElse(action, ViolateAction.KICK);
            }

            public boolean isEnabled() {
                return this.interval > 0.0 && this.maxPacketRate > 0.0;
            }

            public static enum ViolateAction {
                KICK,
                DROP;

            }
        }
    }

    public class ItemValidation
    extends ConfigurationPart {
        public int displayName = 8192;
        public int loreLine = 8192;
        public Book book;
        public BookSize bookSize;
        public boolean resolveSelectorsInBooks = false;

        public ItemValidation(GlobalConfiguration this$0) {
        }

        public class BookSize
        extends ConfigurationPart {
            public IntOr.Disabled pageMax = new IntOr.Disabled(OptionalInt.of(2560));
            public double totalMultiplier = 0.98;

            public BookSize(ItemValidation this$1) {
            }
        }

        public class Book
        extends ConfigurationPart {
            public int title = 8192;
            public int author = 8192;
            public int page = 16384;

            public Book(ItemValidation this$1) {
            }
        }
    }

    public class ChunkSystem
    extends ConfigurationPart {
        public int ioThreads = -1;
        public int workerThreads = -1;

        public ChunkSystem(GlobalConfiguration this$0) {
        }

        @PostProcess
        private void postProcess() {
            MoonriseCommon.adjustWorkerThreads(this.workerThreads, this.ioThreads);
        }
    }

    public class Scoreboards
    extends ConfigurationPart {
        public boolean trackPluginScoreboards = false;
        public boolean saveEmptyScoreboardTeams = true;

        public Scoreboards(GlobalConfiguration this$0) {
        }
    }

    public class Logging
    extends ConfigurationPart {
        public boolean deobfuscateStacktraces = true;

        public Logging(GlobalConfiguration this$0) {
        }
    }

    public class Commands
    extends ConfigurationPart {
        public boolean suggestPlayerNamesWhenNullTabCompletions = true;
        public boolean timeCommandAffectsAllWorlds = false;
        @Comment(value="Allow mounting entities to a player in the Vanilla '/ride' command.")
        public boolean rideCommandAllowPlayerAsVehicle = false;

        public Commands(GlobalConfiguration this$0) {
        }
    }

    public class UnsupportedSettings
    extends ConfigurationPart {
        @Comment(value="This setting allows for exploits related to end portals, for example sand duping")
        public boolean allowUnsafeEndPortalTeleportation = false;
        @Comment(value="This setting controls the ability to enable dupes related to tripwires.")
        public boolean skipTripwireHookPlacementValidation = false;
        @Comment(value="This setting controls if players should be able to break bedrock, end portals and other intended to be permanent blocks.")
        public boolean allowPermanentBlockBreakExploits = false;
        @Comment(value="This setting controls if player should be able to use TNT duplication, but this also allows duplicating carpet, rails and potentially other items")
        public boolean allowPistonDuplication = false;
        public boolean performUsernameValidation = true;
        @Comment(value="This setting controls if players should be able to create headless pistons.")
        public boolean allowHeadlessPistons = false;
        @Comment(value="This setting controls if the vanilla damage tick should be skipped if damage was blocked via a shield.")
        public boolean skipVanillaDamageTickWhenShieldBlocked = false;
        @Comment(value="This setting controls what compression format is used for region files.")
        public CompressionFormat compressionFormat = CompressionFormat.ZLIB;
        @Comment(value="This setting controls if equipment should be updated when handling certain player actions.")
        public boolean updateEquipmentOnPlayerActions = true;

        public UnsupportedSettings(GlobalConfiguration this$0) {
        }

        public static enum CompressionFormat {
            GZIP,
            ZLIB,
            LZ4,
            NONE;

        }
    }

    public class SpamLimiter
    extends ConfigurationPart {
        public int tabSpamIncrement = 1;
        public int tabSpamLimit = 500;
        public int recipeSpamIncrement = 1;
        public int recipeSpamLimit = 20;
        public int incomingPacketThreshold = 300;

        public SpamLimiter(GlobalConfiguration this$0) {
        }
    }

    public class Watchdog
    extends ConfigurationPart {
        public int earlyWarningEvery = 5000;
        public int earlyWarningDelay = 10000;

        public Watchdog(GlobalConfiguration this$0) {
        }
    }

    public class Console
    extends ConfigurationPart {
        public boolean enableBrigadierHighlighting = true;
        public boolean enableBrigadierCompletions = true;
        public boolean hasAllPermissions = false;

        public Console(GlobalConfiguration this$0) {
        }
    }

    public class Proxies
    extends ConfigurationPart {
        public BungeeCord bungeeCord;
        public Velocity velocity;
        public boolean proxyProtocol = false;

        public Proxies(GlobalConfiguration this$0) {
        }

        public boolean isProxyOnlineMode() {
            return Bukkit.getOnlineMode() || SpigotConfig.bungee && this.bungeeCord.onlineMode || this.velocity.enabled && this.velocity.onlineMode;
        }

        public class BungeeCord
        extends ConfigurationPart {
            public boolean onlineMode = true;

            public BungeeCord(Proxies this$1) {
            }
        }

        public class Velocity
        extends ConfigurationPart {
            public boolean enabled = false;
            public boolean onlineMode = true;
            public String secret = "";

            public Velocity(Proxies this$1) {
            }

            @PostProcess
            private void postProcess() {
                if (!this.enabled) {
                    return;
                }
                String environmentSourcedVelocitySecret = System.getenv("PAPER_VELOCITY_SECRET");
                if (environmentSourcedVelocitySecret != null && !environmentSourcedVelocitySecret.isEmpty()) {
                    this.secret = environmentSourcedVelocitySecret;
                }
                if (this.secret.isEmpty()) {
                    LOGGER.error("Velocity is enabled, but no secret key was specified. A secret key is required. Disabling velocity...");
                    this.enabled = false;
                }
            }
        }
    }

    public class Spark
    extends ConfigurationPart {
        public boolean enabled = true;
        public boolean enableImmediately = false;

        public Spark(GlobalConfiguration this$0) {
        }
    }

    public class Messages
    extends ConfigurationPart {
        public Kick kick;
        public Component noPermission = Component.text((String)"I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", (TextColor)NamedTextColor.RED);
        public boolean useDisplayNameInQuitMessage = false;

        public Messages(GlobalConfiguration this$0) {
        }

        public class Kick
        extends ConfigurationPart {
            public Component authenticationServersDown = Component.translatable((String)"multiplayer.disconnect.authservers_down");
            public Component connectionThrottle = Component.text((String)"Connection throttled! Please wait before reconnecting.");
            public Component flyingPlayer = Component.translatable((String)"multiplayer.disconnect.flying");
            public Component flyingVehicle = Component.translatable((String)"multiplayer.disconnect.flying");

            public Kick(Messages this$1) {
            }
        }
    }

    public class ChunkLoadingAdvanced
    extends ConfigurationPart {
        @Comment(value="Set to true if the server will match the chunk send radius that clients have configuredin their view distance settings if the client is less-than the server's send distance.")
        public boolean autoConfigSendDistance = true;
        @Comment(value="Specifies the maximum amount of concurrent chunk loads that an individual player can have.Set to 0 to let the server configure it automatically per player, or set it to -1 to disable the limit.")
        public int playerMaxConcurrentChunkLoads = 0;
        @Comment(value="Specifies the maximum amount of concurrent chunk generations that an individual player can have.Set to 0 to let the server configure it automatically per player, or set it to -1 to disable the limit.")
        public int playerMaxConcurrentChunkGenerates = 0;

        public ChunkLoadingAdvanced(GlobalConfiguration this$0) {
        }
    }

    public class ChunkLoadingBasic
    extends ConfigurationPart {
        @Comment(value="The maximum rate in chunks per second that the server will send to any individual player. Set to -1 to disable this limit.")
        public double playerMaxChunkSendRate = 75.0;
        @Comment(value="The maximum rate at which chunks will load for any individual player. Note that this setting also affects chunk generations, since a chunk load is always first issued to test if achunk is already generated. Set to -1 to disable this limit.")
        public double playerMaxChunkLoadRate = 100.0;
        @Comment(value="The maximum rate at which chunks will generate for any individual player. Set to -1 to disable this limit.")
        public double playerMaxChunkGenerateRate = -1.0;

        public ChunkLoadingBasic(GlobalConfiguration this$0) {
        }
    }
}

