/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.mapping;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.mapping.Definition;
import io.papermc.paper.configuration.mapping.FieldProcessor;
import io.papermc.paper.configuration.serializer.collection.map.MapSerializer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedType;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;

@Documented
@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MergeMap {
    public static final Logger LOGGER = LogUtils.getClassLogger();
    public static final Definition<MergeMap, Map<?, ?>, Factory> DEFINITION = new Definition(MergeMap.class, MapSerializer.TYPE, new Factory());

    public boolean restricted() default true;

    public static final class Factory
    implements FieldProcessor.Factory<MergeMap, Map<?, ?>> {
        @Override
        public FieldProcessor<Map<?, ?>> make(MergeMap data, AnnotatedType annotatedType) {
            return (target, deserializedValue, valueInField) -> {
                if (valueInField != null && deserializedValue != null) {
                    if (data.restricted()) {
                        ImmutableSet invalidKeys = Sets.difference(deserializedValue.keySet(), valueInField.keySet()).immutableCopy();
                        for (Object invalidKey : invalidKeys) {
                            LOGGER.error("The key {} is not allowed to be added to the field {}", invalidKey, (Object)target);
                        }
                        deserializedValue.keySet().removeAll((Collection<?>)invalidKeys);
                    }
                    valueInField.putAll(deserializedValue);
                    return valueInField;
                }
                Preconditions.checkState((!data.restricted() || valueInField != null ? 1 : 0) != 0, (Object)"If marked as restricted, field must have a value");
                return deserializedValue;
            };
        }
    }
}

