/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.transformation.global.versioned;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public class V30_PacketIds
implements TransformAction {
    public static final V30_PacketIds INSTANCE = new V30_PacketIds();
    private static final int VERSION = 30;
    private static final Gson GSON = new Gson();
    private static final Map<String, MinecraftKey> MOJANG_TO_ID;

    public static void apply(ConfigurationTransformation.VersionedBuilder builder) {
        builder.addVersion(30, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"packet-limiter", "overrides", ConfigurationTransformation.WILDCARD_OBJECT}), (TransformAction)INSTANCE).build());
    }

    private V30_PacketIds() {
    }

    public Object @Nullable [] visitPath(NodePath path, ConfigurationNode value) {
        String oldClassName = path.get(path.size() - 1).toString();
        if (MOJANG_TO_ID.containsKey(oldClassName)) {
            return path.with(path.size() - 1, (Object)MOJANG_TO_ID.get(oldClassName).toString()).array();
        }
        return null;
    }

    static {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        InputStream input = V30_PacketIds.class.getResourceAsStream("/config-data/packet-limiter-upgrade-data.json");
        if (input == null) {
            throw new RuntimeException("Failed to load packet limiter upgrade data");
        }
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(input));){
            JsonArray array = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                builder2.put((Object)obj.get("simple_class_name").getAsString(), (Object)MinecraftKey.a(obj.get("id").getAsString()));
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to load packet limiter upgrade data", e2);
        }
        MOJANG_TO_ID = builder2.build();
    }
}

