/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.util.StackWalkerUtil;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.RegisteredListener;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@NullMarked
public class HorriblePlayerLoginEventHack {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static boolean nagged = false;

    public static boolean warnReenterConfiguration(NetworkManager connection) {
        if (!connection.handledLegacyLoginEvent) {
            return false;
        }
        LOGGER.warn("\n============================================================\nWARNING: {} Attempted to use PlayerGameConnection#reenterConfiguration()\n\nThis method currently requires that all plugins installed on the server\nare not listening to the PlayerLoginEvent.\n\nPlease look in your logs for the Plugins listening to this event.\n============================================================", (Object)StackWalkerUtil.getFirstPluginCaller().getName());
        return true;
    }

    public static @Nullable IChatBaseComponent execute(NetworkManager connection, MinecraftServer server, GameProfile profile, PlayerList.LoginResult result) {
        EntityPlayer player;
        if (PlayerLoginEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return result.message();
        }
        if (!nagged) {
            HashSet<String> plugins = new HashSet<String>();
            for (RegisteredListener listener : PlayerLoginEvent.getHandlerList().getRegisteredListeners()) {
                plugins.add(listener.getPlugin().getName());
            }
            LOGGER.info("You have plugins listening to the PlayerLoginEvent, this will cause re-configuration APIs to be unavailable: {}", plugins);
            nagged = true;
        }
        if (connection.savedPlayerForLegacyEvents != null) {
            player = connection.savedPlayerForLegacyEvents;
        } else {
            EntityPlayer serverPlayer;
            connection.savedPlayerForLegacyEvents = serverPlayer = new EntityPlayer(server, server.O(), profile, ClientInformation.a());
            player = serverPlayer;
        }
        connection.handledLegacyLoginEvent = true;
        CraftPlayer horribleBukkitPlayer = player.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)horribleBukkitPlayer, connection.hostname, ((InetSocketAddress)connection.d()).getAddress(), ((InetSocketAddress)connection.n.remoteAddress()).getAddress());
        event.disallow(result.result(), PaperAdventure.asAdventure(result.message()));
        event.callEvent();
        IChatBaseComponent finalResult = event.getResult() == PlayerLoginEvent.Result.ALLOWED ? null : PaperAdventure.asVanilla(event.kickMessage());
        if (event.getResult() != result.result()) {
            connection.legacySavedLoginEventResultOverride = Optional.ofNullable(finalResult);
        }
        return finalResult;
    }
}

