/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.ReadablePlayerCookieConnectionImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.common.ClientboundCustomReportDetailsPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ClientboundStoreCookiePacket;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import org.bukkit.NamespacedKey;
import org.bukkit.ServerLinks;
import org.bukkit.craftbukkit.v1_21_R6.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.jspecify.annotations.Nullable;

public abstract class PaperCommonConnection<T extends ServerCommonPacketListenerImpl>
extends ReadablePlayerCookieConnectionImpl
implements PlayerCommonConnection {
    protected final T handle;

    public PaperCommonConnection(T serverConfigurationPacketListenerImpl) {
        super(((ServerCommonPacketListenerImpl)serverConfigurationPacketListenerImpl).e);
        this.handle = serverConfigurationPacketListenerImpl;
    }

    public void sendReportDetails(Map<String, String> details) {
        ((ServerCommonPacketListenerImpl)this.handle).b(new ClientboundCustomReportDetailsPacket(details));
    }

    public void sendLinks(ServerLinks links) {
        ((ServerCommonPacketListenerImpl)this.handle).b(new ClientboundServerLinksPacket(((CraftServerLinks)links).getServerLinks().b()));
    }

    public void transfer(String host, int port) {
        ((ServerCommonPacketListenerImpl)this.handle).b(new ClientboundTransferPacket(host, port));
    }

    public <T> T getClientOption(ClientOption<T> type) {
        ClientInformation information = this.getClientInformation();
        if (ClientOption.SKIN_PARTS == type) {
            return type.getType().cast(new PaperSkinParts(information.f()));
        }
        if (ClientOption.CHAT_COLORS_ENABLED == type) {
            return type.getType().cast(information.e());
        }
        if (ClientOption.CHAT_VISIBILITY == type) {
            return type.getType().cast(ClientOption.ChatVisibility.valueOf((String)information.d().name()));
        }
        if (ClientOption.LOCALE == type) {
            return type.getType().cast(information.b());
        }
        if (ClientOption.MAIN_HAND == type) {
            return type.getType().cast(information.g());
        }
        if (ClientOption.VIEW_DISTANCE == type) {
            return type.getType().cast(information.c());
        }
        if (ClientOption.TEXT_FILTERING_ENABLED == type) {
            return type.getType().cast(information.h());
        }
        if (ClientOption.ALLOW_SERVER_LISTINGS == type) {
            return type.getType().cast(information.i());
        }
        if (ClientOption.PARTICLE_VISIBILITY == type) {
            return type.getType().cast(ClientOption.ParticleVisibility.valueOf((String)information.j().name()));
        }
        throw new RuntimeException("Unknown settings type");
    }

    public void disconnect(Component component) {
        ((ServerCommonPacketListenerImpl)this.handle).disconnect(PaperAdventure.asVanilla(component), DisconnectionReason.UNKNOWN);
    }

    public boolean isTransferred() {
        return ((ServerCommonPacketListenerImpl)this.handle).isTransferred();
    }

    public SocketAddress getAddress() {
        return ((ServerCommonPacketListenerImpl)this.handle).e.d();
    }

    public InetSocketAddress getClientAddress() {
        return (InetSocketAddress)((ServerCommonPacketListenerImpl)this.handle).e.n.remoteAddress();
    }

    public @Nullable InetSocketAddress getVirtualHost() {
        return ((ServerCommonPacketListenerImpl)this.handle).e.virtualHost;
    }

    public @Nullable InetSocketAddress getHAProxyAddress() {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = ((ServerCommonPacketListenerImpl)this.handle).e.haProxyAddress;
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public void storeCookie(NamespacedKey key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Cookie value cannot be null");
        Preconditions.checkArgument((value.length <= 5120 ? 1 : 0) != 0, (Object)"Cookie value too large, must be smaller than 5120 bytes");
        Preconditions.checkState((boolean)this.canStoreCookie(), (Object)"Can only store cookie in CONFIGURATION or PLAY protocol.");
        ((ServerCommonPacketListenerImpl)this.handle).b(new ClientboundStoreCookiePacket(CraftNamespacedKey.toMinecraft(key), value));
    }

    public abstract ClientInformation getClientInformation();
}

