/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.google.common.base.Preconditions;
import io.papermc.paper.connection.ReadablePlayerCookieConnection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class ReadablePlayerCookieConnectionImpl
implements ReadablePlayerCookieConnection {
    private final Map<MinecraftKey, CookieFuture> requestedCookies = new ConcurrentHashMap<MinecraftKey, CookieFuture>();
    private final NetworkManager connection;

    public ReadablePlayerCookieConnectionImpl(NetworkManager connection) {
        this.connection = connection;
    }

    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        MinecraftKey resourceLocation = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.put(resourceLocation, new CookieFuture(resourceLocation, future));
        this.connection.a(new ClientboundCookieRequestPacket(resourceLocation));
        return future;
    }

    public boolean canStoreCookie() {
        return true;
    }

    public boolean handleCookieResponse(ServerboundCookieResponsePacket packet) {
        CookieFuture future = this.requestedCookies.get(packet.b());
        if (future != null) {
            future.future().complete(packet.e());
            this.requestedCookies.remove(packet.b());
            return true;
        }
        return false;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public record CookieFuture(MinecraftKey key, CompletableFuture<byte[]> future) {
    }
}

