/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.attribute.AttributeModifierDisplay;
import io.papermc.paper.datacomponent.item.attribute.PaperAttributeModifierDisplay;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.Handleable;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.Unmodifiable;

public record PaperItemAttributeModifiers(net.minecraft.world.item.component.ItemAttributeModifiers impl) implements ItemAttributeModifiers,
Handleable<net.minecraft.world.item.component.ItemAttributeModifiers>
{
    private static List<ItemAttributeModifiers.Entry> convert(net.minecraft.world.item.component.ItemAttributeModifiers nmsModifiers) {
        return MCUtil.transformUnmodifiable(nmsModifiers.b(), nms -> new PaperEntry(CraftAttribute.minecraftHolderToBukkit(nms.a()), CraftAttributeInstance.convert(nms.b(), nms.c()), PaperAttributeModifierDisplay.fromVanilla(nms.d())));
    }

    @Override
    public net.minecraft.world.item.component.ItemAttributeModifiers getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    ItemAttributeModifiers.Entry> modifiers() {
        return PaperItemAttributeModifiers.convert(this.impl);
    }

    public record PaperEntry(Attribute attribute, AttributeModifier modifier, AttributeModifierDisplay display) implements ItemAttributeModifiers.Entry
    {
    }

    static final class BuilderImpl
    implements ItemAttributeModifiers.Builder {
        private final List<ItemAttributeModifiers.c> entries = new ObjectArrayList();

        BuilderImpl() {
        }

        public ItemAttributeModifiers.Builder addModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotGroup equipmentSlotGroup, AttributeModifierDisplay display) {
            Preconditions.checkArgument((boolean)this.entries.stream().noneMatch(e2 -> e2.b().a().equals(CraftNamespacedKey.toMinecraft(modifier.getKey())) && e2.a().a(CraftNamespacedKey.toMinecraft(attribute.getKey()))), (String)"Cannot add 2 modifiers with identical keys on the same attribute (modifier %s for attribute %s)", (Object)modifier.getKey(), (Object)attribute.getKey());
            this.entries.add(new ItemAttributeModifiers.c(CraftAttribute.bukkitToMinecraftHolder(attribute), CraftAttributeInstance.convert(modifier), CraftEquipmentSlot.getNMSGroup(equipmentSlotGroup), PaperAttributeModifierDisplay.toVanilla(display)));
            return this;
        }

        public ItemAttributeModifiers build() {
            if (this.entries.isEmpty()) {
                return new PaperItemAttributeModifiers(net.minecraft.world.item.component.ItemAttributeModifiers.a);
            }
            return new PaperItemAttributeModifiers(new net.minecraft.world.item.component.ItemAttributeModifiers((List<ItemAttributeModifiers.c>)new ObjectArrayList(this.entries)));
        }
    }
}

