/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.component.Tool;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R6.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public record PaperItemTool(net.minecraft.world.item.component.Tool impl) implements Tool,
Handleable<net.minecraft.world.item.component.Tool>
{
    private static List<Tool.Rule> convert(List<Tool.a> tool) {
        return MCUtil.transformUnmodifiable(tool, nms -> new PaperRule(PaperRegistrySets.convertToApi(RegistryKey.BLOCK, nms.a()), nms.b().orElse(null), TriState.byBoolean((Boolean)nms.c().orElse(null))));
    }

    @Override
    public net.minecraft.world.item.component.Tool getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    Tool.Rule> rules() {
        return PaperItemTool.convert(this.impl.a());
    }

    public float defaultMiningSpeed() {
        return this.impl.b();
    }

    public int damagePerBlock() {
        return this.impl.c();
    }

    public boolean canDestroyBlocksInCreative() {
        return this.impl.d();
    }

    record PaperRule(RegistryKeySet<BlockType> blocks, @Nullable Float speed, TriState correctForDrops) implements Tool.Rule
    {
        public static PaperRule fromUnsafe(RegistryKeySet<BlockType> blocks, @Nullable Float speed, TriState correctForDrops) {
            Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
            return new PaperRule(blocks, speed, correctForDrops);
        }
    }

    static final class BuilderImpl
    implements Tool.Builder {
        private final List<Tool.a> rules = new ObjectArrayList();
        private int damage = 1;
        private float miningSpeed = 1.0f;
        private boolean canDestroyBlocksInCreative = true;

        BuilderImpl() {
        }

        public Tool.Builder damagePerBlock(int damage) {
            Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be non-negative, was %s", (int)damage);
            this.damage = damage;
            return this;
        }

        public Tool.Builder defaultMiningSpeed(float miningSpeed) {
            this.miningSpeed = miningSpeed;
            return this;
        }

        public Tool.Builder addRule(Tool.Rule rule) {
            this.rules.add(new Tool.a(PaperRegistrySets.convertToNms(Registries.i, Conversions.global().lookup(), rule.blocks()), Optional.ofNullable(rule.speed()), Optional.ofNullable(rule.correctForDrops().toBoolean())));
            return this;
        }

        public Tool.Builder canDestroyBlocksInCreative(boolean canDestroyBlocksInCreative) {
            this.canDestroyBlocksInCreative = canDestroyBlocksInCreative;
            return this;
        }

        public Tool.Builder addRules(Collection<Tool.Rule> rules) {
            rules.forEach(this::addRule);
            return this;
        }

        public Tool build() {
            return new PaperItemTool(new net.minecraft.world.item.component.Tool((List<Tool.a>)new ObjectArrayList(this.rules), this.miningSpeed, this.damage, this.canDestroyBlocksInCreative));
        }
    }
}

