/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.WritableBookContent;
import io.papermc.paper.text.Filtered;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.network.Filterable;
import org.bukkit.craftbukkit.v1_21_R6.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperWritableBookContent(net.minecraft.world.item.component.WritableBookContent impl) implements WritableBookContent,
Handleable<net.minecraft.world.item.component.WritableBookContent>
{
    @Override
    public net.minecraft.world.item.component.WritableBookContent getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<Filtered<String>> pages() {
        return MCUtil.transformUnmodifiable(this.impl.a(), input -> Filtered.of((Object)((String)input.a()), (Object)input.b().orElse(null)));
    }

    static final class BuilderImpl
    implements WritableBookContent.Builder {
        private final List<Filterable<String>> pages = new ObjectArrayList();

        BuilderImpl() {
        }

        private static void validatePageLength(String page) {
            Preconditions.checkArgument((page.length() <= 1024 ? 1 : 0) != 0, (String)"Cannot have page length more than %s, had %s", (int)1024, (int)page.length());
        }

        private static void validatePageCount(int current, int add) {
            int newSize = current + add;
            Preconditions.checkArgument((newSize <= 100 ? 1 : 0) != 0, (String)"Cannot have more than %s pages, had %s", (int)100, (int)newSize);
        }

        public WritableBookContent.Builder addPage(String page) {
            BuilderImpl.validatePageLength(page);
            BuilderImpl.validatePageCount(this.pages.size(), 1);
            this.pages.add(Filterable.a(page));
            return this;
        }

        public WritableBookContent.Builder addPages(List<String> pages) {
            BuilderImpl.validatePageCount(this.pages.size(), pages.size());
            for (String page : pages) {
                BuilderImpl.validatePageLength(page);
                this.pages.add(Filterable.a(page));
            }
            return this;
        }

        public WritableBookContent.Builder addFilteredPage(Filtered<String> page) {
            BuilderImpl.validatePageLength((String)page.raw());
            if (page.filtered() != null) {
                BuilderImpl.validatePageLength((String)page.filtered());
            }
            BuilderImpl.validatePageCount(this.pages.size(), 1);
            this.pages.add(new Filterable<String>((String)page.raw(), Optional.ofNullable((String)page.filtered())));
            return this;
        }

        public WritableBookContent.Builder addFilteredPages(List<Filtered<String>> pages) {
            BuilderImpl.validatePageCount(this.pages.size(), pages.size());
            for (Filtered<String> page : pages) {
                BuilderImpl.validatePageLength((String)page.raw());
                if (page.filtered() != null) {
                    BuilderImpl.validatePageLength((String)page.filtered());
                }
                this.pages.add(new Filterable<String>((String)page.raw(), Optional.ofNullable((String)page.filtered())));
            }
            return this;
        }

        public WritableBookContent build() {
            if (this.pages.isEmpty()) {
                return new PaperWritableBookContent(net.minecraft.world.item.component.WritableBookContent.a);
            }
            return new PaperWritableBookContent(new net.minecraft.world.item.component.WritableBookContent((List<Filterable<String>>)new ObjectArrayList(this.pages)));
        }
    }
}

