/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.entity.activation;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.phys.AxisAlignedBB;

public enum ActivationType {
    WATER,
    FLYING_MONSTER,
    VILLAGER,
    MONSTER,
    ANIMAL,
    RAIDER,
    MISC;

    AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType activationTypeFor(Entity entity) {
        if (entity instanceof EntityWaterAnimal || entity instanceof AgeableWaterCreature) {
            return WATER;
        }
        if (entity instanceof EntityVillager) {
            return VILLAGER;
        }
        if (entity instanceof EntityGhast || entity instanceof EntityPhantom) {
            return FLYING_MONSTER;
        }
        if (entity instanceof EntityRaider) {
            return RAIDER;
        }
        if (entity instanceof IMonster) {
            return MONSTER;
        }
        if (entity instanceof EntityCreature || entity instanceof EntityAmbient) {
            return ANIMAL;
        }
        return MISC;
    }
}

