/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.lifecycle.event;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import io.papermc.paper.plugin.lifecycle.event.registrar.RegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.registrar.RegistrarEventImpl;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.AbstractLifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.OwnerAwareLifecycleEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class LifecycleEventRunner {
    public static final LifecycleEventRunner INSTANCE = new LifecycleEventRunner();
    private final List<LifecycleEventType<?, ?, ?>> lifecycleEventTypes = new ArrayList();
    private boolean blockPluginReloading = false;

    public <O extends LifecycleEventOwner> void checkRegisteredHandler(O owner, AbstractLifecycleEventType<O, ?, ?> eventType) {
        if (eventType.blocksReloading(owner)) {
            this.blockPluginReloading = true;
        }
    }

    public boolean blocksPluginReloading() {
        return this.blockPluginReloading;
    }

    public <O extends LifecycleEventOwner, E extends LifecycleEvent, ET extends LifecycleEventType<O, E, ?>> void addEventType(ET eventType) {
        this.lifecycleEventTypes.add(eventType);
    }

    public <O extends LifecycleEventOwner, E extends PaperLifecycleEvent> void callEvent(LifecycleEventType<O, ? super E, ?> eventType, E event) {
        this.callEvent(eventType, event, $ -> true);
    }

    public <O extends LifecycleEventOwner, E extends PaperLifecycleEvent> void callEvent(LifecycleEventType<O, ? super E, ?> eventType, E event, Predicate<? super O> ownerPredicate) {
        AbstractLifecycleEventType lifecycleEventType = (AbstractLifecycleEventType)eventType;
        lifecycleEventType.forEachHandler(event, registeredHandler -> {
            OwnerAwareLifecycleEvent ownerAwareEvent;
            try {
                if (event instanceof OwnerAwareLifecycleEvent) {
                    ownerAwareEvent = (OwnerAwareLifecycleEvent)((Object)event);
                    LifecycleEventRunner.ownerAwareGenericHelper(ownerAwareEvent, registeredHandler.owner());
                }
                registeredHandler.lifecycleEventHandler().run((LifecycleEvent)event);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Could not run '%s' lifecycle event handler from %s".formatted(lifecycleEventType.name(), registeredHandler.owner().getPluginMeta().getDisplayName()), ex);
            }
            finally {
                if (event instanceof OwnerAwareLifecycleEvent) {
                    ownerAwareEvent = (OwnerAwareLifecycleEvent)((Object)event);
                    ownerAwareEvent.setOwner(null);
                }
            }
        }, handler -> ownerPredicate.test((Object)handler.owner()));
        event.invalidate();
    }

    private static <O extends LifecycleEventOwner> void ownerAwareGenericHelper(OwnerAwareLifecycleEvent<O> event, LifecycleEventOwner possibleOwner) {
        @Nullable O owner = event.castOwner(possibleOwner);
        if (owner == null) {
            throw new IllegalStateException("Found invalid owner " + String.valueOf(possibleOwner) + " for event " + String.valueOf(event));
        }
        event.setOwner(owner);
    }

    public void unregisterAllEventHandlersFor(Plugin plugin) {
        for (LifecycleEventType<?, ?, ?> lifecycleEventType : this.lifecycleEventTypes) {
            this.removeEventHandlersOwnedBy(lifecycleEventType, plugin);
        }
    }

    private <O extends LifecycleEventOwner> void removeEventHandlersOwnedBy(LifecycleEventType<O, ?, ?> eventType, Plugin possibleOwner) {
        AbstractLifecycleEventType lifecycleEventType = (AbstractLifecycleEventType)eventType;
        lifecycleEventType.removeMatching(registeredHandler -> registeredHandler.owner().getPluginMeta().getName().equals(possibleOwner.getPluginMeta().getName()));
    }

    public <O extends LifecycleEventOwner, R extends PaperRegistrar<? super O>> void callStaticRegistrarEvent(LifecycleEventType<O, ? extends RegistrarEvent<? super R>, ?> lifecycleEventType, R registrar, Class<? extends O> ownerClass) {
        this.callEvent(lifecycleEventType, new RegistrarEventImpl<R, O>(registrar, ownerClass), ownerClass::isInstance);
    }

    public <O extends LifecycleEventOwner, R extends PaperRegistrar<? super O>> void callReloadableRegistrarEvent(LifecycleEventType<O, ? extends ReloadableRegistrarEvent<? super R>, ?> lifecycleEventType, R registrar, Class<? extends O> ownerClass, ReloadableRegistrarEvent.Cause cause) {
        this.callEvent(lifecycleEventType, new RegistrarEventImpl.ReloadableImpl<R, O>(registrar, ownerClass, cause), ownerClass::isInstance);
    }

    private LifecycleEventRunner() {
    }
}

