/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.papermc.paper.configuration.constraint.Constraint;
import io.papermc.paper.configuration.serializer.ComponentSerializer;
import io.papermc.paper.configuration.serializer.EnumValueSerializer;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.configuration.FlattenedResolver;
import io.papermc.paper.plugin.provider.configuration.LegacyPaperMeta;
import io.papermc.paper.plugin.provider.configuration.serializer.PermissionConfigurationSerializer;
import io.papermc.paper.plugin.provider.configuration.serializer.constraints.PluginConfigConstraints;
import io.papermc.paper.plugin.provider.configuration.type.DependencyConfiguration;
import io.papermc.paper.plugin.provider.configuration.type.PermissionConfiguration;
import io.papermc.paper.plugin.provider.configuration.type.PluginDependencyLifeCycle;
import java.io.BufferedReader;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginLoadOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.Constraint;
import org.spongepowered.configurate.objectmapping.meta.NodeResolver;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@ConfigSerializable
public class PaperPluginMeta
implements PluginMeta {
    @PluginConfigConstraints.PluginName
    @Required
    private String name;
    @Required
    @PluginConfigConstraints.PluginNameSpace
    private String main;
    @PluginConfigConstraints.PluginNameSpace
    private String bootstrapper;
    @PluginConfigConstraints.PluginNameSpace
    private String loader;
    private List<String> provides = List.of();
    private boolean hasOpenClassloader = false;
    @Required
    private String version;
    private String description;
    private List<String> authors = List.of();
    private List<String> contributors = List.of();
    private String website;
    private String prefix;
    private PluginLoadOrder load = PluginLoadOrder.POSTWORLD;
    @FlattenedResolver
    private PermissionConfiguration permissionConfiguration = new PermissionConfiguration(PermissionDefault.OP, List.of());
    @Required
    private ApiVersion apiVersion;
    private Map<PluginDependencyLifeCycle, Map<String, DependencyConfiguration>> dependencies = new EnumMap<PluginDependencyLifeCycle, Map<String, DependencyConfiguration>>(PluginDependencyLifeCycle.class);
    static final ApiVersion MINIMUM = ApiVersion.getOrCreateVersion("1.19");

    public static PaperPluginMeta create(BufferedReader reader) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.NONE)).source(() -> reader)).defaultOptions(options -> options.serializers(serializers -> serializers.register((ScalarSerializer)new ScalarSerializer<ApiVersion>(ApiVersion.class){

            public ApiVersion deserialize(Type type, Object obj) throws SerializationException {
                try {
                    ApiVersion version = ApiVersion.getOrCreateVersion(obj.toString());
                    if (version.isOlderThan(MINIMUM)) {
                        throw new SerializationException(String.valueOf(version) + " is too old for a paper plugin!");
                    }
                    return version;
                }
                catch (IllegalArgumentException e2) {
                    throw new SerializationException((Throwable)e2);
                }
            }

            protected Object serialize(ApiVersion item, Predicate<Class<?>> typeSupported) {
                return item.getVersionString();
            }
        }).register((ScalarSerializer)new EnumValueSerializer()).register(PermissionConfiguration.class, (TypeSerializer)PermissionConfigurationSerializer.SERIALIZER).register((ScalarSerializer)new ComponentSerializer()).registerAnnotatedObjects(ObjectMapper.factoryBuilder().addConstraint(Constraint.class, (Constraint.Factory)new Constraint.Factory()).addConstraint(PluginConfigConstraints.PluginName.class, String.class, (Constraint.Factory)new PluginConfigConstraints.PluginName.Factory()).addConstraint(PluginConfigConstraints.PluginNameSpace.class, String.class, (Constraint.Factory)new PluginConfigConstraints.PluginNameSpace.Factory()).addNodeResolver((NodeResolver.Factory)new FlattenedResolver.Factory()).build())))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        LegacyPaperMeta.migrate(node);
        PaperPluginMeta pluginConfiguration = (PaperPluginMeta)node.require(PaperPluginMeta.class);
        if (!((CommentedConfigurationNode)node.node(new Object[]{"author"})).virtual()) {
            pluginConfiguration.authors = ImmutableList.builder().addAll(pluginConfiguration.authors).add((Object)((CommentedConfigurationNode)node.node(new Object[]{"author"})).getString()).build();
        }
        return pluginConfiguration;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @TestOnly
    public void setName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.name = name;
    }

    @NotNull
    public String getMainClass() {
        return this.main;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @TestOnly
    public void setVersion(@NotNull String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version");
        this.version = version;
    }

    @Nullable
    public String getLoggerPrefix() {
        return this.prefix;
    }

    @NotNull
    public List<String> getPluginDependencies() {
        return this.dependencies.getOrDefault((Object)PluginDependencyLifeCycle.SERVER, Map.of()).entrySet().stream().filter(entry -> ((DependencyConfiguration)entry.getValue()).required() != false && ((DependencyConfiguration)entry.getValue()).joinClasspath() != false).map(Map.Entry::getKey).toList();
    }

    @NotNull
    public List<String> getPluginSoftDependencies() {
        return this.dependencies.getOrDefault((Object)PluginDependencyLifeCycle.SERVER, Map.of()).entrySet().stream().filter(entry -> ((DependencyConfiguration)entry.getValue()).required() == false && ((DependencyConfiguration)entry.getValue()).joinClasspath() != false).map(Map.Entry::getKey).toList();
    }

    @NotNull
    public List<String> getLoadBeforePlugins() {
        return this.dependencies.getOrDefault((Object)PluginDependencyLifeCycle.SERVER, Map.of()).entrySet().stream().filter(entry -> ((DependencyConfiguration)entry.getValue()).load() == DependencyConfiguration.LoadOrder.AFTER).map(Map.Entry::getKey).toList();
    }

    @NotNull
    public List<String> getLoadAfterPlugins() {
        return this.dependencies.getOrDefault((Object)PluginDependencyLifeCycle.SERVER, Map.of()).entrySet().stream().filter(entry -> ((DependencyConfiguration)entry.getValue()).load() == DependencyConfiguration.LoadOrder.BEFORE).map(Map.Entry::getKey).toList();
    }

    public Map<String, DependencyConfiguration> getServerDependencies() {
        return this.dependencies.getOrDefault((Object)PluginDependencyLifeCycle.SERVER, Map.of());
    }

    public Map<String, DependencyConfiguration> getBootstrapDependencies() {
        return this.dependencies.getOrDefault((Object)PluginDependencyLifeCycle.BOOTSTRAP, Map.of());
    }

    @NotNull
    public PluginLoadOrder getLoadOrder() {
        return this.load;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<String> getAuthors() {
        return this.authors;
    }

    @NotNull
    public List<String> getContributors() {
        return this.contributors;
    }

    public String getWebsite() {
        return this.website;
    }

    @NotNull
    public List<Permission> getPermissions() {
        return this.permissionConfiguration.permissions();
    }

    @NotNull
    public PermissionDefault getPermissionDefault() {
        return this.permissionConfiguration.defaultPerm();
    }

    @NotNull
    public String getAPIVersion() {
        return this.apiVersion.getVersionString();
    }

    @NotNull
    public List<String> getProvidedPlugins() {
        return this.provides;
    }

    public String getBootstrapper() {
        return this.bootstrapper;
    }

    public String getLoader() {
        return this.loader;
    }

    public boolean hasOpenClassloader() {
        return this.hasOpenClassloader;
    }
}

