/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.PaperDialog;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperSimpleRegistry;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.PaperBannerPatternRegistryEntry;
import io.papermc.paper.registry.data.PaperCatTypeRegistryEntry;
import io.papermc.paper.registry.data.PaperChickenVariantRegistryEntry;
import io.papermc.paper.registry.data.PaperCowVariantRegistryEntry;
import io.papermc.paper.registry.data.PaperDamageTypeRegistryEntry;
import io.papermc.paper.registry.data.PaperEnchantmentRegistryEntry;
import io.papermc.paper.registry.data.PaperFrogVariantRegistryEntry;
import io.papermc.paper.registry.data.PaperGameEventRegistryEntry;
import io.papermc.paper.registry.data.PaperInstrumentRegistryEntry;
import io.papermc.paper.registry.data.PaperJukeboxSongRegistryEntry;
import io.papermc.paper.registry.data.PaperPaintingVariantRegistryEntry;
import io.papermc.paper.registry.data.PaperPigVariantRegistryEntry;
import io.papermc.paper.registry.data.PaperSoundEventRegistryEntry;
import io.papermc.paper.registry.data.PaperWolfVariantRegistryEntry;
import io.papermc.paper.registry.data.dialog.PaperDialogRegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryBuilder;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R6.CraftArt;
import org.bukkit.craftbukkit.v1_21_R6.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R6.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R6.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R6.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R6.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R6.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.Nullable;

public final class PaperRegistries {
    static final List<RegistryEntry<?, ?>> REGISTRY_ENTRIES = List.of(RegistryEntryBuilder.start(Registries.K, RegistryKey.GAME_EVENT).craft(GameEvent.class, CraftGameEvent::new).writable(PaperGameEventRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(Registries.aA, RegistryKey.STRUCTURE_TYPE).craft(StructureType.class, CraftStructureType::new).build(), RegistryEntryBuilder.start(Registries.aa, RegistryKey.MOB_EFFECT).craft(PotionEffectType.class, CraftPotionEffectType::new).build(), RegistryEntryBuilder.start(Registries.i, RegistryKey.BLOCK).craft(BlockType.class, CraftBlockType::new).build(), RegistryEntryBuilder.start(Registries.O, RegistryKey.ITEM).craft(ItemType.class, CraftItemType::new).build(), RegistryEntryBuilder.start(Registries.aI, RegistryKey.VILLAGER_PROFESSION).craft(Villager.Profession.class, CraftVillager.CraftProfession::new).build(), RegistryEntryBuilder.start(Registries.aJ, RegistryKey.VILLAGER_TYPE).craft(Villager.Type.class, CraftVillager.CraftType::new).build(), RegistryEntryBuilder.start(Registries.V, RegistryKey.MAP_DECORATION_TYPE).craft(MapCursor.Type.class, CraftMapCursor.CraftType::new).build(), RegistryEntryBuilder.start(Registries.Z, RegistryKey.MENU).craft(MenuType.class, CraftMenuType::new).build(), RegistryEntryBuilder.start(Registries.c, RegistryKey.ATTRIBUTE).craft(Attribute.class, CraftAttribute::new).serializationUpdater(FieldRename.ATTRIBUTE_RENAME).build(), RegistryEntryBuilder.start(Registries.I, RegistryKey.FLUID).craft(Fluid.class, CraftFluid::new).build(), RegistryEntryBuilder.start(Registries.at, RegistryKey.SOUND_EVENT).craft(Sound.class, CraftSound::new, true).create(PaperSoundEventRegistryEntry.PaperBuilder::new, RegistryEntryMeta.RegistryModificationApiSupport.NONE), RegistryEntryBuilder.start(Registries.r, RegistryKey.DATA_COMPONENT_TYPE).craft(DataComponentTypes.class, PaperDataComponentType::of).build(), RegistryEntryBuilder.start(Registries.aN, RegistryKey.BIOME).craft(Biome.class, CraftBiome::new).build().delayed(), RegistryEntryBuilder.start(Registries.bm, RegistryKey.STRUCTURE).craft(Structure.class, CraftStructure::new).build().delayed(), RegistryEntryBuilder.start(Registries.bs, RegistryKey.TRIM_MATERIAL).craft(TrimMaterial.class, CraftTrimMaterial::new, true).build().delayed(), RegistryEntryBuilder.start(Registries.bt, RegistryKey.TRIM_PATTERN).craft(TrimPattern.class, CraftTrimPattern::new, true).build().delayed(), RegistryEntryBuilder.start(Registries.aU, RegistryKey.DAMAGE_TYPE).craft(DamageType.class, CraftDamageType::new).writable(PaperDamageTypeRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.bu, RegistryKey.WOLF_VARIANT).craft(Wolf.Variant.class, CraftWolf.CraftVariant::new).writable(PaperWolfVariantRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.bv, RegistryKey.WOLF_SOUND_VARIANT).craft(Wolf.SoundVariant.class, CraftWolf.CraftSoundVariant::new).build(), RegistryEntryBuilder.start(Registries.aZ, RegistryKey.ENCHANTMENT).craft(Enchantment.class, CraftEnchantment::new).serializationUpdater(FieldRename.ENCHANTMENT_RENAME).writable(PaperEnchantmentRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.bd, RegistryKey.JUKEBOX_SONG).craft(JukeboxSong.class, CraftJukeboxSong::new).writable(PaperJukeboxSongRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.aM, RegistryKey.BANNER_PATTERN).craft(PatternType.class, CraftPatternType::new, true).writable(PaperBannerPatternRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.bh, RegistryKey.PAINTING_VARIANT).craft(Art.class, CraftArt::new).writable(PaperPaintingVariantRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.bc, RegistryKey.INSTRUMENT).craft(MusicInstrument.class, CraftMusicInstrument::new, true).writable(PaperInstrumentRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.aO, RegistryKey.CAT_VARIANT).craft(Cat.Type.class, CraftCat.CraftType::new).writable(PaperCatTypeRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.bb, RegistryKey.FROG_VARIANT).craft(Frog.Variant.class, CraftFrog.CraftVariant::new).writable(PaperFrogVariantRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.aQ, RegistryKey.CHICKEN_VARIANT).craft(Chicken.Variant.class, CraftChicken.CraftVariant::new).writable(PaperChickenVariantRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(Registries.aT, RegistryKey.COW_VARIANT).craft(Cow.Variant.class, CraftCow.CraftVariant::new).writable(PaperCowVariantRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(Registries.bi, RegistryKey.PIG_VARIANT).craft(Pig.Variant.class, CraftPig.CraftVariant::new).writable(PaperPigVariantRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(Registries.aW, RegistryKey.DIALOG).craft(Dialog.class, PaperDialog::new, true).writable(PaperDialogRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(Registries.E, RegistryKey.ENTITY_TYPE).apiOnly(PaperSimpleRegistry::entityType), RegistryEntryBuilder.start(Registries.ac, RegistryKey.PARTICLE_TYPE).apiOnly(PaperSimpleRegistry::particleType), RegistryEntryBuilder.start(Registries.ai, RegistryKey.POTION).apiOnly(PaperSimpleRegistry::potion), RegistryEntryBuilder.start(Registries.Y, RegistryKey.MEMORY_MODULE_TYPE).apiOnly(() -> Registry.MEMORY_MODULE_TYPE));
    private static final Map<RegistryKey<?>, RegistryEntry<?, ?>> BY_REGISTRY_KEY;
    private static final Map<ResourceKey<?>, RegistryEntry<?, ?>> BY_RESOURCE_KEY;

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(ResourceKey<? extends IRegistry<M>> resourceKey) {
        return BY_RESOURCE_KEY.get(resourceKey);
    }

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(RegistryKey<? super T> registryKey) {
        return BY_REGISTRY_KEY.get(registryKey);
    }

    public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> RegistryEntryMeta.Buildable<M, T, B> getBuildableMeta(RegistryKey<T> registryKey) {
        RegistryEntry<M, T> entry = PaperRegistries.getEntry(registryKey);
        if (entry == null) {
            throw new IllegalArgumentException("No registry entry for " + String.valueOf(registryKey));
        }
        RegistryEntryMeta<M, T> registryEntryMeta = entry.meta();
        if (!(registryEntryMeta instanceof RegistryEntryMeta.Buildable)) {
            throw new IllegalArgumentException("Registry entry for " + String.valueOf(registryKey) + " is not buildable");
        }
        RegistryEntryMeta.Buildable buildableMeta = (RegistryEntryMeta.Buildable)registryEntryMeta;
        return buildableMeta;
    }

    public static <M, T> RegistryKey<T> registryFromNms(ResourceKey<? extends IRegistry<M>> registryResourceKey) {
        return Objects.requireNonNull(BY_RESOURCE_KEY.get(registryResourceKey), () -> String.valueOf(registryResourceKey) + " doesn't have an api RegistryKey").apiKey();
    }

    public static <M, T> ResourceKey<? extends IRegistry<M>> registryToNms(RegistryKey<T> registryKey) {
        return Objects.requireNonNull(BY_REGISTRY_KEY.get(registryKey), () -> String.valueOf(registryKey) + " doesn't have an mc registry ResourceKey").mcKey();
    }

    public static <M, T> TypedKey<T> fromNms(ResourceKey<M> resourceKey) {
        return TypedKey.create(PaperRegistries.registryFromNms(resourceKey.c()), (Key)CraftNamespacedKey.fromMinecraft(resourceKey.a()));
    }

    public static <M, T> ResourceKey<M> toNms(TypedKey<T> typedKey) {
        return ResourceKey.a(PaperRegistries.registryToNms(typedKey.registryKey()), PaperAdventure.asVanilla(typedKey.key()));
    }

    public static <M, T> TagKey<T> fromNms(net.minecraft.tags.TagKey<M> tagKey) {
        return TagKey.create(PaperRegistries.registryFromNms(tagKey.a()), (Key)CraftNamespacedKey.fromMinecraft(tagKey.b()));
    }

    public static <M, T> net.minecraft.tags.TagKey<M> toNms(TagKey<T> tagKey) {
        return net.minecraft.tags.TagKey.a(PaperRegistries.registryToNms(tagKey.registryKey()), PaperAdventure.asVanilla(tagKey.key()));
    }

    private PaperRegistries() {
    }

    static {
        IdentityHashMap byRegistryKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        IdentityHashMap byResourceKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        for (RegistryEntry<?, ?> entry : REGISTRY_ENTRIES) {
            Preconditions.checkState((byRegistryKey.put(entry.apiKey(), entry) == null ? 1 : 0) != 0, (String)"Duplicate api registry key: %s", entry.apiKey());
            Preconditions.checkState((byResourceKey.put(entry.mcKey(), entry) == null ? 1 : 0) != 0, (String)"Duplicate mc registry key: %s", entry.mcKey());
        }
        BY_REGISTRY_KEY = Collections.unmodifiableMap(byRegistryKey);
        BY_RESOURCE_KEY = Collections.unmodifiableMap(byResourceKey);
    }
}

