/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryAccessHolder;
import io.papermc.paper.registry.RegistryHolder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.WritableCraftRegistry;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.legacy.DelayedRegistry;
import io.papermc.paper.registry.legacy.DelayedRegistryEntry;
import io.papermc.paper.registry.legacy.LegacyRegistryIdentifiers;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class PaperRegistryAccess
implements RegistryAccess {
    private final Map<RegistryKey<?>, RegistryHolder<?>> registries = new ConcurrentHashMap();

    public static PaperRegistryAccess instance() {
        return (PaperRegistryAccess)RegistryAccessHolder.INSTANCE.orElseThrow(() -> new IllegalStateException("No RegistryAccess implementation found"));
    }

    @VisibleForTesting
    public Set<RegistryKey<?>> getLoadedServerBackedRegistries() {
        return this.registries.keySet().stream().filter(registryHolder -> {
            RegistryEntry entry = PaperRegistries.getEntry(registryHolder);
            return entry != null && !(entry.meta() instanceof RegistryEntryMeta.ApiOnly);
        }).collect(Collectors.toUnmodifiableSet());
    }

    @Deprecated(forRemoval=true)
    public <T extends Keyed> @Nullable Registry<T> getRegistry(Class<T> type) {
        RegistryKey<T> registryKey = PaperRegistryAccess.byType(type);
        if (registryKey == null) {
            return null;
        }
        RegistryEntry entry = PaperRegistries.getEntry(registryKey);
        RegistryHolder<?> registry = this.registries.get(registryKey);
        if (registry != null) {
            return registry.get();
        }
        if (entry instanceof DelayedRegistryEntry) {
            RegistryHolder.Delayed delayedHolder = new RegistryHolder.Delayed();
            this.registries.put(registryKey, delayedHolder);
            return delayedHolder.get();
        }
        return null;
    }

    public <T extends Keyed> Registry<T> getRegistry(RegistryKey<T> key) {
        if (PaperRegistries.getEntry(key) == null) {
            throw new NoSuchElementException(String.valueOf(key) + " is not a valid registry key");
        }
        RegistryHolder<?> registryHolder = this.registries.get(key);
        if (registryHolder == null) {
            throw new IllegalArgumentException(String.valueOf(key) + " points to a registry that is not available yet");
        }
        return PaperRegistryAccess.possiblyUnwrap(registryHolder.get());
    }

    public <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> WritableCraftRegistry<M, T, B> getWritableRegistry(RegistryKey<T> key) {
        Registry<T> registry = this.getRegistry(key);
        if (registry instanceof WritableCraftRegistry) {
            return (WritableCraftRegistry)registry;
        }
        throw new IllegalArgumentException(String.valueOf(key) + " does not point to a writable registry");
    }

    private static <T extends Keyed> Registry<T> possiblyUnwrap(Registry<T> registry) {
        if (registry instanceof DelayedRegistry) {
            DelayedRegistry delayedRegistry = (DelayedRegistry)registry;
            return delayedRegistry.delegate();
        }
        return registry;
    }

    public <M> void registerReloadableRegistry(IRegistry<M> registry) {
        this.registerRegistry(registry, true);
    }

    public <M> void registerRegistry(IRegistry<M> registry) {
        this.registerRegistry(registry, false);
    }

    public <M> void lockReferenceHolders(ResourceKey<? extends IRegistry<M>> resourceKey) {
        RegistryEntryMeta.ServerSide serverSide;
        RegistryEntryMeta registryEntryMeta;
        RegistryEntry entry = PaperRegistries.getEntry(resourceKey);
        if (entry == null || !((registryEntryMeta = entry.meta()) instanceof RegistryEntryMeta.ServerSide) || !(serverSide = (RegistryEntryMeta.ServerSide)registryEntryMeta).registryTypeMapper().constructorUsesHolder()) {
            return;
        }
        CraftRegistry registry = (CraftRegistry)this.getRegistry(entry.apiKey());
        registry.lockReferenceHolders();
    }

    private <M, B extends Keyed, R extends Registry<B>> void registerRegistry(IRegistry<M> registry, boolean replace) {
        RegistryEntry entry = PaperRegistries.getEntry(registry.g());
        if (entry == null) {
            return;
        }
        RegistryHolder<?> registryHolder = this.registries.get(entry.apiKey());
        if (registryHolder == null || replace) {
            this.registries.put(entry.apiKey(), entry.createRegistryHolder(registry));
        } else if (registryHolder instanceof RegistryHolder.Delayed && entry instanceof DelayedRegistryEntry) {
            DelayedRegistryEntry delayedEntry = (DelayedRegistryEntry)entry;
            ((RegistryHolder.Delayed)registryHolder).loadFrom(delayedEntry, registry);
        } else {
            throw new IllegalArgumentException(String.valueOf(registry.g()) + " has already been created");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static <T extends Keyed> @Nullable RegistryKey<T> byType(Class<T> type) {
        return LegacyRegistryIdentifiers.CLASS_TO_KEY_MAP.get(type);
    }
}

