/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.set.NamedRegistryKeySetImpl;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.alchemy.PotionRegistry;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperSimpleRegistry<T extends Enum<T>, M>
extends Registry.SimpleRegistry<T> {
    private final IRegistry<M> nmsRegistry;

    static Registry<EntityType> entityType() {
        return new PaperSimpleRegistry(EntityType.class, entity -> entity != EntityType.UNKNOWN, BuiltInRegistries.g);
    }

    static Registry<Particle> particleType() {
        return new PaperSimpleRegistry(Particle.class, BuiltInRegistries.j);
    }

    static Registry<PotionType> potion() {
        return new PaperSimpleRegistry<PotionType, PotionRegistry>(PotionType.class, BuiltInRegistries.i);
    }

    protected PaperSimpleRegistry(Class<T> type, IRegistry<M> nmsRegistry) {
        super(type);
        this.nmsRegistry = nmsRegistry;
    }

    public PaperSimpleRegistry(Class<T> type, Predicate<T> predicate, IRegistry<M> nmsRegistry) {
        super(type, predicate);
        this.nmsRegistry = nmsRegistry;
    }

    public boolean hasTag(TagKey<T> key) {
        net.minecraft.tags.TagKey nmsKey = PaperRegistries.toNms(key);
        return this.nmsRegistry.a(nmsKey).isPresent();
    }

    public Tag<T> getTag(TagKey<T> key) {
        HolderSet.Named namedHolderSet = (HolderSet.Named)this.nmsRegistry.a(PaperRegistries.toNms(key)).orElseThrow();
        return new NamedRegistryKeySetImpl(key, namedHolderSet);
    }

    public Collection<Tag<T>> getTags() {
        return this.nmsRegistry.l().map(NamedRegistryKeySetImpl::new).toList();
    }
}

