/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.BannerPatternRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.kyori.adventure.key.Key;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.block.banner.PatternType;
import org.jspecify.annotations.Nullable;

public class PaperBannerPatternRegistryEntry
implements BannerPatternRegistryEntry {
    protected @Nullable MinecraftKey assetId;
    protected @Nullable String translationKey;

    public PaperBannerPatternRegistryEntry(Conversions ignoredConversions, @Nullable EnumBannerPatternType internal) {
        if (internal == null) {
            return;
        }
        this.assetId = internal.a();
        this.translationKey = internal.b();
    }

    public Key assetId() {
        return PaperAdventure.asAdventure(Checks.asConfigured(this.assetId, "assetId"));
    }

    public String translationKey() {
        return Checks.asConfigured(this.translationKey, "translationKey");
    }

    public static final class PaperBuilder
    extends PaperBannerPatternRegistryEntry
    implements BannerPatternRegistryEntry.Builder,
    PaperRegistryBuilder<EnumBannerPatternType, PatternType> {
        public PaperBuilder(Conversions conversions, @Nullable EnumBannerPatternType internal) {
            super(conversions, internal);
        }

        public BannerPatternRegistryEntry.Builder assetId(Key assetId) {
            this.assetId = PaperAdventure.asVanilla(Checks.asArgument(assetId, "assetId"));
            return this;
        }

        public BannerPatternRegistryEntry.Builder translationKey(String translationKey) {
            this.translationKey = Checks.asArgument(translationKey, "translationKey");
            return this;
        }

        @Override
        public EnumBannerPatternType build() {
            return new EnumBannerPatternType(Checks.asConfigured(this.assetId, "assetId"), this.translationKey());
        }
    }
}

