/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.functions.StringTemplate;
import org.jspecify.annotations.Nullable;

public record SingleOptionDialogInputImpl(String key, int width, List<SingleOptionDialogInput.OptionEntry> entries, Component label, boolean labelVisible) implements SingleOptionDialogInput
{
    public SingleOptionDialogInputImpl {
        entries = List.copyOf(entries);
    }

    public static final class BuilderImpl
    implements SingleOptionDialogInput.Builder {
        private final String key;
        private int width = 200;
        private final List<SingleOptionDialogInput.OptionEntry> entries;
        private final Component label;
        private boolean labelVisible = true;

        public BuilderImpl(String key, List<SingleOptionDialogInput.OptionEntry> entries, Component label) {
            Preconditions.checkArgument((boolean)StringTemplate.b(key), (Object)"key must be a valid input name");
            Preconditions.checkArgument((!entries.isEmpty() ? 1 : 0) != 0, (Object)"entries must not be empty");
            Preconditions.checkArgument((entries.stream().filter(SingleOptionDialogInput.OptionEntry::initial).count() <= 1L ? 1 : 0) != 0, (Object)"only 1 option can be initially selected");
            this.key = key;
            this.entries = entries;
            this.label = label;
        }

        public BuilderImpl width(int width) {
            Preconditions.checkArgument((width >= 1 && width <= 1024 ? 1 : 0) != 0, (Object)"width must be between 1 and 1024");
            this.width = width;
            return this;
        }

        public BuilderImpl labelVisible(boolean labelVisible) {
            this.labelVisible = labelVisible;
            return this;
        }

        public SingleOptionDialogInput build() {
            return new SingleOptionDialogInputImpl(this.key, this.width, this.entries, this.label, this.labelVisible);
        }
    }

    public record SingleOptionEntryImpl(String id, @Nullable Component display, boolean initial) implements SingleOptionDialogInput.OptionEntry
    {
    }
}

