/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.type;

import com.google.common.base.Preconditions;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.type.DialogListType;
import io.papermc.paper.registry.set.RegistrySet;
import org.jspecify.annotations.Nullable;

public record DialogListTypeImpl(RegistrySet<Dialog> dialogs, @Nullable ActionButton exitAction, int columns, int buttonWidth) implements DialogListType
{

    public static final class BuilderImpl
    implements DialogListType.Builder {
        private final RegistrySet<Dialog> dialogs;
        private @Nullable ActionButton exitAction;
        private int columns = 2;
        private int buttonWidth = 150;

        public BuilderImpl(RegistrySet<Dialog> dialogs) {
            this.dialogs = dialogs;
        }

        public DialogListType.Builder exitAction(@Nullable ActionButton exitAction) {
            this.exitAction = exitAction;
            return this;
        }

        public DialogListType.Builder columns(int columns) {
            Preconditions.checkArgument((columns > 0 ? 1 : 0) != 0, (Object)"columns must be greater than 0");
            this.columns = columns;
            return this;
        }

        public DialogListType.Builder buttonWidth(int buttonWidth) {
            Preconditions.checkArgument((buttonWidth >= 1 && buttonWidth <= 1024 ? 1 : 0) != 0, (Object)"buttonWidth must be between 1 and 1024");
            this.buttonWidth = buttonWidth;
            return this;
        }

        public DialogListType build() {
            return new DialogListTypeImpl(this.dialogs, this.exitAction, this.columns, this.buttonWidth);
        }
    }
}

