/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.NamedRegistryKeySetImpl;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.set.RegistryValueSet;
import io.papermc.paper.util.Holderable;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;

public final class PaperRegistrySets {
    public static <A extends Keyed, M> HolderSet<M> convertToNms(ResourceKey<? extends IRegistry<M>> resourceKey, RegistryOps.c lookup, RegistryKeySet<A> registryKeySet) {
        if (registryKeySet instanceof NamedRegistryKeySetImpl) {
            return ((NamedRegistryKeySetImpl)registryKeySet).namedSet();
        }
        RegistryOps.b registryInfo = lookup.a(resourceKey).orElseThrow();
        return HolderSet.a(key -> registryInfo.b().b(PaperRegistries.toNms(key)), registryKeySet.values());
    }

    public static <A extends Keyed, M> HolderSet<M> convertToNmsWithDirects(ResourceKey<? extends IRegistry<M>> resourceKey, RegistryOps.c lookup, RegistrySet<A> registrySet) {
        if (registrySet instanceof NamedRegistryKeySetImpl) {
            return ((NamedRegistryKeySetImpl)registrySet).namedSet();
        }
        if (registrySet.isEmpty()) {
            return HolderSet.f();
        }
        if (registrySet instanceof RegistryValueSet) {
            RegistryValueSet valueSet = (RegistryValueSet)registrySet;
            ArrayList directs = new ArrayList(valueSet.values().size());
            for (Keyed value : valueSet) {
                if (!(value instanceof Holderable)) {
                    throw new UnsupportedOperationException("Cannot convert a registry set containing non-holderable values");
                }
                Holderable holderable = (Holderable)value;
                directs.add(holderable.getHolder());
            }
            return HolderSet.a(directs);
        }
        if (registrySet instanceof RegistryKeySet) {
            RegistryKeySet keySet = (RegistryKeySet)registrySet;
            RegistryOps.b registryInfo = lookup.a(resourceKey).orElseThrow();
            return HolderSet.a(key -> registryInfo.b().b(PaperRegistries.toNms(key)), keySet.values());
        }
        throw new UnsupportedOperationException("Cannot convert a registry set of type " + registrySet.getClass().getName());
    }

    public static <A extends Keyed, M> RegistryKeySet<A> convertToApi(RegistryKey<A> registryKey, HolderSet<M> holders) {
        if (holders instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)holders;
            return new NamedRegistryKeySetImpl(PaperRegistries.fromNms(named.h()), named);
        }
        ArrayList keys = new ArrayList();
        for (Holder holder : holders) {
            if (!(holder instanceof Holder.c)) {
                throw new UnsupportedOperationException("Cannot convert a holder set containing direct holders");
            }
            Holder.c reference = (Holder.c)holder;
            keys.add(PaperRegistries.fromNms(reference.h()));
        }
        return RegistrySet.keySet(registryKey, keys);
    }

    public static <A extends Keyed, M> RegistrySet<A> convertToApiWithDirects(RegistryKey<A> registryKey, HolderSet<M> holders) {
        if (holders instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)holders;
            return new NamedRegistryKeySetImpl(PaperRegistries.fromNms(named.h()), named);
        }
        if (holders.b() == 0) {
            return RegistrySet.keySet(registryKey, (TypedKey[])new TypedKey[0]);
        }
        if (holders.a(0) instanceof Holder.a) {
            ArrayList directs = new ArrayList(holders.b());
            ResourceKey nmsRegistryKey = PaperRegistries.registryToNms(registryKey);
            for (Holder holder : holders) {
                directs.add(CraftRegistry.minecraftHolderToBukkit(holder, nmsRegistryKey));
            }
            return RegistrySet.valueSet(registryKey, directs);
        }
        ArrayList keys = new ArrayList(holders.b());
        for (Holder holder : holders) {
            keys.add(PaperRegistries.fromNms(((Holder.c)holder).h()));
        }
        return RegistrySet.keySet(registryKey, keys);
    }

    private PaperRegistrySets() {
    }
}

