/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.flag;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.papermc.paper.world.flag.FeatureDependant;
import io.papermc.paper.world.flag.FeatureFlagProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import org.bukkit.GameRule;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionType;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionType;

public class PaperFeatureFlagProviderImpl
implements FeatureFlagProvider {
    public static final BiMap<org.bukkit.FeatureFlag, FeatureFlag> FLAGS = ImmutableBiMap.of((Object)org.bukkit.FeatureFlag.MINECART_IMPROVEMENTS, (Object)FeatureFlags.d, (Object)org.bukkit.FeatureFlag.REDSTONE_EXPERIMENTS, (Object)FeatureFlags.c, (Object)org.bukkit.FeatureFlag.TRADE_REBALANCE, (Object)FeatureFlags.b, (Object)org.bukkit.FeatureFlag.VANILLA, (Object)FeatureFlags.a);

    public Set<org.bukkit.FeatureFlag> requiredFeatures(FeatureDependant dependant) {
        FeatureFlagSet requiredFeatures = PaperFeatureFlagProviderImpl.getFeatureElement(dependant).k();
        return PaperFeatureFlagProviderImpl.fromNms(requiredFeatures);
    }

    public static Set<org.bukkit.FeatureFlag> fromNms(FeatureFlagSet flagSet) {
        HashSet<org.bukkit.FeatureFlag> flags = new HashSet<org.bukkit.FeatureFlag>();
        for (FeatureFlag nmsFlag : FeatureFlags.e.c.values()) {
            if (!flagSet.b(nmsFlag)) continue;
            flags.add((org.bukkit.FeatureFlag)FLAGS.inverse().get((Object)nmsFlag));
        }
        return Collections.unmodifiableSet(flags);
    }

    static FeatureElement getFeatureElement(FeatureDependant dependant) {
        if (dependant instanceof EntityType) {
            EntityType entityType = (EntityType)dependant;
            return CraftEntityType.bukkitToMinecraft(entityType);
        }
        if (dependant instanceof PotionType) {
            PotionType potionType = (PotionType)dependant;
            return CraftPotionType.bukkitToMinecraft(potionType);
        }
        if (dependant instanceof GameRule) {
            GameRule gameRule = (GameRule)dependant;
            return PaperFeatureFlagProviderImpl.getGameRuleType(gameRule.getName()).asFeatureElement();
        }
        throw new IllegalArgumentException(String.valueOf(dependant) + " is not a valid feature dependant");
    }

    private static GameRules.GameRuleDefinition<?> getGameRuleType(String name) {
        for (Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>> gameRules : GameRules.ak.entrySet()) {
            if (!gameRules.getKey().a().equals(name)) continue;
            return gameRules.getValue();
        }
        return null;
    }
}

