/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.serialization.DataResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private static final Pattern a = Pattern.compile("(<name>.*) \\((<count>\\d*)\\)", 66);
    private static final int b = 255;
    private static final Pattern c = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    private static final Pattern d = Pattern.compile("[-._a-z0-9]+");

    public static String a(String name) {
        for (char c2 : SharedConstants.bm) {
            name = name.replace(c2, '_');
        }
        return name.replaceAll("[./\"]", "_");
    }

    public static String a(Path dirPath, String fileName, String fileFormat) throws IOException {
        if (!FileUtils.b((String)(fileName = FileUtils.a((String)fileName)))) {
            fileName = "_" + (String)fileName + "_";
        }
        Matcher matcher = a.matcher((CharSequence)fileName);
        int i2 = 0;
        if (matcher.matches()) {
            fileName = matcher.group("name");
            i2 = Integer.parseInt(matcher.group("count"));
        }
        if (((String)fileName).length() > 255 - fileFormat.length()) {
            fileName = ((String)fileName).substring(0, 255 - fileFormat.length());
        }
        while (true) {
            Object string = fileName;
            if (i2 != 0) {
                String string1 = " (" + i2 + ")";
                int i1 = 255 - string1.length();
                if (((String)fileName).length() > i1) {
                    string = ((String)fileName).substring(0, i1);
                }
                string = (String)string + string1;
            }
            string = (String)string + fileFormat;
            Path path = dirPath.resolve((String)string);
            try {
                Path path1 = Files.createDirectory(path, new FileAttribute[0]);
                Files.deleteIfExists(path1);
                return dirPath.relativize(path1).toString();
            }
            catch (FileAlreadyExistsException var8) {
                ++i2;
                continue;
            }
            break;
        }
    }

    public static boolean a(Path path) {
        Path path1 = path.normalize();
        return path1.equals(path);
    }

    public static boolean b(Path path) {
        for (Path path1 : path) {
            if (FileUtils.b(path1.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean b(String path) {
        return !c.matcher(path).matches();
    }

    public static Path b(Path dirPath, String locationPath, String fileFormat) {
        String string = locationPath + fileFormat;
        Path path = Paths.get(string, new String[0]);
        if (path.endsWith(fileFormat)) {
            throw new InvalidPathException(string, "empty resource name");
        }
        return dirPath.resolve(path);
    }

    public static String c(String path) {
        return FilenameUtils.getFullPath((String)path).replace(File.separator, "/");
    }

    public static String d(String path) {
        return FilenameUtils.normalize((String)path).replace(File.separator, "/");
    }

    public static DataResult<List<String>> e(String path) {
        int index = path.indexOf(47);
        if (index == -1) {
            return switch (path) {
                case "", ".", ".." -> DataResult.error(() -> "Invalid path '" + path + "'");
                default -> !FileUtils.f(path) ? DataResult.error(() -> "Invalid path '" + path + "'") : DataResult.success(List.of(path));
            };
        }
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        boolean flag = false;
        while (true) {
            String sub;
            switch (sub = path.substring(i2, index)) {
                case "": 
                case ".": 
                case "..": {
                    return DataResult.error(() -> "Invalid segment '" + sub + "' in path '" + path + "'");
                }
            }
            if (!FileUtils.f(sub)) {
                return DataResult.error(() -> "Invalid segment '" + sub + "' in path '" + path + "'");
            }
            list.add(sub);
            if (flag) {
                return DataResult.success(list);
            }
            i2 = index + 1;
            if ((index = path.indexOf(47, i2)) != -1) continue;
            index = path.length();
            flag = true;
        }
    }

    public static Path a(Path path, List<String> subdirectories) {
        int size = subdirectories.size();
        return switch (size) {
            case 0 -> path;
            case 1 -> path.resolve(subdirectories.get(0));
            default -> {
                String[] strings = new String[size - 1];
                for (int i = 1; i < size; ++i) {
                    strings[i - 1] = subdirectories.get(i);
                }
                yield path.resolve(path.getFileSystem().getPath(subdirectories.get(0), strings));
            }
        };
    }

    public static boolean f(String segment) {
        return d.matcher(segment).matches();
    }

    public static void a(String ... elements) {
        if (elements.length == 0) {
            throw new IllegalArgumentException("Path must have at least one element");
        }
        for (String string : elements) {
            if (!string.equals("..") && !string.equals(".") && FileUtils.f(string)) continue;
            throw new IllegalArgumentException("Illegal segment " + string + " in path " + Arrays.toString(elements));
        }
    }

    public static void c(Path path) throws IOException {
        Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
    }
}

