/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class MinecraftVersion {
    private static final Logger b = LogUtils.getLogger();
    public static final WorldVersion a = MinecraftVersion.a(UUID.randomUUID().toString().replaceAll("-", ""), "Development Version");

    public static WorldVersion a(String id, String name) {
        return MinecraftVersion.a(id, name, true);
    }

    public static WorldVersion a(String id, String name, boolean stable) {
        return new WorldVersion.a(id, name, new DataVersion(4556, "main"), SharedConstants.c(), PackFormat.a(69, 0), PackFormat.a(88, 0), new Date(), stable);
    }

    private static WorldVersion a(JsonObject json) {
        JsonObject asJsonObject = ChatDeserializer.u(json, "pack_version");
        return new WorldVersion.a(ChatDeserializer.i(json, "id"), ChatDeserializer.i(json, "name"), new DataVersion(ChatDeserializer.o(json, "world_version"), ChatDeserializer.a(json, "series_id", "main")), ChatDeserializer.o(json, "protocol_version"), PackFormat.a(ChatDeserializer.o(asJsonObject, "resource_major"), ChatDeserializer.o(asJsonObject, "resource_minor")), PackFormat.a(ChatDeserializer.o(asJsonObject, "data_major"), ChatDeserializer.o(asJsonObject, "data_minor")), Date.from(ZonedDateTime.parse(ChatDeserializer.i(json, "build_time")).toInstant()), ChatDeserializer.k(json, "stable"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion a() {
        try (InputStream resourceAsStream = MinecraftVersion.class.getResourceAsStream("/version.json");){
            if (resourceAsStream == null) {
                b.warn("Missing version information!");
                WorldVersion worldVersion = a;
                return worldVersion;
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);){
                WorldVersion var2 = MinecraftVersion.a(ChatDeserializer.a(inputStreamReader));
                return var2;
            }
        }
        catch (JsonParseException | IOException var8) {
            throw new IllegalStateException("Game version information is corrupt", var8);
        }
    }
}

