/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class SystemReport {
    public static final long a = 0x100000L;
    private static final long b = 1000000000L;
    private static final Logger c = LogUtils.getLogger();
    private static final String d = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String e = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String f = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> g = Maps.newLinkedHashMap();

    public SystemReport() {
        this.a("Minecraft Version", SharedConstants.b().c());
        this.a("Minecraft Version ID", SharedConstants.b().b());
        this.a("Operating System", d);
        this.a("Java Version", e);
        this.a("Java VM Version", f);
        this.a("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long l2 = runtime.maxMemory();
            long l1 = runtime.totalMemory();
            long l22 = runtime.freeMemory();
            long l3 = l2 / 0x100000L;
            long l4 = l1 / 0x100000L;
            long l5 = l22 / 0x100000L;
            return l22 + " bytes (" + l5 + " MiB) / " + l1 + " bytes (" + l4 + " MiB) up to " + l2 + " bytes (" + l3 + " MiB)";
        });
        this.a("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.a("hardware", () -> this.a(new SystemInfo()));
        this.a("JVM Flags", () -> SystemReport.a((String string) -> string.startsWith("-X")));
        this.a("Debug Flags", () -> SystemReport.a((String string) -> string.startsWith("-DMC_DEBUG_")));
    }

    private static String a(Predicate<String> typePredicate) {
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        List<String> list = inputArguments.stream().filter(typePredicate).toList();
        return String.format(Locale.ROOT, "%d total; %s", list.size(), String.join((CharSequence)" ", list));
    }

    public void a(String identifier, String value) {
        this.g.put(identifier, value);
    }

    public void a(String identifier, Supplier<String> valueSupplier) {
        try {
            this.a(identifier, valueSupplier.get());
        }
        catch (Exception var4) {
            c.warn("Failed to get system info for {}", (Object)identifier, (Object)var4);
            this.a(identifier, "ERR");
        }
    }

    private void a(SystemInfo info) {
        HardwareAbstractionLayer hardware = info.getHardware();
        this.a("processor", () -> this.a(hardware.getProcessor()));
        this.a("graphics", () -> this.b(hardware.getGraphicsCards()));
        this.a("memory", () -> this.a(hardware.getMemory()));
        this.a("storage", this::b);
    }

    private void a(String groupIdentifier, Runnable executor) {
        try {
            executor.run();
        }
        catch (Throwable var4) {
            c.warn("Failed retrieving info for group {}", (Object)groupIdentifier, (Object)var4);
        }
    }

    public static float a(long bytes) {
        return (float)bytes / 1048576.0f;
    }

    private void a(List<PhysicalMemory> memorySlots) {
        int i2 = 0;
        for (PhysicalMemory physicalMemory : memorySlots) {
            String string = String.format(Locale.ROOT, "Memory slot #%d ", i2++);
            this.a(string + "capacity (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(physicalMemory.getCapacity()))));
            this.a(string + "clockSpeed (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)physicalMemory.getClockSpeed() / 1.0E9f)));
            this.a(string + "type", () -> ((PhysicalMemory)physicalMemory).getMemoryType());
        }
    }

    private void a(VirtualMemory memory) {
        this.a("Virtual memory max (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(memory.getVirtualMax()))));
        this.a("Virtual memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(memory.getVirtualInUse()))));
        this.a("Swap memory total (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(memory.getSwapTotal()))));
        this.a("Swap memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(memory.getSwapUsed()))));
    }

    private void a(GlobalMemory memory) {
        this.a("physical memory", () -> this.a(memory.getPhysicalMemory()));
        this.a("virtual memory", () -> this.a(memory.getVirtualMemory()));
    }

    private void b(List<GraphicsCard> gpus) {
        int i2 = 0;
        for (GraphicsCard graphicsCard : gpus) {
            String string = String.format(Locale.ROOT, "Graphics card #%d ", i2++);
            this.a(string + "name", () -> ((GraphicsCard)graphicsCard).getName());
            this.a(string + "vendor", () -> ((GraphicsCard)graphicsCard).getVendor());
            this.a(string + "VRAM (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(graphicsCard.getVRam()))));
            this.a(string + "deviceId", () -> ((GraphicsCard)graphicsCard).getDeviceId());
            this.a(string + "versionInfo", () -> ((GraphicsCard)graphicsCard).getVersionInfo());
        }
    }

    private void a(CentralProcessor cpu) {
        CentralProcessor.ProcessorIdentifier processorIdentifier = cpu.getProcessorIdentifier();
        this.a("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getVendor());
        this.a("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getName());
        this.a("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getIdentifier());
        this.a("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getMicroarchitecture());
        this.a("Frequency (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)processorIdentifier.getVendorFreq() / 1.0E9f)));
        this.a("Number of physical packages", () -> String.valueOf(cpu.getPhysicalPackageCount()));
        this.a("Number of physical CPUs", () -> String.valueOf(cpu.getPhysicalProcessorCount()));
        this.a("Number of logical CPUs", () -> String.valueOf(cpu.getLogicalProcessorCount()));
    }

    private void b() {
        this.a("jna.tmpdir");
        this.a("org.lwjgl.system.SharedLibraryExtractPath");
        this.a("io.netty.native.workdir");
        this.a("java.io.tmpdir");
        this.b("workdir", () -> "");
    }

    private void a(String property) {
        this.b(property, () -> System.getProperty(property));
    }

    private void b(String property, Supplier<String> valueSupplier) {
        String string = "Space in storage for " + property + " (MiB)";
        try {
            String string1 = valueSupplier.get();
            if (string1 == null) {
                this.a(string, "<path not set>");
                return;
            }
            FileStore fileStore = Files.getFileStore(Path.of(string1, new String[0]));
            this.a(string, String.format(Locale.ROOT, "available: %.2f, total: %.2f", Float.valueOf(SystemReport.a(fileStore.getUsableSpace())), Float.valueOf(SystemReport.a(fileStore.getTotalSpace()))));
        }
        catch (InvalidPathException var6) {
            c.warn("{} is not a path", (Object)property, (Object)var6);
            this.a(string, "<invalid path>");
        }
        catch (Exception var7) {
            c.warn("Failed retrieving storage space for {}", (Object)property, (Object)var7);
            this.a(string, "ERR");
        }
    }

    public void a(StringBuilder reportAppender) {
        reportAppender.append("-- ").append("System Details").append(" --\n");
        reportAppender.append("Details:");
        this.g.forEach((string, string1) -> {
            reportAppender.append("\n\t");
            reportAppender.append((String)string);
            reportAppender.append(": ");
            reportAppender.append((String)string1);
        });
    }

    public String a() {
        return this.g.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

