/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public final class CriterionConditionBlock
extends Record {
    private final Optional<HolderSet<Block>> c;
    private final Optional<CriterionTriggerProperties> d;
    private final Optional<CriterionConditionNBT> e;
    private final DataComponentMatchers f;
    public static final Codec<CriterionConditionBlock> a = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.a(Registries.i).optionalFieldOf("blocks").forGetter(CriterionConditionBlock::b), (App)CriterionTriggerProperties.a.optionalFieldOf("state").forGetter(CriterionConditionBlock::c), (App)CriterionConditionNBT.a.optionalFieldOf("nbt").forGetter(CriterionConditionBlock::d), (App)DataComponentMatchers.b.forGetter(CriterionConditionBlock::e)).apply((Applicative)instance, CriterionConditionBlock::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CriterionConditionBlock> b = StreamCodec.a(ByteBufCodecs.a(ByteBufCodecs.c(Registries.i)), CriterionConditionBlock::b, ByteBufCodecs.a(CriterionTriggerProperties.b), CriterionConditionBlock::c, ByteBufCodecs.a(CriterionConditionNBT.b), CriterionConditionBlock::d, DataComponentMatchers.c, CriterionConditionBlock::e, CriterionConditionBlock::new);

    public CriterionConditionBlock(Optional<HolderSet<Block>> blocks, Optional<CriterionTriggerProperties> properties, Optional<CriterionConditionNBT> nbt, DataComponentMatchers components) {
        this.c = blocks;
        this.d = properties;
        this.e = nbt;
        this.f = components;
    }

    public boolean a(WorldServer level, BlockPosition pos) {
        if (!level.p(pos)) {
            return false;
        }
        if (!this.a(level.a_(pos))) {
            return false;
        }
        if (this.e.isPresent() || !this.f.a()) {
            TileEntity blockEntity = level.c_(pos);
            if (this.e.isPresent() && !CriterionConditionBlock.a(level, blockEntity, this.e.get())) {
                return false;
            }
            if (!this.f.a() && !CriterionConditionBlock.a(blockEntity, this.f)) {
                return false;
            }
        }
        return true;
    }

    public boolean a(ShapeDetectorBlock block) {
        return this.a(block.a()) && (!this.e.isPresent() || CriterionConditionBlock.a(block.c(), block.b(), this.e.get()));
    }

    private boolean a(IBlockData state) {
        return !(this.c.isPresent() && !state.a(this.c.get()) || this.d.isPresent() && !this.d.get().a(state));
    }

    private static boolean a(IWorldReader level, @Nullable TileEntity blockEntity, CriterionConditionNBT nbtPredicate) {
        return blockEntity != null && nbtPredicate.a(blockEntity.b(level.L_()));
    }

    private static boolean a(@Nullable TileEntity entity, DataComponentMatchers components) {
        return entity != null && components.a(entity.t());
    }

    public boolean a() {
        return this.e.isPresent();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionBlock.class, "blocks;properties;nbt;components", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionBlock.class, "blocks;properties;nbt;components", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionBlock.class, "blocks;properties;nbt;components", "c", "d", "e", "f"}, this, o2);
    }

    public Optional<HolderSet<Block>> b() {
        return this.c;
    }

    public Optional<CriterionTriggerProperties> c() {
        return this.d;
    }

    public Optional<CriterionConditionNBT> d() {
        return this.e;
    }

    public DataComponentMatchers e() {
        return this.f;
    }

    public static class a {
        private Optional<HolderSet<Block>> a = Optional.empty();
        private Optional<CriterionTriggerProperties> b = Optional.empty();
        private Optional<CriterionConditionNBT> c = Optional.empty();
        private DataComponentMatchers d = DataComponentMatchers.a;

        private a() {
        }

        public static a a() {
            return new a();
        }

        public a a(HolderGetter<Block> blockRegistry, Block ... blocks) {
            return this.a(blockRegistry, Arrays.asList(blocks));
        }

        public a a(HolderGetter<Block> blockRegistry, Collection<Block> blocks) {
            this.a = Optional.of(HolderSet.a(Block::p, blocks));
            return this;
        }

        public a a(HolderGetter<Block> blockRegistry, TagKey<Block> blockTag) {
            this.a = Optional.of(blockRegistry.b(blockTag));
            return this;
        }

        public a a(NBTTagCompound nbt) {
            this.c = Optional.of(new CriterionConditionNBT(nbt));
            return this;
        }

        public a a(CriterionTriggerProperties.a properties) {
            this.b = properties.b();
            return this;
        }

        public a a(DataComponentMatchers components) {
            this.d = components;
            return this;
        }

        public CriterionConditionBlock b() {
            return new CriterionConditionBlock(this.a, this.b, this.c, this.d);
        }
    }
}

