/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.PermissionSource;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;

public class ArgumentEntity
implements ArgumentType<EntitySelector> {
    private static final Collection<String> g = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.toomany"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.player.toomany"));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.player.entities"));
    public static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType f = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.selector.not_allowed"));
    final boolean h;
    final boolean i;

    protected ArgumentEntity(boolean single, boolean playersOnly) {
        this.h = single;
        this.i = playersOnly;
    }

    public static ArgumentEntity a() {
        return new ArgumentEntity(true, false);
    }

    public static Entity a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).a((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentEntity b() {
        return new ArgumentEntity(false, false);
    }

    public static Collection<? extends Entity> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        Collection<? extends Entity> optionalEntities = ArgumentEntity.c(context, name);
        if (optionalEntities.isEmpty()) {
            throw d.create();
        }
        return optionalEntities;
    }

    public static Collection<? extends Entity> c(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).b((CommandListenerWrapper)context.getSource());
    }

    public static Collection<EntityPlayer> d(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).d((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentEntity c() {
        return new ArgumentEntity(true, true);
    }

    public static EntityPlayer e(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).c((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentEntity d() {
        return new ArgumentEntity(false, true);
    }

    public static Collection<EntityPlayer> f(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        List<EntityPlayer> list = ((EntitySelector)context.getArgument(name, EntitySelector.class)).d((CommandListenerWrapper)context.getSource());
        if (list.isEmpty()) {
            throw e.create();
        }
        return list;
    }

    public EntitySelector a(StringReader reader) throws CommandSyntaxException {
        return this.a(reader, true);
    }

    public <S> EntitySelector a(StringReader reader, S suggestionProvider) throws CommandSyntaxException {
        return this.a(reader, ArgumentParserSelector.a(suggestionProvider));
    }

    private EntitySelector a(StringReader reader, boolean allowSelectors) throws CommandSyntaxException {
        return this.parse(reader, allowSelectors, false);
    }

    public EntitySelector parse(StringReader reader, boolean allowSelectors, boolean overridePermissions) throws CommandSyntaxException {
        boolean i2 = false;
        ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(reader, allowSelectors);
        EntitySelector entitySelector = entitySelectorParser.parse(overridePermissions);
        if (entitySelector.a() > 1 && this.h) {
            if (this.i) {
                reader.setCursor(0);
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            reader.setCursor(0);
            throw a.createWithContext((ImmutableStringReader)reader);
        }
        if (entitySelector.b() && this.i && !entitySelector.c()) {
            reader.setCursor(0);
            throw c.createWithContext((ImmutableStringReader)reader);
        }
        return entitySelector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof ICompletionProvider) {
            boolean bl;
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            if (sharedSuggestionProvider instanceof CommandListenerWrapper) {
                CommandListenerWrapper stack = (CommandListenerWrapper)sharedSuggestionProvider;
                bl = stack.bypassSelectorPermissions || stack.hasPermission(2, "minecraft.command.selector");
            } else {
                PermissionSource permissionSource;
                bl = sharedSuggestionProvider instanceof PermissionSource && (permissionSource = (PermissionSource)((Object)sharedSuggestionProvider)).c(2);
            }
            boolean permission = bl;
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(stringReader, permission);
            try {
                entitySelectorParser.t();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorParser.a(builder, (SuggestionsBuilder offsetBuilder) -> {
                Collection<String> onlinePlayerNames = sharedSuggestionProvider.q();
                Collection<String> iterable = this.i ? onlinePlayerNames : Iterables.concat(onlinePlayerNames, sharedSuggestionProvider.z());
                ICompletionProvider.b(iterable, offsetBuilder);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return g;
    }

    public static class Info
    implements ArgumentTypeInfo<ArgumentEntity, Template> {
        private static final byte a = 1;
        private static final byte b = 2;

        @Override
        public void a(Template template, PacketDataSerializer buffer) {
            int i2 = 0;
            if (template.b) {
                i2 |= 1;
            }
            if (template.c) {
                i2 |= 2;
            }
            buffer.l(i2);
        }

        @Override
        public Template a(PacketDataSerializer buffer) {
            byte _byte = buffer.readByte();
            return new Template((_byte & 1) != 0, (_byte & 2) != 0);
        }

        @Override
        public void a(Template template, JsonObject json) {
            json.addProperty("amount", template.b ? "single" : "multiple");
            json.addProperty("type", template.c ? "players" : "entities");
        }

        @Override
        public Template a(ArgumentEntity argument) {
            return new Template(argument.h, argument.i);
        }

        public final class Template
        implements ArgumentTypeInfo.a<ArgumentEntity> {
            final boolean b;
            final boolean c;

            Template(boolean single, boolean playersOnly) {
                this.b = single;
                this.c = playersOnly;
            }

            public ArgumentEntity a(CommandBuildContext context) {
                return new ArgumentEntity(this.b, this.c);
            }

            @Override
            public ArgumentTypeInfo<ArgumentEntity, ?> a() {
                return Info.this;
            }
        }
    }
}

