/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.EnumGamemode;

public class GameModeArgument
implements ArgumentType<EnumGamemode> {
    private static final Collection<String> a = Stream.of(EnumGamemode.a, EnumGamemode.b).map(EnumGamemode::b).collect(Collectors.toList());
    private static final EnumGamemode[] b = EnumGamemode.values();
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(invalidGameType -> IChatBaseComponent.b("argument.gamemode.invalid", invalidGameType));

    public EnumGamemode a(StringReader reader) throws CommandSyntaxException {
        String unquotedString = reader.readUnquotedString();
        EnumGamemode gameType = EnumGamemode.a(unquotedString, null);
        if (gameType == null) {
            throw c.createWithContext((ImmutableStringReader)reader, (Object)unquotedString);
        }
        return gameType;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof ICompletionProvider ? ICompletionProvider.b(Arrays.stream(b).map(EnumGamemode::b), builder) : Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return a;
    }

    public static GameModeArgument a() {
        return new GameModeArgument();
    }

    public static EnumGamemode a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return (EnumGamemode)context.getArgument(name, EnumGamemode.class);
    }
}

