/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;

public class ResourceArgument<T>
implements ArgumentType<Holder.c<T>> {
    private static final Collection<String> c = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(entityType -> IChatBaseComponent.b("entity.not_summonable", entityType));
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((resourceName, resourceType) -> IChatBaseComponent.b("argument.resource.not_found", resourceName, resourceType));
    public static final Dynamic3CommandExceptionType b = new Dynamic3CommandExceptionType((resourceName, actualResourceType, expectedResourceType) -> IChatBaseComponent.b("argument.resource.invalid_type", resourceName, actualResourceType, expectedResourceType));
    final ResourceKey<? extends IRegistry<T>> e;
    private final HolderLookup<T> f;

    public ResourceArgument(CommandBuildContext context, ResourceKey<? extends IRegistry<T>> registryKey) {
        this.e = registryKey;
        this.f = context.e(registryKey);
    }

    public static <T> ResourceArgument<T> a(CommandBuildContext context, ResourceKey<? extends IRegistry<T>> registryKey) {
        return new ResourceArgument<T>(context, registryKey);
    }

    public static <T> Holder.c<T> a(CommandContext<CommandListenerWrapper> context, String argument, ResourceKey<IRegistry<T>> registryKey) throws CommandSyntaxException {
        Holder.c reference = (Holder.c)context.getArgument(argument, Holder.c.class);
        ResourceKey resourceKey = reference.h();
        if (resourceKey.c(registryKey)) {
            return reference;
        }
        throw b.create((Object)resourceKey.a(), (Object)resourceKey.b(), (Object)registryKey.a());
    }

    public static Holder.c<AttributeBase> a(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceArgument.a(context, argument, Registries.c);
    }

    public static Holder.c<WorldGenFeatureConfigured<?, ?>> b(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceArgument.a(context, argument, Registries.aS);
    }

    public static Holder.c<Structure> c(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceArgument.a(context, argument, Registries.bm);
    }

    public static Holder.c<EntityTypes<?>> d(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceArgument.a(context, argument, Registries.E);
    }

    public static Holder.c<EntityTypes<?>> e(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        Holder.c<EntityTypes<?>> resource = ResourceArgument.a(context, argument, Registries.E);
        if (!((EntityTypes)resource.a()).c()) {
            throw d.create((Object)resource.h().a().toString());
        }
        return resource;
    }

    public static Holder.c<MobEffectList> f(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceArgument.a(context, argument, Registries.aa);
    }

    public static Holder.c<Enchantment> g(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceArgument.a(context, argument, Registries.aZ);
    }

    public Holder.c<T> a(StringReader builder) throws CommandSyntaxException {
        MinecraftKey resourceLocation = MinecraftKey.a(builder);
        ResourceKey resourceKey = ResourceKey.a(this.e, resourceLocation);
        return this.f.a(resourceKey).orElseThrow(() -> a.createWithContext((ImmutableStringReader)builder, (Object)resourceLocation, (Object)this.e.a()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ICompletionProvider.a(context, builder, this.e, ICompletionProvider.a.b);
    }

    public Collection<String> getExamples() {
        return c;
    }

    public static class net.minecraft.commands.arguments.ResourceArgument$a<T>
    implements ArgumentTypeInfo<ResourceArgument<T>, a> {
        @Override
        public void a(a template, PacketDataSerializer buffer) {
            buffer.b(template.b);
        }

        @Override
        public a a(PacketDataSerializer buffer) {
            return new a(buffer.r());
        }

        @Override
        public void a(a template, JsonObject json) {
            json.addProperty("registry", template.b.a().toString());
        }

        @Override
        public a a(ResourceArgument<T> argument) {
            return new a(argument.e);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryKey) {
                this.b = registryKey;
            }

            public ResourceArgument<T> a(CommandBuildContext context) {
                return new ResourceArgument(context, this.b);
            }

            @Override
            public ArgumentTypeInfo<ResourceArgument<T>, ?> a() {
                return a.this;
            }
        }
    }
}

