/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> d = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("argument.resource_or_id.failed_to_parse", object));
    public static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("argument.resource_or_id.no_such_element", object, object1));
    public static final DynamicOps<NBTBase> c = DynamicOpsNBT.a;
    private final HolderLookup.a e;
    private final Optional<? extends HolderLookup.b<T>> f;
    private final Codec<T> g;
    private final Grammar<g<T, NBTBase>> h;
    private final ResourceKey<? extends IRegistry<T>> i;

    protected ResourceOrIdArgument(CommandBuildContext registryLookup, ResourceKey<? extends IRegistry<T>> registryKey, Codec<T> codec) {
        this.e = registryLookup;
        this.f = registryLookup.a(registryKey);
        this.i = registryKey;
        this.g = codec;
        this.h = ResourceOrIdArgument.a(registryKey, c);
    }

    public static <T, O> Grammar<g<T, O>> a(ResourceKey<? extends IRegistry<T>> registryKey, DynamicOps<O> ops) {
        Grammar<O> grammar = SnbtGrammar.a(ops);
        Dictionary<StringReader> dictionary = new Dictionary<StringReader>();
        Atom atom = Atom.a("result");
        Atom atom1 = Atom.a("id");
        Atom atom2 = Atom.a("value");
        dictionary.a(atom1, ResourceLocationParseRule.a);
        dictionary.a(atom2, grammar.b().b());
        NamedRule namedRule = dictionary.a(atom, Term.b(dictionary.c(atom1), dictionary.c(atom2)), (Scope scope) -> {
            MinecraftKey resourceLocation = (MinecraftKey)scope.a(atom1);
            if (resourceLocation != null) {
                return new f(ResourceKey.a(registryKey, resourceLocation));
            }
            Object orThrow = scope.b(atom2);
            return new b(orThrow);
        });
        return new Grammar<g<T, O>>(dictionary, namedRule);
    }

    public static e a(CommandBuildContext context) {
        return new e(context);
    }

    public static Holder<LootTable> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceOrIdArgument.e(context, name);
    }

    public static c b(CommandBuildContext context) {
        return new c(context);
    }

    public static Holder<LootItemFunction> b(CommandContext<CommandListenerWrapper> context, String name) {
        return ResourceOrIdArgument.e(context, name);
    }

    public static d c(CommandBuildContext context) {
        return new d(context);
    }

    public static Holder<LootItemCondition> c(CommandContext<CommandListenerWrapper> context, String name) {
        return ResourceOrIdArgument.e(context, name);
    }

    public static a d(CommandBuildContext context) {
        return new a(context);
    }

    public static Holder<Dialog> d(CommandContext<CommandListenerWrapper> context, String name) {
        return ResourceOrIdArgument.e(context, name);
    }

    private static <T> Holder<T> e(CommandContext<CommandListenerWrapper> context, String name) {
        return (Holder)context.getArgument(name, Holder.class);
    }

    @Nullable
    public Holder<T> a(StringReader reader) throws CommandSyntaxException {
        return this.a(reader, this.h, c);
    }

    @Nullable
    private <O> Holder<T> a(StringReader reader, Grammar<g<T, O>> grammar, DynamicOps<O> ops) throws CommandSyntaxException {
        g<T, O> result = grammar.a(reader);
        return this.f.isEmpty() ? null : result.a((ImmutableStringReader)reader, this.e, ops, this.g, this.f.get());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ICompletionProvider.a(context, builder, this.i, ICompletionProvider.a.b);
    }

    public Collection<String> getExamples() {
        return d;
    }

    public static class e
    extends ResourceOrIdArgument<LootTable> {
        protected e(CommandBuildContext context) {
            super(context, Registries.bz, LootTable.d);
        }
    }

    public static class c
    extends ResourceOrIdArgument<LootItemFunction> {
        protected c(CommandBuildContext context) {
            super(context, Registries.bA, LootItemFunctions.c);
        }
    }

    public static class d
    extends ResourceOrIdArgument<LootItemCondition> {
        protected d(CommandBuildContext context) {
            super(context, Registries.bB, LootItemCondition.e);
        }
    }

    public static class a
    extends ResourceOrIdArgument<Dialog> {
        protected a(CommandBuildContext context) {
            super(context, Registries.aW, Dialog.c);
        }
    }

    public static sealed interface g<T, O>
    permits b, f {
        public Holder<T> a(ImmutableStringReader var1, HolderLookup.a var2, DynamicOps<O> var3, Codec<T> var4, HolderLookup.b<T> var5) throws CommandSyntaxException;
    }

    public record f<T, O>(ResourceKey<T> a) implements g<T, O>
    {
        @Override
        public Holder<T> a(ImmutableStringReader reader, HolderLookup.a registryLookup, DynamicOps<O> ops, Codec<T> codec, HolderLookup.b<T> elementLookup) throws CommandSyntaxException {
            return elementLookup.a(this.a).orElseThrow(() -> b.createWithContext(reader, (Object)this.a.a(), (Object)this.a.b()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "key", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "key", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "key", "a"}, this, o2);
        }
    }

    public record b<T, O>(O a) implements g<T, O>
    {
        @Override
        public Holder<T> a(ImmutableStringReader reader, HolderLookup.a registryLookup, DynamicOps<O> ops, Codec<T> codec, HolderLookup.b<T> elementLookup) throws CommandSyntaxException {
            return Holder.a(codec.parse(registryLookup.a(ops), this.a).getOrThrow(string -> a.createWithContext(reader, string)));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "value", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "value", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "value", "a"}, this, o2);
        }
    }
}

