/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.io.FilenameUtils;

public class ResourceSelectorArgument<T>
implements ArgumentType<Collection<Holder.c<T>>> {
    private static final Collection<String> b = List.of("minecraft:*", "*:asset", "*");
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("argument.resource_selector.not_found", object, object1));
    final ResourceKey<? extends IRegistry<T>> c;
    private final HolderLookup<T> d;

    ResourceSelectorArgument(CommandBuildContext buildContext, ResourceKey<? extends IRegistry<T>> registryKey) {
        this.c = registryKey;
        this.d = buildContext.e(registryKey);
    }

    public Collection<Holder.c<T>> a(StringReader reader) throws CommandSyntaxException {
        String string = ResourceSelectorArgument.a(ResourceSelectorArgument.b(reader));
        List<Holder.c<T>> list = this.d.c().filter(reference -> ResourceSelectorArgument.a(string, reference.h().a())).toList();
        if (list.isEmpty()) {
            throw a.createWithContext((ImmutableStringReader)reader, (Object)string, (Object)this.c.a());
        }
        return list;
    }

    public static <T> Collection<Holder.c<T>> a(StringReader reader, HolderLookup<T> lookup) {
        String string = ResourceSelectorArgument.a(ResourceSelectorArgument.b(reader));
        return lookup.c().filter(reference -> ResourceSelectorArgument.a(string, reference.h().a())).toList();
    }

    private static String b(StringReader reader) {
        int cursor = reader.getCursor();
        while (reader.canRead() && ResourceSelectorArgument.a(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    private static boolean a(char character) {
        return MinecraftKey.a(character) || character == '*' || character == '?';
    }

    private static String a(String name) {
        return !name.contains(":") ? "minecraft:" + name : name;
    }

    private static boolean a(String string, MinecraftKey location) {
        return FilenameUtils.wildcardMatch((String)location.toString(), (String)string);
    }

    public static <T> ResourceSelectorArgument<T> a(CommandBuildContext buildContext, ResourceKey<? extends IRegistry<T>> registryKey) {
        return new ResourceSelectorArgument<T>(buildContext, registryKey);
    }

    public static <T> Collection<Holder.c<T>> a(CommandContext<CommandListenerWrapper> context, String name) {
        return (Collection)context.getArgument(name, Collection.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ICompletionProvider.a(context, builder, this.c, ICompletionProvider.a.b);
    }

    public Collection<String> getExamples() {
        return b;
    }

    public static class net.minecraft.commands.arguments.ResourceSelectorArgument$a<T>
    implements ArgumentTypeInfo<ResourceSelectorArgument<T>, a> {
        @Override
        public void a(a template, PacketDataSerializer buffer) {
            buffer.b(template.b);
        }

        @Override
        public a a(PacketDataSerializer buffer) {
            return new a(buffer.r());
        }

        @Override
        public void a(a template, JsonObject json) {
            json.addProperty("registry", template.b.a().toString());
        }

        @Override
        public a a(ResourceSelectorArgument<T> argument) {
            return new a(argument.c);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceSelectorArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryKey) {
                this.b = registryKey;
            }

            public ResourceSelectorArgument<T> a(CommandBuildContext context) {
                return new ResourceSelectorArgument(context, this.b);
            }

            @Override
            public ArgumentTypeInfo<ResourceSelectorArgument<T>, ?> a() {
                return a.this;
            }
        }
    }
}

