/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class ArgumentTileLocation
implements Predicate<ShapeDetectorBlock> {
    private static final Logger a = LogUtils.getLogger();
    private final IBlockData b;
    private final Set<IBlockState<?>> c;
    @Nullable
    public final NBTTagCompound d;

    public ArgumentTileLocation(IBlockData state, Set<IBlockState<?>> properties, @Nullable NBTTagCompound tag) {
        this.b = state;
        this.c = properties;
        this.d = tag;
    }

    public IBlockData a() {
        return this.b;
    }

    public Set<IBlockState<?>> b() {
        return this.c;
    }

    public boolean a(ShapeDetectorBlock block) {
        IBlockData state = block.a();
        if (!state.a(this.b.b())) {
            return false;
        }
        for (IBlockState<?> property : this.c) {
            if (state.c(property) == this.b.c(property)) continue;
            return false;
        }
        if (this.d == null) {
            return true;
        }
        TileEntity entity = block.b();
        return entity != null && GameProfileSerializer.a((NBTBase)this.d, entity.b(block.c().L_()), true);
    }

    public boolean a(WorldServer level, BlockPosition pos) {
        return this.a(new ShapeDetectorBlock(level, pos, false));
    }

    public boolean a(WorldServer level, BlockPosition pos, int flags) {
        TileEntity blockEntity;
        IBlockData blockState;
        IBlockData iBlockData = blockState = (flags & 0x10) != 0 ? this.b : Block.b(this.b, (GeneratorAccess)level, pos);
        if (blockState.l()) {
            blockState = this.b;
        }
        blockState = this.a(blockState);
        boolean flag = false;
        if (level.a(pos, blockState, flags)) {
            flag = true;
        }
        if (this.d != null && (blockEntity = level.c_(pos)) != null) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(a);){
                IRegistryCustom provider = level.L_();
                ProblemReporter problemReporter = scopedCollector.a(blockEntity.v());
                TagValueOutput tagValueOutput = TagValueOutput.a(problemReporter.a(() -> "(before)"), provider);
                blockEntity.e(tagValueOutput);
                NBTTagCompound compoundTag = tagValueOutput.b();
                blockEntity.b(TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)provider, this.d));
                TagValueOutput tagValueOutput1 = TagValueOutput.a(problemReporter.a(() -> "(after)"), provider);
                blockEntity.e(tagValueOutput1);
                NBTTagCompound compoundTag1 = tagValueOutput1.b();
                if (!compoundTag1.equals(compoundTag)) {
                    flag = true;
                    blockEntity.e();
                    level.n().a(pos);
                }
            }
        }
        return flag;
    }

    private IBlockData a(IBlockData state) {
        if (state == this.b) {
            return state;
        }
        for (IBlockState<?> property : this.c) {
            state = ArgumentTileLocation.a(state, this.b, property);
        }
        return state;
    }

    private static <T extends Comparable<T>> IBlockData a(IBlockData source, IBlockData target, IBlockState<T> property) {
        return (IBlockData)source.c(property, target.c(property));
    }
}

