/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentPredicateItemStack {
    private static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((item, quantity) -> IChatBaseComponent.b("arguments.item.overstacked", item, quantity));
    private final Holder<Item> b;
    private final DataComponentPatch c;

    public ArgumentPredicateItemStack(Holder<Item> item, DataComponentPatch components) {
        this.b = item;
        this.c = components;
    }

    public Item a() {
        return this.b.a();
    }

    public ItemStack a(int count, boolean allowOversizedStacks) throws CommandSyntaxException {
        ItemStack itemStack = new ItemStack(this.b, count);
        itemStack.b(this.c);
        if (allowOversizedStacks && count > itemStack.k()) {
            throw a.create((Object)this.b(), (Object)itemStack.k());
        }
        return itemStack;
    }

    public String a(HolderLookup.a levelRegistry) {
        StringBuilder stringBuilder = new StringBuilder(this.b());
        String string = this.b(levelRegistry);
        if (!string.isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(string);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private String b(HolderLookup.a levelRegistries) {
        RegistryOps<NBTBase> dynamicOps = levelRegistries.a(DynamicOpsNBT.a);
        return this.c.b().stream().flatMap(entry -> {
            DataComponentType dataComponentType = (DataComponentType)entry.getKey();
            MinecraftKey key = BuiltInRegistries.an.b(dataComponentType);
            if (key == null) {
                return Stream.empty();
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                TypedDataComponent typedDataComponent = TypedDataComponent.a(dataComponentType, optional.get());
                return typedDataComponent.a(dynamicOps).result().stream().map(tag -> key.toString() + "=" + String.valueOf(tag));
            }
            return Stream.of("!" + key.toString());
        }).collect(Collectors.joining(String.valueOf(',')));
    }

    private String b() {
        return this.b.e().map(ResourceKey::a).orElseGet(() -> "unknown[" + String.valueOf(this.b) + "]").toString();
    }
}

