/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.slf4j.Logger;

public class PlayerSelector {
    private static final Logger i = LogUtils.getLogger();
    private static final Map<String, b> j = Maps.newHashMap();
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(option -> IChatBaseComponent.b("argument.entity.options.unknown", option));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(option -> IChatBaseComponent.b("argument.entity.options.inapplicable", option));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(sort -> IChatBaseComponent.b("argument.entity.options.sort.irreversible", sort));
    public static final DynamicCommandExceptionType g = new DynamicCommandExceptionType(gameMode -> IChatBaseComponent.b("argument.entity.options.mode.invalid", gameMode));
    public static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(type -> IChatBaseComponent.b("argument.entity.options.type.invalid", type));

    private static void a(String id, a handler, Predicate<ArgumentParserSelector> predicate, IChatBaseComponent tooltip) {
        j.put(id, new b(handler, predicate, tooltip));
    }

    public static void a() {
        if (j.isEmpty()) {
            PlayerSelector.a("name", parser -> {
                int cursor = parser.g().getCursor();
                boolean shouldInvertValue = parser.e();
                String string = parser.g().readString();
                if (parser.w() && !shouldInvertValue) {
                    parser.g().setCursor(cursor);
                    throw b.createWithContext((ImmutableStringReader)parser.g(), (Object)"name");
                }
                if (shouldInvertValue) {
                    parser.c(true);
                } else {
                    parser.b(true);
                }
                parser.a(entity -> entity.ap().equals(string) != shouldInvertValue);
            }, parser -> !parser.v(), IChatBaseComponent.c("argument.entity.options.name.description"));
            PlayerSelector.a("distance", parser -> {
                int cursor = parser.g().getCursor();
                CriterionConditionValue.DoubleRange doubles = CriterionConditionValue.DoubleRange.a(parser.g());
                if (doubles.b().isPresent() && (Double)doubles.b().get() < 0.0 || doubles.c().isPresent() && (Double)doubles.c().get() < 0.0) {
                    parser.g().setCursor(cursor);
                    throw c.createWithContext((ImmutableStringReader)parser.g());
                }
                parser.a(doubles);
                parser.h();
            }, parser -> parser.i() == null, IChatBaseComponent.c("argument.entity.options.distance.description"));
            PlayerSelector.a("level", parser -> {
                int cursor = parser.g().getCursor();
                CriterionConditionValue.IntegerRange ints = CriterionConditionValue.IntegerRange.a(parser.g());
                if (ints.b().isPresent() && (Integer)ints.b().get() < 0 || ints.c().isPresent() && (Integer)ints.c().get() < 0) {
                    parser.g().setCursor(cursor);
                    throw d.createWithContext((ImmutableStringReader)parser.g());
                }
                parser.a(ints);
                parser.a(false);
            }, parser -> parser.j() == null, IChatBaseComponent.c("argument.entity.options.level.description"));
            PlayerSelector.a("x", parser -> {
                parser.h();
                parser.a(parser.g().readDouble());
            }, parser -> parser.m() == null, IChatBaseComponent.c("argument.entity.options.x.description"));
            PlayerSelector.a("y", parser -> {
                parser.h();
                parser.b(parser.g().readDouble());
            }, parser -> parser.n() == null, IChatBaseComponent.c("argument.entity.options.y.description"));
            PlayerSelector.a("z", parser -> {
                parser.h();
                parser.c(parser.g().readDouble());
            }, parser -> parser.o() == null, IChatBaseComponent.c("argument.entity.options.z.description"));
            PlayerSelector.a("dx", parser -> {
                parser.h();
                parser.d(parser.g().readDouble());
            }, parser -> parser.p() == null, IChatBaseComponent.c("argument.entity.options.dx.description"));
            PlayerSelector.a("dy", parser -> {
                parser.h();
                parser.e(parser.g().readDouble());
            }, parser -> parser.q() == null, IChatBaseComponent.c("argument.entity.options.dy.description"));
            PlayerSelector.a("dz", parser -> {
                parser.h();
                parser.f(parser.g().readDouble());
            }, parser -> parser.r() == null, IChatBaseComponent.c("argument.entity.options.dz.description"));
            PlayerSelector.a("x_rotation", parser -> parser.a(CriterionConditionValue.c.a(parser.g())), parser -> parser.k() == null, IChatBaseComponent.c("argument.entity.options.x_rotation.description"));
            PlayerSelector.a("y_rotation", parser -> parser.b(CriterionConditionValue.c.a(parser.g())), parser -> parser.l() == null, IChatBaseComponent.c("argument.entity.options.y_rotation.description"));
            PlayerSelector.a("limit", parser -> {
                int cursor = parser.g().getCursor();
                int _int = parser.g().readInt();
                if (_int < 1) {
                    parser.g().setCursor(cursor);
                    throw e.createWithContext((ImmutableStringReader)parser.g());
                }
                parser.a(_int);
                parser.d(true);
            }, parser -> !parser.u() && !parser.x(), IChatBaseComponent.c("argument.entity.options.limit.description"));
            PlayerSelector.a("sort", parser -> {
                int cursor = parser.g().getCursor();
                String unquotedString = parser.g().readUnquotedString();
                parser.a((builder, consumer) -> ICompletionProvider.b(Arrays.asList("nearest", "furthest", "random", "arbitrary"), builder));
                parser.a(switch (unquotedString) {
                    case "nearest" -> ArgumentParserSelector.k;
                    case "furthest" -> ArgumentParserSelector.l;
                    case "random" -> ArgumentParserSelector.m;
                    case "arbitrary" -> EntitySelector.b;
                    default -> {
                        parser.g().setCursor(cursor);
                        throw f.createWithContext((ImmutableStringReader)parser.g(), (Object)unquotedString);
                    }
                });
                parser.e(true);
            }, parser -> !parser.u() && !parser.y(), IChatBaseComponent.c("argument.entity.options.sort.description"));
            PlayerSelector.a("gamemode", parser -> {
                parser.a((builder, consumer) -> {
                    String string = builder.getRemaining().toLowerCase(Locale.ROOT);
                    boolean flag = !parser.A();
                    boolean flag1 = true;
                    if (!string.isEmpty()) {
                        if (string.charAt(0) == '!') {
                            flag = false;
                            string = string.substring(1);
                        } else {
                            flag1 = false;
                        }
                    }
                    for (EnumGamemode gameType1 : EnumGamemode.values()) {
                        if (!gameType1.b().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                        if (flag1) {
                            builder.suggest("!" + gameType1.b());
                        }
                        if (!flag) continue;
                        builder.suggest(gameType1.b());
                    }
                    return builder.buildFuture();
                });
                int cursor = parser.g().getCursor();
                boolean shouldInvertValue = parser.e();
                if (parser.A() && !shouldInvertValue) {
                    parser.g().setCursor(cursor);
                    throw b.createWithContext((ImmutableStringReader)parser.g(), (Object)"gamemode");
                }
                String unquotedString = parser.g().readUnquotedString();
                EnumGamemode gameType = EnumGamemode.a(unquotedString, null);
                if (gameType == null) {
                    parser.g().setCursor(cursor);
                    throw g.createWithContext((ImmutableStringReader)parser.g(), (Object)unquotedString);
                }
                parser.a(false);
                parser.a(entity -> {
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer serverPlayer = (EntityPlayer)entity;
                        EnumGamemode gameType1 = serverPlayer.a();
                        return gameType1 == gameType ^ shouldInvertValue;
                    }
                    return false;
                });
                if (shouldInvertValue) {
                    parser.g(true);
                } else {
                    parser.f(true);
                }
            }, parser -> !parser.z(), IChatBaseComponent.c("argument.entity.options.gamemode.description"));
            PlayerSelector.a("team", parser -> {
                boolean shouldInvertValue = parser.e();
                String unquotedString = parser.g().readUnquotedString();
                parser.a(entity -> {
                    ScoreboardTeam team = entity.cD();
                    String string = team == null ? "" : ((ScoreboardTeamBase)team).c();
                    return string.equals(unquotedString) != shouldInvertValue;
                });
                if (shouldInvertValue) {
                    parser.i(true);
                } else {
                    parser.h(true);
                }
            }, parser -> !parser.B(), IChatBaseComponent.c("argument.entity.options.team.description"));
            PlayerSelector.a("type", parser -> {
                parser.a((suggestionsBuilder, consumer) -> {
                    ICompletionProvider.a(BuiltInRegistries.g.i(), suggestionsBuilder, String.valueOf('!'));
                    ICompletionProvider.a(BuiltInRegistries.g.l().map(named -> named.h().b()), suggestionsBuilder, "!#");
                    if (!parser.F()) {
                        ICompletionProvider.a(BuiltInRegistries.g.i(), suggestionsBuilder);
                        ICompletionProvider.a(BuiltInRegistries.g.l().map(named -> named.h().b()), suggestionsBuilder, String.valueOf('#'));
                    }
                    return suggestionsBuilder.buildFuture();
                });
                int cursor = parser.g().getCursor();
                boolean shouldInvertValue = parser.e();
                if (parser.F() && !shouldInvertValue) {
                    parser.g().setCursor(cursor);
                    throw b.createWithContext((ImmutableStringReader)parser.g(), (Object)"type");
                }
                if (shouldInvertValue) {
                    parser.D();
                }
                if (parser.f()) {
                    TagKey<EntityTypes<?>> tagKey = TagKey.a(Registries.E, MinecraftKey.a(parser.g()));
                    parser.a(entity -> entity.ax().a(tagKey) != shouldInvertValue);
                } else {
                    MinecraftKey resourceLocation = MinecraftKey.a(parser.g());
                    EntityTypes entityType = (EntityTypes)BuiltInRegistries.g.b(resourceLocation).orElseThrow(() -> {
                        parser.g().setCursor(cursor);
                        return h.createWithContext((ImmutableStringReader)parser.g(), (Object)resourceLocation.toString());
                    });
                    if (Objects.equals(EntityTypes.bX, entityType) && !shouldInvertValue) {
                        parser.a(false);
                    }
                    parser.a(entity -> Objects.equals(entityType, entity.ax()) != shouldInvertValue);
                    if (!shouldInvertValue) {
                        parser.a(entityType);
                    }
                }
            }, entitySelectorParser -> !entitySelectorParser.E(), IChatBaseComponent.c("argument.entity.options.type.description"));
            PlayerSelector.a("tag", parser -> {
                boolean shouldInvertValue = parser.e();
                String unquotedString = parser.g().readUnquotedString();
                parser.a(entity -> "".equals(unquotedString) ? entity.aA().isEmpty() != shouldInvertValue : entity.aA().contains(unquotedString) != shouldInvertValue);
            }, entitySelectorParser -> true, IChatBaseComponent.c("argument.entity.options.tag.description"));
            PlayerSelector.a("nbt", parser -> {
                boolean shouldInvertValue = parser.e();
                NBTTagCompound compoundTag = MojangsonParser.c(parser.g());
                parser.a(entity -> {
                    boolean var9;
                    try (ProblemReporter.j scopedCollector = new ProblemReporter.j(entity.en(), i);){
                        EntityPlayer serverPlayer;
                        ItemStack selectedItem;
                        TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, entity.ej());
                        entity.d(tagValueOutput);
                        if (entity instanceof EntityPlayer && !(selectedItem = (serverPlayer = (EntityPlayer)entity).gB().h()).f()) {
                            tagValueOutput.a("SelectedItem", ItemStack.b, selectedItem);
                        }
                        var9 = GameProfileSerializer.a((NBTBase)compoundTag, tagValueOutput.b(), true) != shouldInvertValue;
                    }
                    return var9;
                });
            }, entitySelectorParser -> true, IChatBaseComponent.c("argument.entity.options.nbt.description"));
            PlayerSelector.a("scores", parser -> {
                StringReader reader = parser.g();
                HashMap map = Maps.newHashMap();
                reader.expect('{');
                reader.skipWhitespace();
                while (reader.canRead() && reader.peek() != '}') {
                    reader.skipWhitespace();
                    String unquotedString = reader.readUnquotedString();
                    reader.skipWhitespace();
                    reader.expect('=');
                    reader.skipWhitespace();
                    CriterionConditionValue.IntegerRange ints = CriterionConditionValue.IntegerRange.a(reader);
                    map.put(unquotedString, ints);
                    reader.skipWhitespace();
                    if (!reader.canRead() || reader.peek() != ',') continue;
                    reader.skip();
                }
                reader.expect('}');
                if (!map.isEmpty()) {
                    parser.a(entity -> {
                        ScoreboardServer scoreboard = entity.an().q().aO();
                        for (Map.Entry entry : map.entrySet()) {
                            ScoreboardObjective objective = scoreboard.a((String)entry.getKey());
                            if (objective == null) {
                                return false;
                            }
                            ReadOnlyScoreInfo playerScoreInfo = scoreboard.d((ScoreHolder)entity, objective);
                            if (playerScoreInfo == null) {
                                return false;
                            }
                            if (((CriterionConditionValue.IntegerRange)entry.getValue()).d(playerScoreInfo.a())) continue;
                            return false;
                        }
                        return true;
                    });
                }
                parser.j(true);
            }, entitySelectorParser -> !entitySelectorParser.G(), IChatBaseComponent.c("argument.entity.options.scores.description"));
            PlayerSelector.a("advancements", parser -> {
                StringReader reader = parser.g();
                HashMap map = Maps.newHashMap();
                reader.expect('{');
                reader.skipWhitespace();
                while (reader.canRead() && reader.peek() != '}') {
                    reader.skipWhitespace();
                    MinecraftKey resourceLocation = MinecraftKey.a(reader);
                    reader.skipWhitespace();
                    reader.expect('=');
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() == '{') {
                        HashMap map1 = Maps.newHashMap();
                        reader.skipWhitespace();
                        reader.expect('{');
                        reader.skipWhitespace();
                        while (reader.canRead() && reader.peek() != '}') {
                            reader.skipWhitespace();
                            String unquotedString = reader.readUnquotedString();
                            reader.skipWhitespace();
                            reader.expect('=');
                            reader.skipWhitespace();
                            boolean _boolean = reader.readBoolean();
                            map1.put(unquotedString, criterionProgress -> criterionProgress.a() == _boolean);
                            reader.skipWhitespace();
                            if (!reader.canRead() || reader.peek() != ',') continue;
                            reader.skip();
                        }
                        reader.skipWhitespace();
                        reader.expect('}');
                        reader.skipWhitespace();
                        map.put(resourceLocation, advancementProgress -> {
                            for (Map.Entry entry : map1.entrySet()) {
                                CriterionProgress criterion = advancementProgress.c((String)entry.getKey());
                                if (criterion != null && ((Predicate)entry.getValue()).test(criterion)) continue;
                                return false;
                            }
                            return true;
                        });
                    } else {
                        boolean _boolean1 = reader.readBoolean();
                        map.put(resourceLocation, advancementProgress -> advancementProgress.a() == _boolean1);
                    }
                    reader.skipWhitespace();
                    if (!reader.canRead() || reader.peek() != ',') continue;
                    reader.skip();
                }
                reader.expect('}');
                if (!map.isEmpty()) {
                    parser.a(entity -> {
                        if (!(entity instanceof EntityPlayer)) {
                            return false;
                        }
                        EntityPlayer serverPlayer = (EntityPlayer)entity;
                        AdvancementDataPlayer advancements = serverPlayer.U();
                        AdvancementDataWorld advancements1 = serverPlayer.A().q().aF();
                        for (Map.Entry entry : map.entrySet()) {
                            AdvancementHolder advancementHolder = advancements1.a((MinecraftKey)entry.getKey());
                            if (advancementHolder != null && ((Predicate)entry.getValue()).test(advancements.b(advancementHolder))) continue;
                            return false;
                        }
                        return true;
                    });
                    parser.a(false);
                }
                parser.k(true);
            }, entitySelectorParser -> !entitySelectorParser.H(), IChatBaseComponent.c("argument.entity.options.advancements.description"));
            PlayerSelector.a("predicate", parser -> {
                boolean shouldInvertValue = parser.e();
                ResourceKey<LootItemCondition> resourceKey = ResourceKey.a(Registries.bB, MinecraftKey.a(parser.g()));
                parser.a(entity -> {
                    World patt0$temp = entity.an();
                    if (patt0$temp instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)patt0$temp;
                        Optional<LootItemCondition> optional = serverLevel.q().bi().a().c(resourceKey).map(Holder::a);
                        if (optional.isEmpty()) {
                            return false;
                        }
                        LootParams lootParams = new LootParams.a(serverLevel).a(LootContextParameters.a, entity).a(LootContextParameters.h, entity.dD()).a(LootContextParameterSets.e);
                        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(Optional.empty());
                        lootContext.b(LootTableInfo.a(optional.get()));
                        return shouldInvertValue ^ optional.get().test(lootContext);
                    }
                    return false;
                });
            }, entitySelectorParser -> true, IChatBaseComponent.c("argument.entity.options.predicate.description"));
        }
    }

    public static a a(ArgumentParserSelector parser, String id, int cursor) throws CommandSyntaxException {
        b option = j.get(id);
        if (option != null) {
            if (option.b.test(parser)) {
                return option.a;
            }
            throw b.createWithContext((ImmutableStringReader)parser.g(), (Object)id);
        }
        parser.g().setCursor(cursor);
        throw a.createWithContext((ImmutableStringReader)parser.g(), (Object)id);
    }

    public static void a(ArgumentParserSelector parser, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, b> entry : j.entrySet()) {
            if (!entry.getValue().b.test(parser) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            builder.suggest(entry.getKey() + "=", (Message)entry.getValue().c);
        }
    }

    record b(a a, Predicate<ArgumentParserSelector> b, IChatBaseComponent c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface a {
        public void handle(ArgumentParserSelector var1) throws CommandSyntaxException;
    }
}

