/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution;

import com.google.common.collect.Queues;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public class ExecutionContext<T>
implements AutoCloseable {
    private static final int a = 10000000;
    private static final Logger b = LogUtils.getLogger();
    private final int c;
    private final int d;
    private final GameProfilerFiller e;
    @Nullable
    private TraceCallbacks f;
    private int g;
    private boolean h;
    private final Deque<CommandQueueEntry<T>> i = Queues.newArrayDeque();
    private final List<CommandQueueEntry<T>> j = new ObjectArrayList();
    private int k;

    public ExecutionContext(int commandQuota, int forkLimit, GameProfilerFiller profiler) {
        this.c = commandQuota;
        this.d = forkLimit;
        this.e = profiler;
        this.g = commandQuota;
    }

    private static <T extends ExecutionCommandSource<T>> Frame a(ExecutionContext<T> executionContext, CommandResultCallback returnValueConsumer) {
        if (executionContext.k == 0) {
            return new Frame(0, returnValueConsumer, executionContext.i::clear);
        }
        int i2 = executionContext.k + 1;
        return new Frame(i2, returnValueConsumer, executionContext.b(i2));
    }

    public static <T extends ExecutionCommandSource<T>> void a(ExecutionContext<T> executionContext, InstantiatedFunction<T> function, T source, CommandResultCallback returnValueConsumer) {
        executionContext.a(new CommandQueueEntry<T>(ExecutionContext.a(executionContext, returnValueConsumer), new CallFunction<T>(function, source.p(), false).bind(source)));
    }

    public static <T extends ExecutionCommandSource<T>> void a(ExecutionContext<T> executionContext, String commandInput, ContextChain<T> command, T source, CommandResultCallback returnValueConsumer) {
        executionContext.a(new CommandQueueEntry<T>(ExecutionContext.a(executionContext, returnValueConsumer), new BuildContexts.b<T>(commandInput, command, source)));
    }

    private void f() {
        this.h = true;
        this.j.clear();
        this.i.clear();
    }

    public void a(CommandQueueEntry<T> entry) {
        if (this.j.size() + this.i.size() > 10000000) {
            this.f();
        }
        if (!this.h) {
            this.j.add(entry);
        }
    }

    public void a(int depth) {
        while (!this.i.isEmpty() && this.i.peek().a().c() >= depth) {
            this.i.removeFirst();
        }
    }

    public Frame.a b(int depth) {
        return () -> this.a(depth);
    }

    public void a() {
        this.g();
        while (true) {
            if (this.g <= 0) {
                b.info("Command execution stopped due to limit (executed {} commands)", (Object)this.c);
                break;
            }
            CommandQueueEntry<T> commandQueueEntry = this.i.pollFirst();
            if (commandQueueEntry == null) {
                return;
            }
            this.k = commandQueueEntry.a().c();
            commandQueueEntry.a(this);
            if (this.h) {
                b.error("Command execution stopped due to command queue overflow (max {})", (Object)10000000);
                break;
            }
            this.g();
        }
        this.k = 0;
    }

    private void g() {
        for (int i2 = this.j.size() - 1; i2 >= 0; --i2) {
            this.i.addFirst(this.j.get(i2));
        }
        this.j.clear();
    }

    public void a(@Nullable TraceCallbacks tracer) {
        this.f = tracer;
    }

    @Nullable
    public TraceCallbacks b() {
        return this.f;
    }

    public GameProfilerFiller c() {
        return this.e;
    }

    public int d() {
        return this.d;
    }

    public void e() {
        --this.g;
    }

    @Override
    public void close() {
        if (this.f != null) {
            this.f.close();
        }
    }
}

