/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Immutable
public class BlockPosition
extends BaseBlockPosition {
    public static final Codec<BlockPosition> a = Codec.INT_STREAM.comapFlatMap(positions -> SystemUtils.a(positions, 3).map(positions1 -> new BlockPosition(positions1[0], positions1[1], positions1[2])), pos -> IntStream.of(pos.u(), pos.v(), pos.w())).stable();
    public static final StreamCodec<ByteBuf, BlockPosition> b = new StreamCodec<ByteBuf, BlockPosition>(){

        public BlockPosition a(ByteBuf buffer) {
            return PacketDataSerializer.c(buffer);
        }

        public void a(ByteBuf buffer, BlockPosition value) {
            PacketDataSerializer.a(buffer, value);
        }
    };
    private static final Logger j = LogUtils.getLogger();
    public static final BlockPosition c = new BlockPosition(0, 0, 0);
    public static final int d = 26;
    public static final int e = 12;
    private static final long k = 0x3FFFFFFL;
    private static final long l = 4095L;
    private static final long m = 0x3FFFFFFL;
    private static final int n = 0;
    private static final int o = 12;
    private static final int p = 38;
    public static final int f = 0x1FFFFFF;

    public BlockPosition(Entity entity) {
        super(entity.dJ(), entity.dL(), entity.dP());
    }

    public BlockPosition(int x2, int y2, int z2) {
        super(x2, y2, z2);
    }

    public BlockPosition(BaseBlockPosition vector) {
        this(vector.u(), vector.v(), vector.w());
    }

    public static long getAdjacent(int baseX, int baseY, int baseZ, EnumDirection direction) {
        return BlockPosition.a(baseX + direction.j(), baseY + direction.k(), baseZ + direction.l());
    }

    public static long a(long pos, EnumDirection direction) {
        return BlockPosition.a(pos, direction.j(), direction.k(), direction.l());
    }

    public static long a(long pos, int dx, int dy, int dz) {
        return BlockPosition.a((int)(pos >> 38) + dx, (int)(pos << 52 >> 52) + dy, (int)(pos << 26 >> 38) + dz);
    }

    public static int a(long packedPos) {
        return (int)(packedPos >> 38);
    }

    public static int b(long packedPos) {
        return (int)(packedPos << 52 >> 52);
    }

    public static int c(long packedPos) {
        return (int)(packedPos << 26 >> 38);
    }

    public static BlockPosition d(long packedPos) {
        return new BlockPosition((int)(packedPos >> 38), (int)(packedPos << 52 >> 52), (int)(packedPos << 26 >> 38));
    }

    public static BlockPosition a(double x2, double y2, double z2) {
        return new BlockPosition(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
    }

    public static BlockPosition a(IPosition position) {
        return BlockPosition.a(position.a(), position.b(), position.c());
    }

    public static BlockPosition a(BlockPosition pos1, BlockPosition pos2) {
        return new BlockPosition(Math.min(pos1.u(), pos2.u()), Math.min(pos1.v(), pos2.v()), Math.min(pos1.w(), pos2.w()));
    }

    public static BlockPosition b(BlockPosition pos1, BlockPosition pos2) {
        return new BlockPosition(Math.max(pos1.u(), pos2.u()), Math.max(pos1.v(), pos2.v()), Math.max(pos1.w(), pos2.w()));
    }

    public long a() {
        return BlockPosition.a(this.u(), this.v(), this.w());
    }

    public static long a(int x2, int y2, int z2) {
        return ((long)x2 & 0x3FFFFFFL) << 38 | (long)y2 & 0xFFFL | ((long)z2 & 0x3FFFFFFL) << 12;
    }

    public static long e(long packedPos) {
        return packedPos & 0xFFFFFFFFFFFFFFF0L;
    }

    public BlockPosition b(int dx, int dy, int dz) {
        return dx == 0 && dy == 0 && dz == 0 ? this : new BlockPosition(this.u() + dx, this.v() + dy, this.w() + dz);
    }

    public Vec3D b() {
        return Vec3D.b(this);
    }

    public Vec3D c() {
        return Vec3D.c(this);
    }

    public BlockPosition a(BaseBlockPosition vector) {
        return this.b(vector.u(), vector.v(), vector.w());
    }

    public BlockPosition b(BaseBlockPosition vector) {
        return this.b(-vector.u(), -vector.v(), -vector.w());
    }

    public BlockPosition a(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return scalar == 0 ? c : new BlockPosition(this.u() * scalar, this.v() * scalar, this.w() * scalar);
    }

    public BlockPosition d() {
        return new BlockPosition(this.u(), this.v() + 1, this.w());
    }

    public BlockPosition b(int distance) {
        return distance == 0 ? this.j() : new BlockPosition(this.u(), this.v() + distance, this.w());
    }

    public BlockPosition e() {
        return new BlockPosition(this.u(), this.v() - 1, this.w());
    }

    public BlockPosition c(int distance) {
        return distance == 0 ? this.j() : new BlockPosition(this.u(), this.v() - distance, this.w());
    }

    public BlockPosition f() {
        return new BlockPosition(this.u(), this.v(), this.w() - 1);
    }

    public BlockPosition d(int distance) {
        return distance == 0 ? this.j() : new BlockPosition(this.u(), this.v(), this.w() - distance);
    }

    public BlockPosition g() {
        return new BlockPosition(this.u(), this.v(), this.w() + 1);
    }

    public BlockPosition e(int distance) {
        return distance == 0 ? this.j() : new BlockPosition(this.u(), this.v(), this.w() + distance);
    }

    public BlockPosition h() {
        return new BlockPosition(this.u() - 1, this.v(), this.w());
    }

    public BlockPosition f(int distance) {
        return distance == 0 ? this.j() : new BlockPosition(this.u() - distance, this.v(), this.w());
    }

    public BlockPosition i() {
        return new BlockPosition(this.u() + 1, this.v(), this.w());
    }

    public BlockPosition g(int distance) {
        return distance == 0 ? this.j() : new BlockPosition(this.u() + distance, this.v(), this.w());
    }

    public BlockPosition a(EnumDirection direction) {
        switch (direction) {
            case b: {
                return new BlockPosition(this.u(), this.v() + 1, this.w());
            }
            case a: {
                return new BlockPosition(this.u(), this.v() - 1, this.w());
            }
            case c: {
                return new BlockPosition(this.u(), this.v(), this.w() - 1);
            }
            case d: {
                return new BlockPosition(this.u(), this.v(), this.w() + 1);
            }
            case e: {
                return new BlockPosition(this.u() - 1, this.v(), this.w());
            }
            case f: {
                return new BlockPosition(this.u() + 1, this.v(), this.w());
            }
        }
        return new BlockPosition(this.u() + direction.j(), this.v() + direction.k(), this.w() + direction.l());
    }

    public BlockPosition a(EnumDirection direction, int distance) {
        return distance == 0 ? this : new BlockPosition(this.u() + direction.j() * distance, this.v() + direction.k() * distance, this.w() + direction.l() * distance);
    }

    public BlockPosition a(EnumDirection.EnumAxis axis, int amount) {
        if (amount == 0) {
            return this;
        }
        int i2 = axis == EnumDirection.EnumAxis.a ? amount : 0;
        int i1 = axis == EnumDirection.EnumAxis.b ? amount : 0;
        int i22 = axis == EnumDirection.EnumAxis.c ? amount : 0;
        return new BlockPosition(this.u() + i2, this.v() + i1, this.w() + i22);
    }

    public BlockPosition a(EnumBlockRotation rotation) {
        switch (rotation) {
            default: {
                return this;
            }
            case b: {
                return new BlockPosition(-this.w(), this.v(), this.u());
            }
            case c: {
                return new BlockPosition(-this.u(), this.v(), -this.w());
            }
            case d: 
        }
        return new BlockPosition(this.w(), this.v(), -this.u());
    }

    public BlockPosition c(BaseBlockPosition vector) {
        return new BlockPosition(this.v() * vector.w() - this.w() * vector.v(), this.w() * vector.u() - this.u() * vector.w(), this.u() * vector.v() - this.v() * vector.u());
    }

    public BlockPosition h(int y2) {
        return new BlockPosition(this.u(), y2, this.w());
    }

    public BlockPosition j() {
        return this;
    }

    public MutableBlockPosition k() {
        return new MutableBlockPosition(this.u(), this.v(), this.w());
    }

    public Vec3D a(Vec3D pos) {
        return new Vec3D(MathHelper.a(pos.g, (double)((float)this.u() + 1.0E-5f), (double)this.u() + 1.0 - (double)1.0E-5f), MathHelper.a(pos.h, (double)((float)this.v() + 1.0E-5f), (double)this.v() + 1.0 - (double)1.0E-5f), MathHelper.a(pos.i, (double)((float)this.w() + 1.0E-5f), (double)this.w() + 1.0 - (double)1.0E-5f));
    }

    public static Iterable<BlockPosition> a(RandomSource random, int amount, BlockPosition center, int radius) {
        return BlockPosition.a(random, amount, center.u() - radius, center.v() - radius, center.w() - radius, center.u() + radius, center.v() + radius, center.w() + radius);
    }

    @Deprecated
    public static Stream<BlockPosition> a(BlockPosition pos) {
        return Stream.of(pos, pos.g(), pos.i(), pos.g().i());
    }

    public static Iterable<BlockPosition> a(final RandomSource random, final int amount, final int minX, final int minY, final int minZ, int maxX, int maxY, int maxZ) {
        final int i2 = maxX - minX + 1;
        final int i1 = maxY - minY + 1;
        final int i22 = maxZ - minZ + 1;
        return () -> new AbstractIterator<BlockPosition>(){
            final MutableBlockPosition a = new MutableBlockPosition();
            int b = amount;

            protected BlockPosition a() {
                if (this.b <= 0) {
                    return (BlockPosition)this.endOfData();
                }
                MutableBlockPosition blockPos = this.a.d(minX + random.a(i2), minY + random.a(i1), minZ + random.a(i22));
                --this.b;
                return blockPos;
            }
        };
    }

    public static Iterable<BlockPosition> a(BlockPosition pos, final int xSize, final int ySize, final int zSize) {
        final int i2 = xSize + ySize + zSize;
        final int x1 = pos.u();
        final int y1 = pos.v();
        final int z2 = pos.w();
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition h = new MutableBlockPosition();
            private int i;
            private int j;
            private int k;
            private int l;
            private int m;
            private boolean n;

            protected BlockPosition a() {
                if (this.n) {
                    this.n = false;
                    this.h.r(z2 - (this.h.w() - z2));
                    return this.h;
                }
                MutableBlockPosition blockPos = null;
                while (blockPos == null) {
                    if (this.m > this.k) {
                        ++this.l;
                        if (this.l > this.j) {
                            ++this.i;
                            if (this.i > i2) {
                                return (BlockPosition)this.endOfData();
                            }
                            this.j = Math.min(xSize, this.i);
                            this.l = -this.j;
                        }
                        this.k = Math.min(ySize, this.i - Math.abs(this.l));
                        this.m = -this.k;
                    }
                    int i1 = this.l;
                    int i22 = this.m;
                    int i3 = this.i - Math.abs(i1) - Math.abs(i22);
                    if (i3 <= zSize) {
                        this.n = i3 != 0;
                        blockPos = this.h.d(x1 + i1, y1 + i22, z2 + i3);
                    }
                    ++this.m;
                }
                return blockPos;
            }
        };
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int width, int height, Predicate<BlockPosition> posFilter) {
        for (BlockPosition blockPos : BlockPosition.a(pos, width, height, width)) {
            if (!posFilter.test(blockPos)) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    public static Stream<BlockPosition> b(BlockPosition pos, int xSize, int ySize, int zSize) {
        return StreamSupport.stream(BlockPosition.a(pos, xSize, ySize, zSize).spliterator(), false);
    }

    public static Iterable<BlockPosition> a(AxisAlignedBB box) {
        BlockPosition blockPos = BlockPosition.a(box.a, box.b, box.c);
        BlockPosition blockPos1 = BlockPosition.a(box.d, box.e, box.f);
        return BlockPosition.c(blockPos, blockPos1);
    }

    public static Iterable<BlockPosition> c(BlockPosition pos1, BlockPosition pos2) {
        return BlockPosition.b(Math.min(pos1.u(), pos2.u()), Math.min(pos1.v(), pos2.v()), Math.min(pos1.w(), pos2.w()), Math.max(pos1.u(), pos2.u()), Math.max(pos1.v(), pos2.v()), Math.max(pos1.w(), pos2.w()));
    }

    public static Stream<BlockPosition> d(BlockPosition pos1, BlockPosition pos2) {
        return StreamSupport.stream(BlockPosition.c(pos1, pos2).spliterator(), false);
    }

    public static Stream<BlockPosition> a(StructureBoundingBox box) {
        return BlockPosition.a(Math.min(box.h(), box.k()), Math.min(box.i(), box.l()), Math.min(box.j(), box.m()), Math.max(box.h(), box.k()), Math.max(box.i(), box.l()), Math.max(box.j(), box.m()));
    }

    public static Stream<BlockPosition> b(AxisAlignedBB aabb) {
        return BlockPosition.a(MathHelper.a(aabb.a), MathHelper.a(aabb.b), MathHelper.a(aabb.c), MathHelper.a(aabb.d), MathHelper.a(aabb.e), MathHelper.a(aabb.f));
    }

    public static Stream<BlockPosition> a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return StreamSupport.stream(BlockPosition.b(minX, minY, minZ, maxX, maxY, maxZ).spliterator(), false);
    }

    public static Iterable<BlockPosition> b(final int minX, final int minY, final int minZ, int maxX, int maxY, int maxZ) {
        final int i2 = maxX - minX + 1;
        final int i1 = maxY - minY + 1;
        int i22 = maxZ - minZ + 1;
        final int i3 = i2 * i1 * i22;
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition g = new MutableBlockPosition();
            private int h;

            protected BlockPosition a() {
                if (this.h == i3) {
                    return (BlockPosition)this.endOfData();
                }
                int i4 = this.h % i2;
                int i5 = this.h / i2;
                int i6 = i5 % i1;
                int i7 = i5 / i1;
                ++this.h;
                return this.g.d(minX + i4, minY + i6, minZ + i7);
            }
        };
    }

    public static Iterable<MutableBlockPosition> a(final BlockPosition center, final int size, final EnumDirection rotationDirection, final EnumDirection expansionDirection) {
        Validate.validState((rotationDirection.o() != expansionDirection.o() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPosition>(){
            private final EnumDirection[] e;
            private final MutableBlockPosition f;
            private final int g;
            private int h;
            private int i;
            private int j;
            private int k;
            private int l;
            private int m;
            {
                this.e = new EnumDirection[]{rotationDirection, expansionDirection, rotationDirection.g(), expansionDirection.g()};
                this.f = center.k().c(expansionDirection);
                this.g = 4 * size;
                this.h = -1;
                this.k = this.f.u();
                this.l = this.f.v();
                this.m = this.f.w();
            }

            protected MutableBlockPosition a() {
                this.f.d(this.k, this.l, this.m).c(this.e[(this.h + 4) % 4]);
                this.k = this.f.u();
                this.l = this.f.v();
                this.m = this.f.w();
                if (this.j >= this.i) {
                    if (this.h >= this.g) {
                        return (MutableBlockPosition)this.endOfData();
                    }
                    ++this.h;
                    this.j = 0;
                    this.i = this.h / 2 + 1;
                }
                ++this.j;
                return this.f;
            }
        };
    }

    public static int a(BlockPosition startPos, int radius, int maxBlocks, BiConsumer<BlockPosition, Consumer<BlockPosition>> childrenGetter, Function<BlockPosition, b> action) {
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        LongOpenHashSet set = new LongOpenHashSet();
        queue.add(Pair.of((Object)startPos, (Object)0));
        int i2 = 0;
        while (!queue.isEmpty()) {
            b traversalNodeStatus;
            Pair pair = (Pair)queue.poll();
            BlockPosition blockPos = (BlockPosition)pair.getLeft();
            int right = (Integer)pair.getRight();
            long packedBlockPos = blockPos.a();
            if (!set.add(packedBlockPos) || (traversalNodeStatus = action.apply(blockPos)) == net.minecraft.core.BlockPosition$b.b) continue;
            if (traversalNodeStatus == net.minecraft.core.BlockPosition$b.c) break;
            if (++i2 >= maxBlocks) {
                return i2;
            }
            if (right >= radius) continue;
            childrenGetter.accept(blockPos, pos -> queue.add(Pair.of((Object)pos, (Object)(right + 1))));
        }
        return i2;
    }

    public static Iterable<BlockPosition> a(AxisAlignedBB aabb, Vec3D direction) {
        Vec3D minPosition = aabb.h();
        int floor = MathHelper.a(minPosition.a());
        int floor1 = MathHelper.a(minPosition.b());
        int floor2 = MathHelper.a(minPosition.c());
        Vec3D maxPosition = aabb.i();
        int floor3 = MathHelper.a(maxPosition.a());
        int floor4 = MathHelper.a(maxPosition.b());
        int floor5 = MathHelper.a(maxPosition.c());
        return BlockPosition.a(floor, floor1, floor2, floor3, floor4, floor5, direction);
    }

    public static Iterable<BlockPosition> a(BlockPosition pos1, BlockPosition pos2, Vec3D direction) {
        return BlockPosition.a(pos1.u(), pos1.v(), pos1.w(), pos2.u(), pos2.v(), pos2.w(), direction);
    }

    public static Iterable<BlockPosition> a(int x1, int y1, int z1, int x2, int y2, int z2, Vec3D direction) {
        int min = Math.min(x1, x2);
        int min1 = Math.min(y1, y2);
        int min2 = Math.min(z1, z2);
        int max = Math.max(x1, x2);
        int max1 = Math.max(y1, y2);
        int max2 = Math.max(z1, z2);
        int i2 = max - min;
        int i1 = max1 - min1;
        int i22 = max2 - min2;
        final int i3 = direction.g >= 0.0 ? min : max;
        final int i4 = direction.h >= 0.0 ? min1 : max1;
        final int i5 = direction.i >= 0.0 ? min2 : max2;
        ImmutableList<EnumDirection.EnumAxis> list = EnumDirection.b(direction);
        EnumDirection.EnumAxis axis = (EnumDirection.EnumAxis)list.get(0);
        EnumDirection.EnumAxis axis1 = (EnumDirection.EnumAxis)list.get(1);
        EnumDirection.EnumAxis axis2 = (EnumDirection.EnumAxis)list.get(2);
        final EnumDirection direction1 = direction.a(axis) >= 0.0 ? axis.e() : axis.f();
        final EnumDirection direction2 = direction.a(axis1) >= 0.0 ? axis1.e() : axis1.f();
        final EnumDirection direction3 = direction.a(axis2) >= 0.0 ? axis2.e() : axis2.f();
        final int i6 = axis.a(i2, i1, i22);
        final int i7 = axis1.a(i2, i1, i22);
        final int i8 = axis2.a(i2, i1, i22);
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition j = new MutableBlockPosition();
            private int k;
            private int l;
            private int m;
            private boolean n;
            private final int o = direction1.j();
            private final int p = direction1.k();
            private final int q = direction1.l();
            private final int r = direction2.j();
            private final int s = direction2.k();
            private final int t = direction2.l();
            private final int u = direction3.j();
            private final int v = direction3.k();
            private final int w = direction3.l();

            protected BlockPosition a() {
                if (this.n) {
                    return (BlockPosition)this.endOfData();
                }
                this.j.d(i3 + this.o * this.k + this.r * this.l + this.u * this.m, i4 + this.p * this.k + this.s * this.l + this.v * this.m, i5 + this.q * this.k + this.t * this.l + this.w * this.m);
                if (this.m < i8) {
                    ++this.m;
                } else if (this.l < i7) {
                    ++this.l;
                    this.m = 0;
                } else if (this.k < i6) {
                    ++this.k;
                    this.m = 0;
                    this.l = 0;
                } else {
                    this.n = true;
                }
                return this.j;
            }
        };
    }

    public static class MutableBlockPosition
    extends BlockPosition {
        public MutableBlockPosition() {
            this(0, 0, 0);
        }

        public MutableBlockPosition(int x2, int y2, int z2) {
            super(x2, y2, z2);
        }

        public MutableBlockPosition(double x2, double y2, double z2) {
            this(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        }

        @Override
        public BlockPosition b(int dx, int dy, int dz) {
            return super.b(dx, dy, dz).j();
        }

        @Override
        public BlockPosition a(int scalar) {
            return super.a(scalar).j();
        }

        @Override
        public BlockPosition a(EnumDirection direction, int distance) {
            return super.a(direction, distance).j();
        }

        @Override
        public BlockPosition a(EnumDirection.EnumAxis axis, int amount) {
            return super.a(axis, amount).j();
        }

        @Override
        public BlockPosition a(EnumBlockRotation rotation) {
            return super.a(rotation).j();
        }

        public MutableBlockPosition d(int x2, int y2, int z2) {
            ((BaseBlockPosition)this).a = x2;
            ((BaseBlockPosition)this).b = y2;
            ((BaseBlockPosition)this).c = z2;
            return this;
        }

        public MutableBlockPosition b(double x2, double y2, double z2) {
            return this.d(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        }

        public MutableBlockPosition g(BaseBlockPosition pos) {
            return this.d(pos.u(), pos.v(), pos.w());
        }

        public MutableBlockPosition f(long packedPos) {
            return this.d(MutableBlockPosition.a(packedPos), MutableBlockPosition.b(packedPos), MutableBlockPosition.c(packedPos));
        }

        public MutableBlockPosition a(EnumAxisCycle cycle, int x2, int y2, int z2) {
            return this.d(cycle.a(x2, y2, z2, EnumDirection.EnumAxis.a), cycle.a(x2, y2, z2, EnumDirection.EnumAxis.b), cycle.a(x2, y2, z2, EnumDirection.EnumAxis.c));
        }

        public MutableBlockPosition a(BaseBlockPosition pos, EnumDirection direction) {
            return this.d(pos.u() + direction.j(), pos.v() + direction.k(), pos.w() + direction.l());
        }

        public MutableBlockPosition a(BaseBlockPosition pos, int offsetX, int offsetY, int offsetZ) {
            return this.d(pos.u() + offsetX, pos.v() + offsetY, pos.w() + offsetZ);
        }

        public MutableBlockPosition a(BaseBlockPosition pos, BaseBlockPosition offset) {
            return this.d(pos.u() + offset.u(), pos.v() + offset.v(), pos.w() + offset.w());
        }

        public MutableBlockPosition c(EnumDirection direction) {
            return this.c(direction, 1);
        }

        public MutableBlockPosition c(EnumDirection direction, int n2) {
            return this.d(this.u() + direction.j() * n2, this.v() + direction.k() * n2, this.w() + direction.l() * n2);
        }

        public MutableBlockPosition e(int x2, int y2, int z2) {
            return this.d(this.u() + x2, this.v() + y2, this.w() + z2);
        }

        public MutableBlockPosition h(BaseBlockPosition offset) {
            return this.d(this.u() + offset.u(), this.v() + offset.v(), this.w() + offset.w());
        }

        public MutableBlockPosition a(EnumDirection.EnumAxis axis, int min, int max) {
            switch (axis) {
                case a: {
                    return this.d(MathHelper.a(this.u(), min, max), this.v(), this.w());
                }
                case b: {
                    return this.d(this.u(), MathHelper.a(this.v(), min, max), this.w());
                }
                case c: {
                    return this.d(this.u(), this.v(), MathHelper.a(this.w(), min, max));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + String.valueOf(axis));
        }

        public MutableBlockPosition p(int x2) {
            ((BaseBlockPosition)this).a = x2;
            return this;
        }

        public MutableBlockPosition q(int y2) {
            ((BaseBlockPosition)this).b = y2;
            return this;
        }

        public MutableBlockPosition r(int z2) {
            ((BaseBlockPosition)this).c = z2;
            return this;
        }

        @Override
        public BlockPosition j() {
            return new BlockPosition(this);
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c};
        }

        static {
            d = net.minecraft.core.BlockPosition$b.a();
        }
    }
}

