/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NonNullList<E>
extends AbstractList<E> {
    private final List<E> a;
    @Nullable
    private final E b;

    public static <E> NonNullList<E> a() {
        return new NonNullList<Object>(Lists.newArrayList(), null);
    }

    public static <E> NonNullList<E> a(int initialCapacity) {
        return new NonNullList<Object>(Lists.newArrayListWithCapacity((int)initialCapacity), null);
    }

    public static <E> NonNullList<E> a(int size, E defaultValue) {
        Objects.requireNonNull(defaultValue);
        Object[] objects = new Object[size];
        Arrays.fill(objects, defaultValue);
        return new NonNullList<Object>(Arrays.asList(objects), defaultValue);
    }

    @SafeVarargs
    public static <E> NonNullList<E> a(E defaultValue, E ... elements) {
        return new NonNullList<E>(Arrays.asList(elements), defaultValue);
    }

    protected NonNullList(List<E> list, @Nullable E defaultValue) {
        this.a = list;
        this.b = defaultValue;
    }

    @Override
    @Nonnull
    public E get(int index) {
        return this.a.get(index);
    }

    @Override
    public E set(int index, E value) {
        Objects.requireNonNull(value);
        return this.a.set(index, value);
    }

    @Override
    public void add(int index, E value) {
        Objects.requireNonNull(value);
        this.a.add(index, value);
    }

    @Override
    public E remove(int index) {
        return this.a.remove(index);
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public void clear() {
        if (this.b == null) {
            super.clear();
        } else {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                this.set(i2, this.b);
            }
        }
    }
}

