/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<k<?>> a = new ArrayList();

    static <T> HolderGetter<T> a(final HolderLookup.b<T> lookup) {
        return new c<T>(lookup){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> resourceKey) {
                return lookup.a(resourceKey);
            }
        };
    }

    static <T> HolderLookup.b<T> a(final ResourceKey<? extends IRegistry<? extends T>> registryKey, final Lifecycle registryLifecycle, HolderOwner<T> owner, final Map<ResourceKey<T>, Holder.c<T>> elements) {
        return new e<T>(owner){

            @Override
            public Optional<T> getValueForCopying(ResourceKey<T> resourceKey) {
                return this.a(resourceKey).map(Holder.c::a);
            }

            @Override
            public ResourceKey<? extends IRegistry<? extends T>> g() {
                return registryKey;
            }

            @Override
            public Lifecycle h() {
                return registryLifecycle;
            }

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> resourceKey) {
                return Optional.ofNullable((Holder.c)elements.get(resourceKey));
            }

            @Override
            public Stream<Holder.c<T>> c() {
                return elements.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, i<T> bootstrap) {
        this.a.add(new k<T>(key, lifecycle, bootstrap));
        return this;
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> key, i<T> bootstrap) {
        return this.a(key, Lifecycle.stable(), bootstrap);
    }

    private b b(IRegistryCustom registryAccess) {
        b buildState = b.a(registryAccess, this.a.stream().map(k::a));
        this.a.forEach(entry -> entry.b(buildState));
        return buildState;
    }

    private static HolderLookup.a a(m owner, IRegistryCustom registryAccess, Stream<HolderLookup.b<?>> lookups) {
        record A<T>(HolderLookup.b<T> a, RegistryOps.b<T> b) {
            public static <T> A<T> a(HolderLookup.b<T> lookup) {
                return new A<T>(new d<T>(lookup, lookup), RegistryOps.b.a(lookup));
            }

            public static <T> A<T> a(m owner1, HolderLookup.b<T> lookup) {
                return new A(new d(owner1.a(), lookup), new RegistryOps.b(owner1.a(), lookup, lookup.h()));
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "lookup;opsInfo", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "lookup;opsInfo", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "lookup;opsInfo", "a", "b"}, this, o2);
            }
        }
        final HashMap map = new HashMap();
        registryAccess.a().forEach(registry -> map.put(registry.a(), A.a(registry.b())));
        lookups.forEach(lookup -> map.put(lookup.g(), A.a(owner, lookup)));
        return new HolderLookup.a(){

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> b() {
                return map.keySet().stream();
            }

            <T> Optional<A<T>> f(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
                return Optional.ofNullable((A)map.get(registryKey));
            }

            public <T> Optional<HolderLookup.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
                return this.f(registryKey).map(A::a);
            }

            @Override
            public <V> RegistryOps<V> a(DynamicOps<V> ops) {
                return RegistryOps.a(ops, new RegistryOps.c(){

                    @Override
                    public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
                        return this.f(registryKey).map(A::b);
                    }

                    @Override
                    public HolderLookup.a lookupForValueCopyViaBuilders() {
                        throw new UnsupportedOperationException("Not implemented");
                    }
                });
            }
        };
    }

    public HolderLookup.a a(IRegistryCustom registryAccess) {
        b buildState = this.b(registryAccess);
        Stream<HolderLookup.b<?>> stream = this.a.stream().map(entry -> entry.a(buildState).a(buildState.a));
        HolderLookup.a provider = RegistrySetBuilder.a(buildState.a, registryAccess, stream);
        buildState.c();
        buildState.b();
        buildState.d();
        return provider;
    }

    private HolderLookup.a a(IRegistryCustom registry, HolderLookup.a lookupProvider, Cloner.a clonerFactory, Map<ResourceKey<? extends IRegistry<?>>, j<?>> registries, HolderLookup.a registryLookupProvider) {
        m universalOwner = new m();
        MutableObject mutableObject = new MutableObject();
        List list = registries.keySet().stream().map(key -> this.a((HolderOwner)universalOwner, clonerFactory, (ResourceKey)key, registryLookupProvider, lookupProvider, (MutableObject<HolderLookup.a>)mutableObject)).collect(Collectors.toUnmodifiableList());
        HolderLookup.a provider = RegistrySetBuilder.a(universalOwner, registry, list.stream());
        mutableObject.setValue((Object)provider);
        return provider;
    }

    private <T> HolderLookup.b<T> a(HolderOwner<T> owner, Cloner.a clonerFactory, ResourceKey<? extends IRegistry<? extends T>> registryKey, HolderLookup.a registryLookupProvider, HolderLookup.a lookupProvider, MutableObject<HolderLookup.a> object) {
        Cloner cloner = clonerFactory.a(registryKey);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(registryKey.a()));
        }
        HashMap map = new HashMap();
        HolderLookup.b registryLookup = registryLookupProvider.e(registryKey);
        registryLookup.c().forEach(element -> {
            ResourceKey resourceKey = element.h();
            f lazyHolder = new f(owner, resourceKey);
            lazyHolder.a = () -> cloner.a(element.a(), registryLookupProvider, (HolderLookup.a)object.getValue());
            map.put(resourceKey, lazyHolder);
        });
        HolderLookup.b registryLookup1 = lookupProvider.e(registryKey);
        registryLookup1.c().forEach(element -> {
            ResourceKey resourceKey = element.h();
            map.computeIfAbsent(resourceKey, resourceKey1 -> {
                f lazyHolder = new f(owner, resourceKey);
                lazyHolder.a = () -> cloner.a(element.a(), lookupProvider, (HolderLookup.a)object.getValue());
                return lazyHolder;
            });
        });
        Lifecycle lifecycle = registryLookup.h().add(registryLookup1.h());
        return RegistrySetBuilder.a(registryKey, lifecycle, owner, map);
    }

    public g a(IRegistryCustom registryAccess, HolderLookup.a lookupProvider, Cloner.a clonerFactory) {
        b buildState = this.b(registryAccess);
        HashMap map = new HashMap();
        this.a.stream().map(entry -> entry.a(buildState)).forEach(registryContents -> map.put((ResourceKey<IRegistry<?>>)registryContents.a, (j<?>)registryContents));
        Set set = registryAccess.b().collect(Collectors.toUnmodifiableSet());
        lookupProvider.b().filter(registry -> !set.contains(registry)).forEach(registry -> map.putIfAbsent((ResourceKey<IRegistry<?>>)registry, new j(registry, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.b<?>> stream = map.values().stream().map(registryContents -> registryContents.a(buildState.a));
        HolderLookup.a provider = RegistrySetBuilder.a(buildState.a, registryAccess, stream);
        buildState.b();
        buildState.d();
        HolderLookup.a provider1 = this.a(registryAccess, lookupProvider, clonerFactory, map, provider);
        return new g(provider1, provider);
    }

    record k<T>(ResourceKey<? extends IRegistry<T>> a, Lifecycle b, i<T> c) {
        void b(b state) {
            this.c.run(state.a());
        }

        public j<T> a(b buildState) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, h<?>>> iterator = buildState.d.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, h<?>> entry = iterator.next();
                ResourceKey<?> resourceKey = entry.getKey();
                if (!resourceKey.c(this.a)) continue;
                h<?> registeredValue = entry.getValue();
                Holder.c<Object> reference = buildState.b.a.remove(resourceKey);
                map.put(resourceKey, new n(registeredValue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new j(this.a, this.b, map);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface i<T> {
        public void run(BootstrapContext<T> var1);
    }

    record b(m a, l b, Map<MinecraftKey, HolderGetter<?>> c, Map<ResourceKey<?>, h<?>> d, List<RuntimeException> e) {
        private final m a;
        private final l b;
        private final Map<MinecraftKey, HolderGetter<?>> c;
        private final Map<ResourceKey<?>, h<?>> d;
        private final List<RuntimeException> e;

        public static b a(IRegistryCustom registryAccess, Stream<ResourceKey<? extends IRegistry<?>>> registries) {
            m universalOwner = new m();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            l universalLookup = new l(universalOwner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            registryAccess.a().forEach(registryEntry -> builder.put((Object)registryEntry.a().a(), RegistrySetBuilder.a(registryEntry.b())));
            registries.forEach(registryKey -> builder.put((Object)registryKey.a(), (Object)universalLookup));
            return new b(universalOwner, universalLookup, (Map<MinecraftKey, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstrapContext<T> a() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.c<T> a(ResourceKey<T> key, T value, Lifecycle registryLifecycle) {
                    h registeredValue = d.put(key, new h(value, registryLifecycle));
                    if (registeredValue != null) {
                        e.add(new IllegalStateException("Duplicate registration for " + String.valueOf(key) + ", new=" + String.valueOf(value) + ", old=" + String.valueOf(registeredValue.a)));
                    }
                    return b.c(key);
                }

                @Override
                public <S> HolderGetter<S> a(ResourceKey<? extends IRegistry<? extends S>> registryKey) {
                    return c.getOrDefault(registryKey.a(), b);
                }
            };
        }

        public void b() {
            this.d.forEach((resourceKey, registeredValue) -> this.e.add(new IllegalStateException("Orpaned value " + String.valueOf(registeredValue.a) + " for key " + String.valueOf(resourceKey))));
        }

        public void c() {
            for (ResourceKey<Object> resourceKey : this.b.a.keySet()) {
                this.e.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourceKey)));
            }
        }

        public void d() {
            if (!this.e.isEmpty()) {
                IllegalStateException illegalStateException = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeException : this.e) {
                    illegalStateException.addSuppressed(runtimeException);
                }
                throw illegalStateException;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this, o2);
        }

        public m e() {
            return this.a;
        }

        public l f() {
            return this.b;
        }

        public Map<MinecraftKey, HolderGetter<?>> g() {
            return this.c;
        }

        public Map<ResourceKey<?>, h<?>> h() {
            return this.d;
        }

        public List<RuntimeException> i() {
            return this.e;
        }
    }

    static class m
    implements HolderOwner<Object> {
        m() {
        }

        public <T> HolderOwner<T> a() {
            return this;
        }
    }

    public record g(HolderLookup.a a, HolderLookup.a b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "full;patches", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "full;patches", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "full;patches", "a", "b"}, this, o2);
        }
    }

    record j<T>(ResourceKey<? extends IRegistry<? extends T>> a, Lifecycle b, Map<ResourceKey<T>, n<T>> c) {
        public HolderLookup.b<T> a(m owner) {
            Map map = this.c.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                n valueAndHolder = (n)entry.getValue();
                Holder.c reference = valueAndHolder.b().orElseGet(() -> Holder.c.a(owner.a(), (ResourceKey)entry.getKey()));
                reference.b(valueAndHolder.a().a());
                return reference;
            }));
            return RegistrySetBuilder.a(this.a, this.b, owner.a(), map);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "key;lifecycle;values", "a", "b", "c"}, this, o2);
        }
    }

    static class f<T>
    extends Holder.c<T> {
        @Nullable
        Supplier<T> a;

        protected f(HolderOwner<T> owner, @Nullable ResourceKey<T> key) {
            super(Holder.c.a.a, owner, key, null);
        }

        @Override
        protected void b(T value) {
            super.b(value);
            this.a = null;
        }

        @Override
        public T a() {
            if (this.a != null) {
                this.b(this.a.get());
            }
            return super.a();
        }
    }

    record n<T>(h<T> a, Optional<Holder.c<T>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{n.class, "value;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{n.class, "value;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{n.class, "value;holder", "a", "b"}, this, o2);
        }
    }

    static class l
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> a = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public l(HolderOwner<Object> owner) {
            super(owner);
        }

        @Override
        public Optional<Holder.c<Object>> a(ResourceKey<Object> resourceKey) {
            return Optional.of(this.c(resourceKey));
        }

        <T> Holder.c<T> c(ResourceKey<T> key) {
            return this.a.computeIfAbsent(key, resourceKey -> Holder.c.a(this.d, resourceKey));
        }
    }

    record h<T>(T a, Lifecycle b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "value;lifecycle", "a", "b"}, this, o2);
        }
    }

    static abstract class e<T>
    extends c<T>
    implements HolderLookup.b<T> {
        protected e(HolderOwner<T> owner) {
            super(owner);
        }

        @Override
        public Stream<HolderSet.Named<T>> e() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static class d<T>
    extends e<T>
    implements HolderLookup.b.a<T> {
        private final HolderLookup.b<T> a;

        d(HolderOwner<T> owner, HolderLookup.b<T> parent) {
            super(owner);
            this.a = parent;
        }

        @Override
        public HolderLookup.b<T> a() {
            return this.a;
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> d;

        protected c(HolderOwner<T> owner) {
            this.d = owner;
        }

        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tagKey) {
            return Optional.of(HolderSet.a(this.d, tagKey));
        }
    }
}

