/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public final class PatchedDataComponentMap
implements DataComponentMap {
    private final DataComponentMap c;
    private Reference2ObjectMap<DataComponentType<?>, Optional<?>> d;
    private boolean e;

    public PatchedDataComponentMap(DataComponentMap prototype) {
        this(prototype, Reference2ObjectMaps.emptyMap(), true);
    }

    private PatchedDataComponentMap(DataComponentMap prototype, Reference2ObjectMap<DataComponentType<?>, Optional<?>> patch, boolean copyOnWrite) {
        this.c = prototype;
        this.d = patch;
        this.e = copyOnWrite;
    }

    public static PatchedDataComponentMap a(DataComponentMap prototype, DataComponentPatch patch) {
        if (PatchedDataComponentMap.a(prototype, patch.e)) {
            return new PatchedDataComponentMap(prototype, patch.e, true);
        }
        PatchedDataComponentMap patchedDataComponentMap = new PatchedDataComponentMap(prototype);
        patchedDataComponentMap.a(patch);
        return patchedDataComponentMap;
    }

    private static boolean a(DataComponentMap prototype, Reference2ObjectMap<DataComponentType<?>, Optional<?>> map) {
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(map)) {
            Object object = prototype.a((DataComponentType)entry.getKey());
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent() && optional.get().equals(object)) {
                return false;
            }
            if (!optional.isEmpty() || object != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        Optional optional = (Optional)this.d.get(component);
        return (T)(optional != null ? optional.orElse(null) : (T)this.c.a(component));
    }

    public boolean d(DataComponentType<?> component) {
        return this.d.containsKey(component);
    }

    @Nullable
    public <T> T b(DataComponentType<T> component, @Nullable T value) {
        this.j();
        T object = this.c.a(component);
        Optional optional = Objects.equals(value, object) ? (Optional)this.d.remove(component) : (Optional)this.d.put(component, Optional.ofNullable(value));
        return optional != null ? optional.orElse(object) : object;
    }

    @Nullable
    public <T> T a(TypedDataComponent<T> component) {
        return this.b(component.a(), component.b());
    }

    @Nullable
    public <T> T e(DataComponentType<? extends T> component) {
        this.j();
        T object = this.c.a(component);
        Optional optional = object != null ? (Optional)this.d.put(component, Optional.empty()) : (Optional)this.d.remove(component);
        return (T)(optional != null ? optional.orElse(null) : object);
    }

    public void a(DataComponentPatch patch) {
        this.j();
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(patch.e)) {
            this.a((DataComponentType)entry.getKey(), (Optional)entry.getValue());
        }
    }

    private void a(DataComponentType<?> component, Optional<?> value) {
        Object object = this.c.a(component);
        if (value.isPresent()) {
            if (value.get().equals(object)) {
                this.d.remove(component);
            } else {
                this.d.put(component, value);
            }
        } else if (object != null) {
            this.d.put(component, Optional.empty());
        } else {
            this.d.remove(component);
        }
    }

    public void b(DataComponentPatch patch) {
        this.j();
        this.d.clear();
        this.d.putAll(patch.e);
    }

    public void f() {
        this.j();
        this.d.clear();
    }

    public void a(DataComponentMap map) {
        for (TypedDataComponent<?> typedDataComponent : map) {
            typedDataComponent.a(this);
        }
    }

    private void j() {
        if (this.e) {
            this.d = new Reference2ObjectArrayMap(this.d);
            this.e = false;
        }
    }

    @Override
    public Set<DataComponentType<?>> b() {
        if (this.d.isEmpty()) {
            return this.c.b();
        }
        ReferenceArraySet set = new ReferenceArraySet(this.c.b());
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.d)) {
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                set.add((DataComponentType)entry.getKey());
                continue;
            }
            set.remove(entry.getKey());
        }
        return set;
    }

    @Override
    public Iterator<TypedDataComponent<?>> iterator() {
        if (this.d.isEmpty()) {
            return this.c.iterator();
        }
        ArrayList<TypedDataComponent> list = new ArrayList<TypedDataComponent>(this.d.size() + this.c.d());
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.d)) {
            if (!((Optional)entry.getValue()).isPresent()) continue;
            list.add(TypedDataComponent.a((DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get()));
        }
        for (TypedDataComponent typedDataComponent : this.c) {
            if (this.d.containsKey(typedDataComponent.a())) continue;
            list.add(typedDataComponent);
        }
        return list.iterator();
    }

    @Override
    public int d() {
        int size = this.c.d();
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.d)) {
            boolean hasDataComponentType;
            boolean isPresent = ((Optional)entry.getValue()).isPresent();
            if (isPresent == (hasDataComponentType = this.c.c((DataComponentType)entry.getKey()))) continue;
            size += isPresent ? 1 : -1;
        }
        return size;
    }

    public DataComponentPatch g() {
        if (this.d.isEmpty()) {
            return DataComponentPatch.a;
        }
        this.e = true;
        return new DataComponentPatch(this.d);
    }

    public PatchedDataComponentMap h() {
        this.e = true;
        return new PatchedDataComponentMap(this.c, this.d, true);
    }

    public DataComponentMap i() {
        return this.d.isEmpty() ? this.c : this.h();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof PatchedDataComponentMap)) return false;
        PatchedDataComponentMap patchedDataComponentMap = (PatchedDataComponentMap)other;
        if (!this.c.equals(patchedDataComponentMap.c)) return false;
        if (!this.d.equals(patchedDataComponentMap.d)) return false;
        return true;
    }

    public int hashCode() {
        return this.c.hashCode() + this.d.hashCode() * 31;
    }

    public String toString() {
        return "{" + this.c().map(TypedDataComponent::toString).collect(Collectors.joining(", ")) + "}";
    }
}

