/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;

public class DispenseBehaviorItem
implements IDispenseBehavior {
    private static final int c = 6;
    private EnumDirection direction;

    @Override
    public final net.minecraft.world.item.ItemStack dispense(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        this.direction = blockSource.d().c(BlockDispenser.b);
        net.minecraft.world.item.ItemStack itemStack = this.a(blockSource, item);
        this.a(blockSource);
        this.a(blockSource, this.direction);
        return itemStack;
    }

    protected net.minecraft.world.item.ItemStack a(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        IPosition dispensePosition = BlockDispenser.a(blockSource);
        net.minecraft.world.item.ItemStack itemStack = item.a(1);
        if (!DispenseBehaviorItem.spawnItem(blockSource.b(), itemStack, 6, this.direction, dispensePosition, blockSource)) {
            item.g(1);
        }
        return item;
    }

    public static void a(World level, net.minecraft.world.item.ItemStack stack, int speed, EnumDirection facing, IPosition position) {
        EntityItem itemEntity = DispenseBehaviorItem.prepareItem(level, stack, speed, facing, position);
        level.b(itemEntity);
    }

    private static EntityItem prepareItem(World level, net.minecraft.world.item.ItemStack stack, int speed, EnumDirection facing, IPosition position) {
        double d2 = position.a();
        double d1 = position.b();
        double d22 = position.c();
        d1 = facing.o() == EnumDirection.EnumAxis.b ? (d1 -= 0.125) : (d1 -= 0.15625);
        EntityItem itemEntity = new EntityItem(level, d2, d1, d22, stack);
        double d3 = level.z.j() * 0.1 + 0.2;
        itemEntity.m(level.z.a((double)facing.j() * d3, 0.0172275 * (double)speed), level.z.a(0.2, 0.0172275 * (double)speed), level.z.a((double)facing.l() * d3, 0.0172275 * (double)speed));
        return itemEntity;
    }

    public static boolean spawnItem(World level, net.minecraft.world.item.ItemStack stack, int speed, EnumDirection facing, IPosition position, SourceBlock blockSource) {
        if (stack.f()) {
            return true;
        }
        EntityItem itemEntity = DispenseBehaviorItem.prepareItem(level, stack, speed, facing, position);
        CraftBlock block = CraftBlock.at(level, blockSource.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), CraftVector.toBukkit(itemEntity.dI()));
        level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        itemEntity.a(CraftItemStack.asNMSCopy(event.getItem()));
        itemEntity.k(CraftVector.toVec3(event.getVelocity()));
        if (blockSource.d().a(Blocks.bb) && !event.getItem().getType().equals((Object)craftItem.getType())) {
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior dispenseBehavior = BlockDispenser.getDispenseBehavior(blockSource, eventStack);
            if (dispenseBehavior != IDispenseBehavior.b && dispenseBehavior.getClass() != DispenseBehaviorItem.class) {
                dispenseBehavior.dispense(blockSource, eventStack);
            } else {
                level.b(itemEntity);
            }
            return false;
        }
        level.b(itemEntity);
        return true;
    }

    protected void a(SourceBlock blockSource) {
        DispenseBehaviorItem.b(blockSource);
    }

    protected void a(SourceBlock blockSource, EnumDirection direction) {
        DispenseBehaviorItem.b(blockSource, direction);
    }

    private static void b(SourceBlock blockSource) {
        blockSource.b().c(1000, blockSource.c(), 0);
    }

    private static void b(SourceBlock blockSource, EnumDirection direction) {
        blockSource.b().c(2000, blockSource.c(), direction.d());
    }

    protected net.minecraft.world.item.ItemStack a(SourceBlock blockSource, net.minecraft.world.item.ItemStack stack, net.minecraft.world.item.ItemStack remainder) {
        stack.h(1);
        if (stack.f()) {
            return remainder;
        }
        this.b(blockSource, remainder);
        return stack;
    }

    private void b(SourceBlock blockSource, net.minecraft.world.item.ItemStack remainder) {
        net.minecraft.world.item.ItemStack itemStack = blockSource.e().b(remainder);
        if (!itemStack.f()) {
            EnumDirection direction = blockSource.d().c(BlockDispenser.b);
            DispenseBehaviorItem.a(blockSource.b(), itemStack, 6, direction, BlockDispenser.a(blockSource));
            DispenseBehaviorItem.b(blockSource);
            DispenseBehaviorItem.b(blockSource, direction);
        }
    }
}

