/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.block.BlockDispenser;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.projectiles.CraftBlockProjectileSource;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenseBehaviorProjectile
extends DispenseBehaviorItem {
    private final ProjectileItem c;
    private final ProjectileItem.a d;

    public DispenseBehaviorProjectile(Item projectile) {
        ProjectileItem projectileItem;
        if (!(projectile instanceof ProjectileItem)) {
            throw new IllegalArgumentException(String.valueOf(projectile) + " not instance of " + ProjectileItem.class.getSimpleName());
        }
        this.c = projectileItem = (ProjectileItem)((Object)projectile);
        this.d = projectileItem.a();
    }

    @Override
    public net.minecraft.world.item.ItemStack a(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        WorldServer serverLevel = blockSource.b();
        EnumDirection direction = blockSource.d().c(BlockDispenser.b);
        IPosition dispensePosition = this.d.b().getDispensePosition(blockSource, direction);
        net.minecraft.world.item.ItemStack singleItemStack = item.c(1);
        CraftBlock block = CraftBlock.at(serverLevel, blockSource.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(singleItemStack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), new Vector(direction.j(), direction.k(), direction.l()));
        serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return item;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior dispenseBehavior = BlockDispenser.getDispenseBehavior(blockSource, eventStack);
            if (dispenseBehavior != IDispenseBehavior.b && dispenseBehavior != this) {
                dispenseBehavior.dispense(blockSource, eventStack);
                return item;
            }
        }
        if (!singleItemStack.f()) {
            IProjectile projectile = IProjectile.a(this.c.a(serverLevel, dispensePosition, CraftItemStack.unwrap(event.getItem()), direction), serverLevel, singleItemStack, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.d.d(), this.d.c());
            projectile.projectileSource = new CraftBlockProjectileSource(blockSource.e());
        }
        if (shrink) {
            item.h(1);
        }
        return item;
    }

    @Override
    protected void a(SourceBlock blockSource) {
        blockSource.b().c(this.d.e().orElse(1002), blockSource.c(), 0);
    }
}

